/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.data.TableDataSource;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.report.Report;
import com.fr.schedule.entry.EntryManager;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ExecuteCondition;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.web.core.Reportlet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReportletJob
implements Job {
    protected static final int MINUTES = 60;
    protected static final int MILLISECOND = 1000;
    protected static Set fireTimeAndTaskID = new HashSet();
    protected static final String FORMULA_PARAMETER_NAME = "executeFormula";
    protected ScheduleTask scheduleTask;
    protected String reportPath;
    protected Date scheduledFireTime;
    protected JobDataMap jobDataMap;
    protected long taskID;
    protected Reportlet reportlet;
    protected List<Map> record_list;
    protected List<Parameter> arrayParaList;
    protected FRLogger log = FRLogger.getLogger();

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (!this.initData(jobExecutionContext)) {
            return;
        }
        if (!this.checkExecuteClass()) {
            return;
        }
        this.executeReport();
    }

    protected abstract void executeReport();

    private boolean initData(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            this.scheduledFireTime = jobExecutionContext.getScheduledFireTime();
            this.jobDataMap = jobExecutionContext.getMergedJobDataMap();
            this.taskID = this.jobDataMap.getLong("__task__");
            if (this.checkIsDuplicated()) {
                return false;
            }
            this.scheduleTask = this.jobDataMap.get((Object)"__restarttask__") != null ? (ScheduleTask)this.jobDataMap.get((Object)"__restarttask__") : (ScheduleTask)ScheduleContext.createDAOSession().load(ScheduleTask.class, this.taskID);
            if (this.scheduleTask == null || this.scheduleTask.getScheduledOutput() == null && this.scheduleTask.getShowType() != 0) {
                return false;
            }
            this.reportPath = this.scheduleTask.getReportletPath();
            if (this.reportPath == null) {
                this.logReportPathError();
                return false;
            }
            this.logTipInfo();
            return true;
        }
        catch (RuntimeException runtimeException) {
            ScheduleLogUtils.error(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            return false;
        }
    }

    private boolean checkIsDuplicated() {
        if (fireTimeAndTaskID.contains(this.scheduledFireTime.getTime() + "_" + this.taskID)) {
            return true;
        }
        fireTimeAndTaskID.add(this.scheduledFireTime.getTime() + "_" + this.taskID);
        return false;
    }

    protected Parameter[] getExecuteParameter() {
        Parameter[] parameterArray = this.scheduleTask.getParametersToArray();
        if (this.scheduleTask.getExecuteType() == 1) {
            Parameter parameter = new Parameter();
            parameter.setName(FORMULA_PARAMETER_NAME);
            FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
            formulaProvider.setContent(this.scheduleTask.getExecuteFormula());
            parameter.setValue(formulaProvider);
            int n2 = 0;
            if (parameterArray != null) {
                n2 = parameterArray.length;
            }
            Parameter[] parameterArray2 = new Parameter[n2 + 1];
            if (n2 > 0) {
                System.arraycopy(parameterArray, 0, parameterArray2, 0, parameterArray.length);
            }
            parameterArray2[n2] = parameter;
            return parameterArray2;
        }
        return parameterArray;
    }

    private boolean checkExecuteClass() {
        if (this.scheduleTask.getExecuteType() != 2) {
            return true;
        }
        return this.executeClass();
    }

    private boolean executeClass() {
        try {
            ExecuteCondition executeCondition;
            boolean bl;
            String string = this.scheduleTask.getExecuteClass();
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            if (!(bl = (executeCondition = (ExecuteCondition)GeneralUtils.classForName(string).newInstance()).execute())) {
                this.log.scheduleInfo(this.scheduleTask.getName(), this.getExecuteFailLog(), Inter.getLocText("Skip_Execute"));
                this.restartTask();
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.scheduleError(this.scheduleTask.getName(), this.getExecuteFailLog(), exception);
            this.restartTask();
            return false;
        }
    }

    protected boolean checkExecuteFormula(Map map, ResultWorkBook resultWorkBook) {
        if (this.scheduleTask.getExecuteType() != 1) {
            return true;
        }
        try {
            Formula formula = (Formula)map.get(FORMULA_PARAMETER_NAME);
            Boolean bl = this.evaluateFormula(formula, resultWorkBook);
            if (!bl.booleanValue()) {
                this.log.scheduleInfo(this.scheduleTask.getName(), this.getExecuteFailLog(), Inter.getLocText("Skip_Execute"));
                this.restartTask();
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.scheduleError(this.scheduleTask.getName(), this.getExecuteFailLog(), exception);
            this.restartTask();
            return false;
        }
    }

    protected void dealWithException(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheduleTask.getShowType() == 1 || this.scheduleTask.getShowType() == 2) {
            stringBuilder.append(Inter.getLocText("CPR_FAILED"));
        } else {
            stringBuilder.append(ScheduleLogUtils.combineByColon("Reporting-Schedule-Action", Inter.getLocText("Failed")));
        }
        if (this.scheduleTask.getCounts() > 0) {
            stringBuilder.append(ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts()));
        }
        this.log.scheduleError(this.scheduleTask.getName(), stringBuilder.toString(), exception);
        this.restartTask();
        ScheduleLogUtils.error(exception);
    }

    protected void logReportPathError() {
        this.log.error("[Schedule] ReportletJob : Report path is Null...");
    }

    protected String getExecuteFailLog() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheduleTask.getShowType() == 0) {
            stringBuilder.append(ScheduleLogUtils.combineByColon("Reporting-Schedule-Action", Inter.getLocText("Skip")));
        } else {
            stringBuilder.append(Inter.getLocText("CPR_SKIP"));
        }
        if (this.scheduleTask.getCounts() > 0) {
            stringBuilder.append(ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts()));
        }
        return stringBuilder.toString();
    }

    protected void logTipInfo() {
        this.log.info("[Schedule] The Task '" + this.scheduleTask.getName() + "' of " + this.reportPath + " starts! ReportPath : " + this.reportPath);
    }

    protected void restartTask() {
        EntryManager.reStartTask(this.scheduleTask, Integer.parseInt(this.scheduleTask.getRepeatTime()) * 60 * 1000);
    }

    protected Boolean evaluateFormula(Formula formula, ResultWorkBook resultWorkBook) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.scheduledFireTime.getTime());
        Calculator calculator = Calculator.createCalculator();
        calculator.set("$date", calendar.getTime());
        calculator.setAttribute(Report.class, resultWorkBook.getReport(0));
        calculator.pushNameSpace(SimpleCellValueNameSpace.getInstance());
        calculator.setAttribute(TableDataSource.class, resultWorkBook);
        try {
            Object object = calculator.evalValue(formula);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }
        catch (UtilEvalError utilEvalError) {
            return false;
        }
    }
}

