/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.entry;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.web.platform.TransmitParameters;
import com.fr.web.platform.entry.BaseEntry;

public class ReportletEntry
extends BaseEntry {
    public static final String TYPE_PREFIX = "2";
    public static final String TABLE_NAME = "fr_reportletentry";
    public static final String TRANSMITPARAMETERS = "transmitParameters";
    public static final String ISVIEW = "isView";
    public static final String COLUMN_WEBLETPATH = "reportletPath";
    public static final int TRANSMITPARAMETERSTYPE = 12;
    public static final int ISVIEWTYPE = 4;
    public static final int REPORTLETPATHTYPE = 12;
    public static final ObjectTableMapper TABLE_MAPPER = new ObjectTableMapper(ReportletEntry.class, new Table("fr_reportletentry"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(10)), new CommonFieldColumnMapper("parentId", 4, "parent", new ColumnSize(10), false), new CommonFieldColumnMapper("displayName", 12, "name", new ColumnSize(255), false), new CommonFieldColumnMapper("webletPath", 12, "reportletPath", new ColumnSize(255), false), new CommonFieldColumnMapper("description", 12, "description", new ColumnSize(255), true), new CommonFieldColumnMapper("showType", 4, "isView", new ColumnSize(5), false), new CommonFieldColumnMapper("transmitParameters", 12, "transmitParameters", new ColumnSize(1023), true, TransmitParameters.TRANPARAM_VALUE_MAPPER), new CommonFieldColumnMapper("sortindex", -5, "sortindex", new ColumnSize(10), true)}, 0);
    private static final long serialVersionUID = 1L;
    private int showType = 1;
    private int prime = 31;
    private String webletPath = null;
    private TransmitParameters transmitParameters = null;

    public ReportletEntry() {
        this("");
    }

    public ReportletEntry(String string) {
        this.setWebletPath(string);
    }

    public ReportletEntry(String string, String string2, String string3) {
        super(string, string2);
        this.webletPath = string3;
    }

    public JSONObject createShowJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        String string = "cpt";
        if (this.webletPath.endsWith("frm") || this.webletPath.endsWith("form")) {
            string = "frm";
        }
        jSONObject.put("nodeicon", string);
        jSONObject.put("showType", this.showType);
        return jSONObject;
    }

    public boolean isForm() {
        return this.webletPath.endsWith("frm") || this.webletPath.endsWith("form");
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        String string = "cpt";
        if (this.webletPath.endsWith("frm") || this.webletPath.endsWith("form")) {
            string = "frm";
        }
        jSONObject.put("nodeicon", string);
        jSONObject.put("showType", this.showType);
        jSONObject.put("path", this.getWebletPath());
        if (this.transmitParameters != null && this.transmitParameters.size() > 0) {
            jSONObject.put(TRANSMITPARAMETERS, this.transmitParameters.createJSON());
        }
        return jSONObject;
    }

    public boolean isReportletWrite() {
        return this.showType == 0;
    }

    public boolean isReportletView() {
        return this.showType == 2;
    }

    public boolean isReportletPage() {
        return this.showType == 1;
    }

    public void setShowType(int n2) {
        this.showType = n2;
    }

    public void setWebletPath(String string) {
        this.webletPath = string;
    }

    public int getShowType() {
        return this.showType;
    }

    public String getWebletPath() {
        return this.webletPath;
    }

    protected int hashCode4Properties() {
        int n2 = super.hashCode4Properties();
        n2 = this.prime * n2 + this.showType;
        n2 = this.prime * n2 + (this.webletPath == null ? 0 : this.webletPath.hashCode());
        n2 = this.prime * n2 + (this.transmitParameters == null ? 0 : this.transmitParameters.hashCode());
        n2 = this.prime * n2 + (int)(this.sortindex ^ this.sortindex >>> 32);
        return n2;
    }

    public boolean equals4Properties(Object object) {
        if (!(object instanceof ReportletEntry)) {
            return false;
        }
        if (!super.equals4Properties(object)) {
            return false;
        }
        ReportletEntry reportletEntry = (ReportletEntry)object;
        return ComparatorUtils.equals(reportletEntry.getWebletPath(), this.getWebletPath()) && reportletEntry.showType == this.showType && ComparatorUtils.equals(reportletEntry.transmitParameters, this.transmitParameters) && this.sortindex == reportletEntry.sortindex;
    }

    public Object clone() throws CloneNotSupportedException {
        ReportletEntry reportletEntry = (ReportletEntry)super.clone();
        if (this.transmitParameters != null) {
            reportletEntry.transmitParameters = (TransmitParameters)this.transmitParameters.clone();
        }
        return reportletEntry;
    }

    public String getTypePrefix() {
        return TYPE_PREFIX;
    }

    public TransmitParameters getTransmitParameters() {
        return this.transmitParameters;
    }

    public void setTransmitParameters(TransmitParameters transmitParameters) {
        this.transmitParameters = transmitParameters;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        super.parseJSON(jSONObject);
        this.setWebletPath(jSONObject.getString("path"));
        this.setShowType(jSONObject.getInt("showType"));
        JSONArray jSONArray = null;
        try {
            jSONArray = jSONObject.getJSONArray(TRANSMITPARAMETERS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jSONArray != null) {
            this.setTransmitParameters(TransmitParameters.parseJSON(jSONArray));
        }
    }

    public int getEntryType() {
        return 2;
    }

    public static class SHOW_TYPE {
        public static final int WRITE = 0;
        public static final int PAGE = 1;
        public static final int VIEW = 2;
    }
}

