/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule;

import com.fr.data.dao.DAOManagerFactory;
import com.fr.data.dao.DAOSession;
import com.fr.data.dao.JDBCDAOManager;
import com.fr.fs.dao.properties.ScheduleDAOProperties;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.third.org.quartz.Scheduler;

public abstract class ScheduleContext {
    private static JDBCDAOManager jdbcDaoManager;
    private static Scheduler scheduler;

    public static JDBCDAOManager getJdbcDaoManager() {
        if (jdbcDaoManager == null) {
            jdbcDaoManager = DAOManagerFactory.createJDBCDAOManager(ScheduleDAOProperties.getInstance());
        }
        return jdbcDaoManager;
    }

    public static DAOSession createDAOSession() {
        return ScheduleContext.getJdbcDaoManager().startSession();
    }

    public static void setScheduler(Scheduler scheduler) {
        ScheduleContext.scheduler = scheduler;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                jdbcDaoManager = null;
            }
        });
    }
}

