/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.base;

import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.EntryControl;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportWebUtils;
import com.fr.web.platform.entry.Entry;
import java.util.ArrayList;
import java.util.Set;

public class FSPrivilegeTools {
    public static final int FILTERLEVELPAGE = 1;
    public static final int FILTERLEVELWRITE = 2;
    public static final int FILTERLEVELDESIGN = 3;
    public static final int FILTERLEVELNONE = 0;
    private static FSPrivilegeTools FSPT = new FSPrivilegeTools();

    private FSPrivilegeTools() {
    }

    public static FSPrivilegeTools getInstance() {
        return FSPT;
    }

    public boolean hasFolderEditPrivilege(Set set, EntryTypeAndID entryTypeAndID) {
        if (set.contains(EntryTypeAndID.getInstance(0, -1L))) {
            return true;
        }
        for (Object e2 : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e2;
            if (ComparatorUtils.equals(entryTypeAndID2, entryTypeAndID) && entryTypeAndID2.getEdit() == 1L) {
                return true;
            }
            if (entryTypeAndID2.getType() != 0 || entryTypeAndID2.getEdit() != 1L) continue;
            Entry entry = EntryControl.getInstance().getEntry(entryTypeAndID.getType(), entryTypeAndID.getId());
            while (entry.getParentId() > 0L) {
                if (entry.getParentId() == entryTypeAndID2.getId()) {
                    return true;
                }
                entry = EntryControl.getInstance().getEntry(0, entry.getParentId());
            }
        }
        return false;
    }

    public EntryTypeAndID getEntryPrivilege(Set set, EntryTypeAndID entryTypeAndID) {
        EntryTypeAndID entryTypeAndID2 = this.getEntryPrivilegeNoFolder(set, entryTypeAndID);
        if (entryTypeAndID2.getView() != 0L) {
            return entryTypeAndID2;
        }
        Entry entry = EntryControl.getInstance().getEntry(entryTypeAndID.getType(), entryTypeAndID.getId());
        while (entry.getParentId() > 0L) {
            EntryTypeAndID entryTypeAndID3 = this.getEntryPrivilegeNoFolder(set, EntryTypeAndID.getInstance(0, entry.getParentId()));
            if (entryTypeAndID3.getView() != 0L) {
                if (entryTypeAndID3.getView() != 1L) {
                    return entryTypeAndID;
                }
                entryTypeAndID.setView(1L);
                if (entryTypeAndID3.getAuthorized() != 1L) {
                    return entryTypeAndID;
                }
                entryTypeAndID.setAuthorized(1L);
                if (entryTypeAndID3.getEdit() != 1L) {
                    return entryTypeAndID;
                }
                entryTypeAndID.setEdit(1L);
                return entryTypeAndID;
            }
            entry = EntryControl.getInstance().getEntry(0, entry.getParentId());
        }
        if (set.contains(EntryTypeAndID.getInstance(0, -1L))) {
            entryTypeAndID.setView(1L);
            entryTypeAndID.setAuthorized(1L);
            entryTypeAndID.setEdit(1L);
        }
        return entryTypeAndID;
    }

    public boolean hasDesignPrivilege(String string, Set set) throws Exception {
        string = StringUtils.perfectStart(string, "/");
        for (Object e2 : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)e2;
            String string2 = StringUtils.perfectStart(roleTemplatePrivilege.getPath(), "/");
            if (roleTemplatePrivilege.getDesign() != 1L || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPageOrWritePrivilege(String string, Set set) throws Exception {
        string = StringUtils.perfectStart(string, "/");
        for (Object e2 : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)e2;
            String string2 = StringUtils.perfectStart(roleTemplatePrivilege.getPath(), "/");
            if (roleTemplatePrivilege.getPage() != 1L && roleTemplatePrivilege.getWrite() != 1L || !ComparatorUtils.equals(string2, string)) continue;
            return true;
        }
        return false;
    }

    public void filterFile(FileNode[] fileNodeArray, Set set, ArrayList arrayList, int n2) throws Exception {
        block0: for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            int n3;
            String string = fileNodeArray[i2].getEnvPath();
            String string2 = string.substring(n3 = string.indexOf("/"));
            if (StringUtils.isBlank(string2)) continue;
            for (Object e2 : set) {
                RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)e2;
                if (!this.hasPrivilege(roleTemplatePrivilege, n2) || !this.examineTemplatePath(fileNodeArray[i2], roleTemplatePrivilege)) continue;
                fileNodeArray[i2].setPage(roleTemplatePrivilege.getPage());
                fileNodeArray[i2].setWrite(roleTemplatePrivilege.getWrite());
                fileNodeArray[i2].setDesign(roleTemplatePrivilege.getDesign());
                arrayList.add(fileNodeArray[i2]);
                continue block0;
            }
        }
    }

    private boolean examineTemplatePath(FileNode fileNode, RoleTemplatePrivilege roleTemplatePrivilege) {
        String[] stringArray;
        int n2;
        String string = fileNode.getEnvPath();
        String string2 = string.substring(n2 = string.indexOf("/"));
        if (ComparatorUtils.equals(string2, "/" + roleTemplatePrivilege.getPath())) {
            return true;
        }
        String[] stringArray2 = StringUtils.perfectStart(string2, "/").split("/");
        if (stringArray2.length > (stringArray = StringUtils.perfectStart(roleTemplatePrivilege.getPath(), "/").split("/")).length) {
            int n3 = stringArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (ComparatorUtils.equals(stringArray2[i2], stringArray[i2])) continue;
                return false;
            }
            return true;
        }
        if (fileNode.isDirectory() && stringArray.length > stringArray2.length) {
            int n4 = stringArray2.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                if (ComparatorUtils.equals(stringArray2[i3], stringArray[i3])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static JSONArray getReportletsOfCurrentEnv(FileNode[] fileNodeArray, Set set, IdGenerator idGenerator, String string, int n2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        fileNodeArray = ReportWebUtils.filterAndSortFile(fileNodeArray, string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            FileNode fileNode = fileNodeArray[i2];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put(jSONObject);
            try {
                jSONObject.put("id", idGenerator.generateId());
                jSONObject.put("text", fileNode.getName());
                jSONObject.put("value", fileNode.getName());
                jSONObject.put("path", string2);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                jSONObject.put("page", fileNode.getPage());
                jSONObject.put("write", fileNode.getWrite());
                jSONObject.put("design", fileNode.getDesign());
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("hasChildren", true);
                FileNode[] fileNodeArray2 = FRContext.getCurrentEnv().listFile(fileNode.getEnvPath());
                ArrayList arrayList = new ArrayList();
                FSPrivilegeTools.getInstance().filterFile(fileNodeArray2, set, arrayList, n2);
                FileNode[] fileNodeArray3 = new FileNode[arrayList.size()];
                int n3 = arrayList.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    fileNodeArray3[i3] = (FileNode)arrayList.get(i3);
                }
                jSONObject.put("ChildNodes", FSPrivilegeTools.getReportletsOfCurrentEnv(fileNodeArray3, set, idGenerator, string, n2));
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return jSONArray;
    }

    private boolean isCptOrFrm(RoleTemplatePrivilege roleTemplatePrivilege) {
        String string = roleTemplatePrivilege.getPath();
        return string.endsWith(".cpt") || string.endsWith(".frm");
    }

    private boolean hasPrivilege(RoleTemplatePrivilege roleTemplatePrivilege, int n2) {
        if (n2 == 1) {
            return roleTemplatePrivilege.getPage() == 1L;
        }
        if (n2 == 2) {
            return roleTemplatePrivilege.getWrite() == 1L;
        }
        if (n2 == 3) {
            return roleTemplatePrivilege.getDesign() == 1L;
        }
        return true;
    }

    private long getEditFromParent(Set set, Entry entry) {
        while (entry != null && entry.getParentId() > 0L) {
            EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(0, entry.getParentId());
            for (Object e2 : set) {
                EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e2;
                if (!ComparatorUtils.equals(entryTypeAndID2, entryTypeAndID)) continue;
                return entryTypeAndID2.getEdit();
            }
            entry = EntryControl.getInstance().getEntry(0, entry.getParentId());
        }
        return 0L;
    }

    private EntryTypeAndID getEntryPrivilegeNoFolder(Set set, EntryTypeAndID entryTypeAndID) {
        for (Object e2 : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e2;
            if (!ComparatorUtils.equals(entryTypeAndID2, entryTypeAndID)) continue;
            return entryTypeAndID2;
        }
        return entryTypeAndID;
    }
}

