/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.UserControl;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Iterator;
import java.util.Set;

public class UserNamePassWordFSAuthenticationProvider
extends AbstractAuthenticationProvider {
    private boolean needPassword = true;
    private static final UserNamePassWordFSAuthenticationProvider SC = new UserNamePassWordFSAuthenticationProvider();

    private UserNamePassWordFSAuthenticationProvider() {
    }

    public static UserNamePassWordFSAuthenticationProvider getInstance() {
        return SC;
    }

    public UserNamePassWordFSAuthenticationProvider(boolean bl) {
        this.needPassword = bl;
    }

    public boolean authenticate(Authentication authentication) throws Exception {
        String string = authentication.getPrincipal() != null ? authentication.getPrincipal().toString() : null;
        String string2 = authentication.getCredentials() != null ? authentication.getCredentials().toString() : null;
        User user = this.needPassword ? UserControl.getInstance().getUser(string, string2) : UserControl.getInstance().getByUserName(string);
        if (user == null) {
            return false;
        }
        authentication.setAuthenticated(true);
        if (user.getId() == UserControl.getInstance().getSuperManagerID()) {
            authentication.setRoot(true);
        }
        Authority[] authorityArray = this.addAuthorities(user);
        authentication.setAuthorities(authorityArray);
        return true;
    }

    private Authority[] addAuthorities(User user) throws Exception {
        Object object;
        long l2 = user.getId();
        Set set = UserCache.getSRoles(l2);
        Set set2 = UserCache.getAllCompanyRoleNames(l2);
        Authority[] authorityArray = new Authority[set.size() + set2.size()];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = ((CustomRole)iterator.next()).getRolename();
            authorityArray[n2] = new Authority((String)object);
            ++n2;
        }
        object = set2.iterator();
        while (object.hasNext()) {
            String string = object.next().toString();
            authorityArray[n2] = new Authority(string);
            ++n2;
        }
        return authorityArray;
    }

    public int uType() {
        return 3;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean isNeedPassword() {
        return this.needPassword;
    }

    public void setNeedPassword(boolean bl) {
        this.needPassword = bl;
    }
}

