/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.stable.StringUtils;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationProvider {
    private String url = "ldap://ip:389";
    private LdapContext ctx;
    private Control[] connCtls = null;

    private LdapAuthenticationProvider() {
    }

    public static LdapAuthenticationProvider getInstance() {
        return LdapAuthenticationProviderHelper.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ldapAuthentication(String string, String string2) {
        boolean bl = false;
        try {
            try {
                this.connectLdap();
                bl = this.authenticate(string, string2);
            }
            catch (Exception exception) {
                boolean bl2 = bl;
                Object var7_5 = null;
                this.closeContext(this.ctx);
                return bl2;
            }
            Object var7_4 = null;
            this.closeContext(this.ctx);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.closeContext(this.ctx);
            throw throwable;
        }
        return bl;
    }

    private void connectLdap() {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", FSConfig.getInstance().getContextFactory());
        String string = FSConfig.getInstance().getLdapUrl();
        if (StringUtils.isNotBlank(string) && !string.endsWith("/")) {
            string = string + "/";
        }
        string = string + FSConfig.getInstance().getLdapSearchBase();
        properties.put("java.naming.provider.url", string);
        properties.put("java.naming.security.authentication", FSConfig.getInstance().getAuthentication());
        properties.put("java.naming.referral", FSConfig.getInstance().getReferral());
        if (StringUtils.isNotBlank(FSConfig.getInstance().getLdapSystemName()) && StringUtils.isNotBlank(FSConfig.getInstance().getLdapSystemPassword())) {
            properties.put("java.naming.security.principal", FSConfig.getInstance().getLdapSystemName());
            properties.put("java.naming.security.credentials", FSConfig.getInstance().getLdapSystemPassword());
        }
        try {
            this.ctx = new InitialLdapContext(properties, this.connCtls);
        }
        catch (AuthenticationException authenticationException) {
            FRContext.getLogger().error("AuthenticationException\uff0cAuthentication faild: " + authenticationException.toString());
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Exception,Something wrong while authenticating: " + exception.toString());
        }
    }

    private String recurseGetUserDN(String string) {
        String string2 = "";
        String[] stringArray = new String[]{"sAMAccountName", "cn", "userPrincipalName", "uid", "displayName", "name", "sn"};
        for (int i2 = 0; i2 < stringArray.length && !StringUtils.isNotBlank(string2 = this.getUserDN(string, stringArray[i2])); ++i2) {
        }
        return string2;
    }

    private String getUserDN(String string, String string2) {
        String string3 = "";
        try {
            SearchResult searchResult;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string4 = "(&(" + string2 + "=" + string + "))";
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search("", string4, searchControls);
            while (!(namingEnumeration == null || !namingEnumeration.hasMoreElements() || namingEnumeration.hasMoreElements() && StringUtils.isNotBlank(string3 = (searchResult = (SearchResult)namingEnumeration.nextElement()).getNameInNamespace()) && string3.contains(string))) {
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return string3;
    }

    private boolean authenticate(String string, String string2) {
        boolean bl = false;
        String string3 = this.recurseGetUserDN(string);
        if (StringUtils.isEmpty(string3)) {
            string3 = string;
        }
        try {
            this.ctx.addToEnvironment("java.naming.security.principal", string3);
            this.ctx.addToEnvironment("java.naming.security.credentials", string2);
            this.ctx.reconnect(this.connCtls);
            bl = true;
        }
        catch (AuthenticationException authenticationException) {
            FRContext.getLogger().error(authenticationException.getMessage());
            bl = false;
        }
        catch (NamingException namingException) {
            FRContext.getLogger().error(namingException.getMessage());
            bl = false;
        }
        return bl;
    }

    private void closeContext(LdapContext ldapContext) {
        try {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        catch (NamingException namingException) {
            FRContext.getLogger().error(namingException.getMessage());
        }
    }

    private static class LdapAuthenticationProviderHelper {
        public static LdapAuthenticationProvider helper = new LdapAuthenticationProvider();

        private LdapAuthenticationProviderHelper() {
        }
    }
}

