/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.tabledata;

import com.fr.base.FRContext;
import com.fr.data.dao.DAOSession;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.control.dao.CustomRoleDAO;
import java.util.List;
import java.util.Set;

public class TableDataCustomRoleDAO
implements CustomRoleDAO {
    private static TableDataCustomRoleDAO tsd;

    public static TableDataCustomRoleDAO getInstance() {
        if (tsd == null) {
            tsd = new TableDataCustomRoleDAO();
        }
        return tsd;
    }

    public void save(CustomRole customRole) throws Exception {
        TableDataSyncDB.getInstance().addSRole(customRole);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    public boolean delete(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        TableDataSyncDB.getInstance().removeSRole(customRole);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        return true;
    }

    public boolean deleteByID(long l2) throws Exception {
        return this.delete(this.findByID(l2));
    }

    public CustomRole findByID(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findSRoleBySRoleID(l2);
    }

    public boolean updateRoleName(long l2, String string) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleName(l2, string)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
            return true;
        }
        return false;
    }

    public List findAll() throws Exception {
        return TableDataSyncDB.getInstance().findAllSRole();
    }

    public CustomRole findByRoleName(String string) throws Exception {
        return TableDataSyncDB.getInstance().findSRoleBySRoleName(string);
    }

    public Set getUserSet(long l2, boolean bl) throws Exception {
        return TableDataSyncDB.getInstance().findUserSetBySRoleId(l2, bl);
    }

    public void addUsers(long l2, Set set) throws Exception {
        CustomRole customRole = this.findByID(l2);
        if (customRole == null) {
            throw new RuntimeException("The role don't exist!");
        }
        TableDataSyncDB.getInstance().addUsersToSRole(customRole, set);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    public void removeUsers(long l2, Set set) throws Exception {
        CustomRole customRole = this.findByID(l2);
        if (customRole == null) {
            throw new RuntimeException("The role don't exist!");
        }
        TableDataSyncDB.getInstance().removeUsersFromSRole(customRole, set);
        FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
    }

    public Set getEntryPrivileges(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findEntryPrivilegesBySRoleId(l2);
    }

    public Set getEntryPrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findEntryPrivilegesBySRoleName(string);
    }

    public Set getESPrivileges(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findESPrivilegesBySRoleId(l2);
    }

    public Set getModulePrivileges(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findModulePrivilegesBySRoleId(l2);
    }

    public Set getModulePrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findModulePrivilegeBySRoleName(string);
    }

    public Set getPrivilegesWithPlateName(long l2, String string) throws Exception {
        return TableDataSyncDB.getInstance().findPrivilegesByCustomRoleIDWithPlateName(l2, string);
    }

    public void updateEntryPrivileges(long l2, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleEntryPrivileges(l2, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateEntryPrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleEntryPrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateESPrivileges(long l2, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleESPrivileges(l2, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateModulePrivileges(long l2, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleModulePrivileges(l2, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateModulePrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleModulePrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateTemplatePrivileges(long l2, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleTemplatePrivileges(l2, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateDataConnectionPrivileges(long l2, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleDataConnectionPrivileges(l2, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateDataConnectionPrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleDataConnectionPrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateTemplatePrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleTemplatePrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updatePlatePrivileges(long l2, List list, List list2, String string) throws Exception {
        if (TableDataSyncDB.getInstance().updateCustomRolePlatePrivileges(l2, list, list2, string)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void sortByEntryID(int n2, long[] lArray, DAOSession dAOSession) throws Exception {
    }

    public Set getDepAndCrolePrivileges(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findDepAndCRolePrivilegeByCustomRoleId(l2);
    }

    public Set getDepAndCrolePrivileges(String string) {
        return TableDataSyncDB.getInstance().findDepAndCRolePrivilegeByCustomRoleName(string);
    }

    public Set getTemplatePrivileges(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findTemplatePrivilegeByCustomRoleId(l2);
    }

    public Set getTemplatePrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findTemplatePrivilegeByCustomRoleName(string);
    }

    public Set getDataConnectionPrivileges(long l2) throws Exception {
        return TableDataSyncDB.getInstance().findDataConnectionPrivilegesByCustomRoleId(l2);
    }

    public Set getDataConnectionPrivileges(String string) {
        return TableDataSyncDB.getInstance().findDataConnectionPrivilegesByCustomRoleName(string);
    }

    public void updateDepAndCrolePrivilege(long l2, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateCustomRoleDepAndCRolePrivileges(l2, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }

    public void updateDepAndCrolePrivilege(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateCustomRoleDepAndCRolePrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource(FSConfig.getInstance());
        }
    }
}

