/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.DepartmentTreeNode;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DepartmentControl {
    private static DepartmentControl dc;

    public static DepartmentControl getInstance() {
        if (dc == null) {
            dc = new DepartmentControl();
        }
        return dc;
    }

    public Department getDepartment(long l2) {
        return DepartmentCache.getDepartment(l2);
    }

    public Department getDepartmentByNameAndPid(String string, long l2) throws Exception {
        return DepartmentCache.getDepartmentByNameAndPid(string, l2);
    }

    public Long[] getDpidsByPid(long l2) throws Exception {
        return DepartmentCache.getDpidsByPid(l2);
    }

    public List getUserAndPosts(long l2) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        Iterator iterator = FSConfig.getInstance().getControl().getDepartmentDAO().getUserAndPostIterator(l2, true);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            RelationObject relationObject = (RelationObject)iterator.next();
            arrayList.add(new Object[]{new Long(relationObject.getId()), relationObject.getValue(User.class), relationObject.getValue(Post.class)});
        }
        return arrayList;
    }

    public JSONArray getUserAndPostsInfo(long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getUserAndPosts(l2);
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray = (Object[])list.get(i2);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", (Long)objectArray[0]);
                User user = (User)objectArray[1];
                jSONObject.put("userid", user.getId());
                jSONObject.put("username", user.getUsername());
                Post post = (Post)objectArray[2];
                jSONObject.put("postid", post.getId());
                jSONObject.put("postname", post.getPostname());
                jSONArray.put(jSONObject);
            }
        }
        return jSONArray;
    }

    public JSONArray getUserInfoByDepartAndPost(long l2, long l3) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getUserAndPosts(l2);
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray = (Object[])list.get(i2);
                Post post = (Post)objectArray[2];
                if (post.getId() != l3) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", (Long)objectArray[0]);
                User user = (User)objectArray[1];
                jSONObject.put("userid", user.getId());
                jSONObject.put("username", user.getUsername());
                jSONObject.put("realname", user.getRealname());
                jSONArray.put(jSONObject);
            }
        }
        return jSONArray;
    }

    public boolean updateDepartmentName(long l2, String string) throws Exception {
        if (l2 < 0L || StringUtils.isBlank(string)) {
            return false;
        }
        Department department = this.getDepartment(l2);
        if (this.getDepartmentByNameAndPid(string, department.getPid()) != null) {
            return false;
        }
        if (FSConfig.getInstance().getControl().getDepartmentDAO().updateDepartmentName(l2, string)) {
            try {
                DepartmentCache.cacheNewName(l2, string);
            }
            catch (Exception exception) {
                DepartmentCache.reInit();
            }
            return true;
        }
        return false;
    }

    public boolean addDepartment(Department department) throws Exception {
        if (department == null) {
            return false;
        }
        Department department2 = this.getDepartmentByNameAndPid(department.getName(), department.getPid());
        if (department2 != null) {
            department.setId(department2.getId());
            return false;
        }
        FSConfig.getInstance().getControl().getDepartmentDAO().save(department);
        if (department.getId() < 0L) {
            return false;
        }
        try {
            DepartmentCache.cache(department);
        }
        catch (Exception exception) {
            DepartmentCache.reInit();
        }
        long l2 = CompanyRoleControl.getInstance().getPostAllID();
        CompanyRole companyRole = new CompanyRole(l2, department.getId(), "");
        CompanyRoleControl.getInstance().addCompanyRole(companyRole);
        return true;
    }

    public String getDepartmentShowName(long l2) {
        return this.getDepartmentShowName(l2, null);
    }

    public String getDepartmentShowName(long l2, String string) {
        if (l2 < 0L) {
            return null;
        }
        return DepartmentCache.getShowDepartmentName(l2, string);
    }

    public Long[] getDepartmentIDPath(long l2) {
        if (l2 < 0L) {
            return null;
        }
        return DepartmentCache.getDepartmentPath(l2);
    }

    public boolean deleteDepartment(long l2) throws Exception {
        boolean bl = true;
        try {
            bl = DepartmentCache.removeCache(l2);
        }
        catch (Exception exception) {
            DepartmentCache.reInit();
        }
        try {
            UserCache.refreshAfterDelDepartment(l2);
        }
        catch (Exception exception) {
            UserCache.removeAllCache();
        }
        return bl;
    }

    public JSONArray getDepartmentInfoPrivilege(long l2, boolean bl) throws Exception {
        Department department;
        if (l2 == CustomRoleControl.getInstance().getSuperCustomRoleID()) {
            return this.getAllDepartmentInfo(bl);
        }
        JSONArray jSONArray = FSConfig.getInstance().getControl().getControlType() == 0 ? this.createPrivilegeJSONConfigFromRoot(l2) : this.createPrivilegeJSONConfigWithNoRoot(l2);
        if (bl && (department = DepartmentCache.getDepartment(CompanyRoleControl.getInstance().getDepartmentAllID())) != null) {
            jSONArray.put(department.createJSONConfig());
        }
        return jSONArray;
    }

    private JSONArray createPrivilegeJSONConfigFromRoot(long l2) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        DepartmentTreeNode departmentTreeNode = DepartmentCache.getRootNode();
        JSONObject jSONObject = departmentTreeNode.getDepartment().createJSONConfig();
        JSONArray jSONArray2 = this.createPrivilegeJSONConfigWithNoRoot(l2);
        jSONObject.put("ChildNodes", jSONArray2);
        jSONArray.put(jSONObject);
        return jSONArray;
    }

    private JSONArray createPrivilegeJSONConfigWithNoRoot(long l2) throws JSONException {
        DepartmentTreeNode departmentTreeNode = DepartmentCache.getRootNode();
        Object[] objectArray = departmentTreeNode.getNodes(l2, null);
        JSONArray jSONArray = new JSONArray();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (Object object : objectArray) {
                jSONArray.put(((DepartmentTreeNode)object).createJSONConfigIncludeParent(null));
            }
        }
        return jSONArray;
    }

    public JSONArray getAllDepartmentInfo(boolean bl) throws Exception {
        Object object;
        JSONArray jSONArray = new JSONArray();
        if (FSConfig.getInstance().getControl().getControlType() == 0) {
            jSONArray.put(DepartmentCache.getRootNode().createJSONConfig());
        } else {
            object = DepartmentCache.getRootNode();
            Object[] objectArray = ((DepartmentTreeNode)object).getNodes();
            if (!ArrayUtils.isEmpty(objectArray)) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    jSONArray.put(((DepartmentTreeNode)objectArray[i2]).createJSONConfig());
                }
            }
        }
        if (bl && (object = DepartmentCache.getDepartment(CompanyRoleControl.getInstance().getDepartmentAllID())) != null) {
            jSONArray.put(((Department)object).createJSONConfig());
        }
        return jSONArray;
    }
}

