/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSRegisterForBI;
import com.fr.fs.base.entity.Module;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.cache.ModuleTreeNode;
import com.fr.fs.dao.ModuleDAO;
import com.fr.fs.web.service.PlatformEntryService;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleCache {
    private static ModuleDAO mDao = ModuleDAO.getInstance();
    private static ModuleTreeNode root;
    private static Map listMap;

    public static void clearModuleCache() {
        Module module = new Module(-1L);
        module.setName("root");
        module.setParentId(-2L);
        root = new ModuleTreeNode(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initCacheTree() throws Exception {
        Map map = listMap;
        synchronized (map) {
            if (listMap.isEmpty()) {
                try {
                    listMap.put(new Long(-1L), root);
                    List list = mDao.findAll();
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Module module = (Module)list.get(i2);
                        if (ModuleCache.ignoreModule(module)) continue;
                        listMap.put(new Long(module.getId()), new ModuleTreeNode(module));
                    }
                    Set set = listMap.entrySet();
                    Iterator iterator = set.iterator();
                    ArrayList<Module> arrayList = new ArrayList<Module>();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ModuleTreeNode moduleTreeNode = (ModuleTreeNode)entry.getValue();
                        ModuleTreeNode moduleTreeNode2 = (ModuleTreeNode)listMap.get(new Long(moduleTreeNode.getModule().getParentId()));
                        if (moduleTreeNode2 != null) {
                            moduleTreeNode2.addNode(moduleTreeNode.getModule().getId(), moduleTreeNode);
                            continue;
                        }
                        arrayList.add(moduleTreeNode.getModule());
                    }
                }
                catch (Exception exception) {
                    listMap.clear();
                    throw exception;
                }
            }
        }
    }

    private static boolean ignoreModule(Module module) {
        if (module.getParentId() == 0L) {
            return true;
        }
        if (FSRegisterForBI.isSupportFS()) {
            return false;
        }
        List list = PlatformEntryService.supportModules();
        return !list.contains(String.valueOf(module.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() throws Exception {
        Map map = listMap;
        synchronized (map) {
            ModuleCache.clearModuleCache();
            listMap.clear();
            ModuleCache.initCacheTree();
        }
    }

    public static JSONArray getModuleRootShowInfo(long l2) throws Exception {
        return root.createShowModuleConfig(l2);
    }

    public static JSONArray getRootNodeInfo() throws JSONException {
        return root.createAllChildrenJSONConfig();
    }

    public static JSONObject getNodeInfo(long l2, long l3) throws Exception {
        ModuleTreeNode moduleTreeNode = (ModuleTreeNode)listMap.get(new Long(l2));
        if (moduleTreeNode != null) {
            return moduleTreeNode.createShowJSONConfig(l3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getAuthorizedModuleItemsFromPrivilegeSet(Set set) throws JSONException {
        Map map = listMap;
        synchronized (map) {
            Object[] objectArray = listMap.values().toArray();
            Arrays.sort(objectArray);
            JSONArray jSONArray = new JSONArray();
            boolean bl = false;
            ModuleTreeNode moduleTreeNode = null;
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ModuleTreeNode moduleTreeNode2 = (ModuleTreeNode)objectArray[i2];
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    if (roleModulePrivilege.getModuleid() != moduleTreeNode2.getModule().getId()) continue;
                    if (moduleTreeNode2.getModule().getId() == 18L) {
                        bl = true;
                        moduleTreeNode = moduleTreeNode2;
                        continue;
                    }
                    JSONObject jSONObject = moduleTreeNode2.createJSONConfig();
                    jSONObject.put("view", 0);
                    jSONObject.put("design", 0);
                    jSONArray.put(jSONObject);
                }
            }
            if (bl && moduleTreeNode != null) {
                JSONObject jSONObject = moduleTreeNode.createJSONConfig();
                jSONObject.put("view", 0);
                jSONObject.put("design", 0);
                jSONArray.put(jSONObject);
            }
            return jSONArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllModules(boolean bl) {
        Map map = listMap;
        synchronized (map) {
            Set set = listMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>(listMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ModuleTreeNode moduleTreeNode = (ModuleTreeNode)entry.getValue();
                if (bl) {
                    try {
                        arrayList.add(moduleTreeNode.getModule().clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    continue;
                }
                arrayList.add(moduleTreeNode.getModule());
            }
            return arrayList;
        }
    }

    public static Module getModule(long l2) {
        ModuleTreeNode moduleTreeNode = (ModuleTreeNode)listMap.get(new Long(l2));
        if (moduleTreeNode != null) {
            try {
                return (Module)moduleTreeNode.getModule().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized void cache(Module module) {
        if (module == null || listMap.containsKey(new Long(module.getId()))) {
            return;
        }
        ModuleTreeNode moduleTreeNode = (ModuleTreeNode)listMap.get(new Long(module.getParentId()));
        if (moduleTreeNode != null) {
            ModuleTreeNode moduleTreeNode2 = new ModuleTreeNode(module);
            listMap.put(new Long(module.getParentId()), moduleTreeNode2);
            moduleTreeNode.addNode(module.getId(), moduleTreeNode2);
        }
    }

    public static synchronized void removeCache(long l2) {
        Long[] longArray;
        if (l2 < 0L) {
            return;
        }
        ModuleTreeNode moduleTreeNode = (ModuleTreeNode)listMap.get(new Long(l2));
        if (moduleTreeNode != null && (longArray = moduleTreeNode.getNodeIDs()) != null) {
            for (int i2 = 0; i2 < longArray.length; ++i2) {
                ModuleCache.removeCache(longArray[i2]);
            }
        }
    }

    static {
        listMap = new Hashtable(128);
        ModuleCache.clearModuleCache();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ModuleCache.clearModuleCache();
                listMap.clear();
            }
        });
    }
}

