/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.cache.EntryComparator;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDComparator;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.FileEntryDAO;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.schedule.ScheduleLinkOutputDAO;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.web.platform.entry.BaseEntry;
import com.fr.web.platform.entry.Entry;
import com.fr.web.platform.entry.FileEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EntryTreeFolderNode {
    private FolderEntry entry;
    private Map folderMap = new TreeMap(IDComparator.getInstance());
    private Map nodeMap = new TreeMap(EntryComparator.getInstance());

    protected EntryTreeFolderNode(FolderEntry folderEntry) {
        this.entry = folderEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFolder(long l2, EntryTreeFolderNode entryTreeFolderNode) {
        if (entryTreeFolderNode == null || l2 < 0L) {
            return;
        }
        Map map = this.folderMap;
        synchronized (map) {
            this.folderMap.put(new Long(l2), entryTreeFolderNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(Entry entry) {
        if (entry == null || entry.getId() < 0L) {
            return;
        }
        Map map = this.nodeMap;
        synchronized (map) {
            if (this.nodeMap == null) {
                this.nodeMap = new Hashtable();
            }
            this.nodeMap.put(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(Entry entry) {
        if (entry == null || entry.getId() < 0L) {
            return;
        }
        Map map = this.nodeMap;
        synchronized (map) {
            this.nodeMap.remove(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFolderNode(long l2) {
        if (l2 < 0L) {
            return;
        }
        Map map = this.folderMap;
        synchronized (map) {
            this.folderMap.remove(new Long(l2));
        }
    }

    protected List removeAll() {
        Entry[] entryArray;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        EntryTreeFolderNode[] entryTreeFolderNodeArray = this.getFolderNodes();
        if (entryTreeFolderNodeArray != null) {
            for (int i2 = 0; i2 < entryTreeFolderNodeArray.length; ++i2) {
                arrayList.add(entryTreeFolderNodeArray[i2].getFolder());
                arrayList.addAll(entryTreeFolderNodeArray[i2].removeAll());
            }
        }
        if ((entryArray = this.getNodes()) != null) {
            for (int i3 = 0; i3 < entryArray.length; ++i3) {
                arrayList.add(entryArray[i3]);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getNodes() {
        Map map = this.nodeMap;
        synchronized (map) {
            Set set = this.nodeMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList arrayList = new ArrayList(this.nodeMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                arrayList.add(entry.getValue());
            }
            Entry[] entryArray = arrayList.toArray(new Entry[arrayList.size()]);
            Arrays.sort(entryArray, SORTINFOComparatorForEntry.getInstance());
            return entryArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getNodes(int n2) {
        Map map = this.nodeMap;
        synchronized (map) {
            Entry[] entryArray;
            Set set = this.nodeMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList<Entry[]> arrayList = new ArrayList<Entry[]>(this.nodeMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entryArray = (Entry[])entry.getValue();
                if (entryArray.getEntryType() != n2) continue;
                arrayList.add(entryArray);
            }
            entryArray = arrayList.toArray(new Entry[arrayList.size()]);
            Arrays.sort(entryArray, SORTINFOComparatorForEntry.getInstance());
            return entryArray;
        }
    }

    public boolean hasEntry(int n2, long l2) {
        Entry[] entryArray = this.getNodes(n2);
        Object[] objectArray = entryArray;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Entry entry = objectArray[i2];
            if (entry.getId() != l2) continue;
            return true;
        }
        for (Object object : objectArray = this.getFolderNodes()) {
            if (!((EntryTreeFolderNode)object).hasEntry(n2, l2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryTreeFolderNode[] getFolderNodes() {
        Map map = this.folderMap;
        synchronized (map) {
            Set set = this.folderMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList arrayList = new ArrayList(this.folderMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                arrayList.add(entry.getValue());
            }
            EntryTreeFolderNode[] entryTreeFolderNodeArray = arrayList.toArray(new EntryTreeFolderNode[arrayList.size()]);
            Arrays.sort(entryTreeFolderNodeArray, SORTINFOComparator.getInstance());
            return entryTreeFolderNodeArray;
        }
    }

    private FolderEntry getFolder() {
        return this.entry;
    }

    protected FolderEntry getLClonedFolderEntry() {
        try {
            return (FolderEntry)this.entry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    protected long getFolderParentID() {
        return this.entry.getParentId();
    }

    protected void setFolder(FolderEntry folderEntry) {
        this.entry = folderEntry;
    }

    public JSONObject createManagerJSONConfig(long l2) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        return this.createManagerJSONConfig(set, false);
    }

    private JSONObject createManagerJSONConfig(Set set, boolean bl) throws JSONException {
        JSONObject jSONObject;
        int n2;
        FolderEntry folderEntry = this.entry;
        if (!FSConfig.getInstance().isEditReportAuthority()) {
            bl = true;
        } else if (set != null && this.hasEditPrivileges(set, EntryTypeAndID.getInstance(folderEntry.getEntryType(), folderEntry.getId(), 1L, 1L, 1L))) {
            bl = true;
        }
        Object[] objectArray = this.getFolderNodes();
        JSONArray jSONArray = null;
        if (!ArrayUtils.isEmpty(objectArray)) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                jSONObject = super.createManagerJSONConfig(set, bl);
                if (jSONObject == null) continue;
                jSONArray.put(jSONObject);
            }
        }
        n2 = 1;
        if (FSConfig.getInstance().isEditReportAuthority()) {
            n2 = this.hasEditLeafPrivilege(set, EntryTypeAndID.getInstance(folderEntry.getEntryType(), folderEntry.getId())) ? 1 : 0;
        }
        if (!(bl || jSONArray != null && jSONArray.length() != 0 || n2 != 0)) {
            return null;
        }
        jSONObject = this.entry.createJSONConfig(false);
        if (bl) {
            jSONObject.put("permission", true);
        }
        if (jSONArray != null) {
            jSONObject.put("ChildNodes", jSONArray);
            jSONObject.put("hasChildren", true);
        } else {
            jSONObject.put("leaf", true);
            jSONObject.put("hasChildren", false);
        }
        return jSONObject;
    }

    public JSONArray createAllEntryJSONArrayNoCheck() throws JSONException {
        JSONArray jSONArray = this.createAllFSEntryJSONArray(null, null, true, false);
        if (jSONArray == null) {
            return new JSONArray();
        }
        return jSONArray;
    }

    public JSONArray createAuthorizedEntryJSONArray(long l2) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
        for (EntryTypeAndID entryTypeAndID : set) {
            if (entryTypeAndID.getAuthorized() != 0L || !FSConfig.getInstance().isGradeAuthority()) continue;
            hashSet.add(entryTypeAndID);
        }
        set.removeAll(hashSet);
        return this.createEntryJSONArrayOfPrivilegeSet(set, l2, false);
    }

    public JSONArray createAllEntryJSONArray(long l2, boolean bl) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        return this.createEntryJSONArrayOfPrivilegeSet(set, l2, bl);
    }

    public FolderEntry[] getAllShowFolderNoPVCheck() {
        EntryTreeFolderNode[] entryTreeFolderNodeArray = this.getFolderNodes();
        ArrayList<FolderEntry> arrayList = new ArrayList<FolderEntry>();
        if (entryTreeFolderNodeArray != null) {
            for (int i2 = 0; i2 < entryTreeFolderNodeArray.length; ++i2) {
                arrayList.add(entryTreeFolderNodeArray[i2].getLClonedFolderEntry());
            }
            return arrayList.toArray(new FolderEntry[arrayList.size()]);
        }
        return null;
    }

    public FolderEntry[] getShowFolderEntrys(long l2) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        boolean bl = false;
        if (set != null && set.contains(EntryTypeAndID.getInstance(0, -1L))) {
            bl = true;
        }
        EntryTreeFolderNode[] entryTreeFolderNodeArray = this.getFolderNodes();
        ArrayList<FolderEntry> arrayList = new ArrayList<FolderEntry>();
        if (entryTreeFolderNodeArray != null) {
            for (int i2 = 0; i2 < entryTreeFolderNodeArray.length; ++i2) {
                if (!bl && !entryTreeFolderNodeArray[i2].isVisible(set)) continue;
                arrayList.add(entryTreeFolderNodeArray[i2].getLClonedFolderEntry());
            }
            return arrayList.toArray(new FolderEntry[arrayList.size()]);
        }
        return null;
    }

    private JSONArray createEntryJSONArrayOfPrivilegeSet(Set set, long l2, boolean bl) throws Exception {
        List list;
        boolean bl2 = false;
        if (set != null && set.contains(EntryTypeAndID.getInstance(0, -1L, 1L, 0L, 0L))) {
            bl2 = true;
        }
        JSONArray jSONArray = null;
        HashMap<EntryTypeAndID, Long> hashMap = null;
        if (bl && (list = UserControl.getInstance().getFavoriteNodes(l2)) != null) {
            hashMap = new HashMap<EntryTypeAndID, Long>();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FavoriteNode favoriteNode = (FavoriteNode)list.get(i2);
                hashMap.put(EntryTypeAndID.getInstance(favoriteNode.getType(), favoriteNode.getEntryid()), new Long(favoriteNode.getId()));
            }
        }
        if ((jSONArray = this.createAllFSEntryJSONArray(set, hashMap, bl2, true)) == null) {
            return new JSONArray();
        }
        return jSONArray;
    }

    private boolean isVisible(Set set) {
        EntryTreeFolderNode[] entryTreeFolderNodeArray;
        if (set == null) {
            return false;
        }
        FolderEntry folderEntry = this.getFolder();
        if (set.contains(EntryTypeAndID.getInstance(folderEntry.getEntryType(), folderEntry.getId()))) {
            return true;
        }
        Entry[] entryArray = this.getNodes();
        if (entryArray != null) {
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                if (!set.contains(EntryTypeAndID.getInstance(entryArray[i2].getEntryType(), entryArray[i2].getId()))) continue;
                return true;
            }
        }
        if ((entryTreeFolderNodeArray = this.getFolderNodes()) != null) {
            for (int i3 = 0; i3 < entryTreeFolderNodeArray.length; ++i3) {
                if (!entryTreeFolderNodeArray[i3].isVisible(set)) continue;
                return true;
            }
        }
        return false;
    }

    private JSONObject createFSJSONConfig(Set set, Map map, boolean bl) throws JSONException {
        JSONArray jSONArray = this.createAllFSEntryJSONArray(set, map, bl, true);
        if (!bl && jSONArray == null) {
            return null;
        }
        JSONObject jSONObject = this.entry.createJSONConfig(true);
        jSONObject.put("ChildNodes", jSONArray);
        jSONObject.put("view", 1);
        jSONObject.put("design", 1);
        EntryTypeAndID entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, EntryTypeAndID.getInstance(this.entry.getEntryType(), this.entry.getId()));
        jSONObject.put("edit", entryTypeAndID.getEdit());
        return jSONObject;
    }

    private JSONArray createAllFSEntryJSONArray(Set set, Map map, boolean bl, boolean bl2) throws JSONException {
        Object object;
        EntryTreeFolderNode[] entryTreeFolderNodeArray;
        JSONArray jSONArray = new JSONArray();
        if (set != null) {
            entryTreeFolderNodeArray = this.entry;
            object = FSPrivilegeTools.getInstance().getEntryPrivilege(set, EntryTypeAndID.getInstance(entryTreeFolderNodeArray.getEntryType(), entryTreeFolderNodeArray.getId()));
            if (((EntryTypeAndID)object).getView() == 1L) {
                bl = true;
            }
        }
        if ((entryTreeFolderNodeArray = this.getFolderNodes()) != null) {
            for (int i2 = 0; i2 < entryTreeFolderNodeArray.length; ++i2) {
                object = entryTreeFolderNodeArray[i2].createFSJSONConfig(set, map, bl);
                if (object == null) continue;
                jSONArray.put(object);
            }
        }
        if (bl2) {
            this.addLeafEntryJSONArray(jSONArray, set, map, bl, true);
        }
        if (jSONArray.length() == 0) {
            return null;
        }
        return jSONArray;
    }

    private boolean hasEditPrivileges(Set set, EntryTypeAndID entryTypeAndID) {
        for (Object e2 : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e2;
            if (!ComparatorUtils.equals(entryTypeAndID2, entryTypeAndID) || entryTypeAndID2.getEdit() != 1L) continue;
            return true;
        }
        return false;
    }

    private boolean hasEditLeafPrivilege(Set set, EntryTypeAndID entryTypeAndID) {
        for (Object e2 : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e2;
            if (!ComparatorUtils.equals(entryTypeAndID2, entryTypeAndID) || entryTypeAndID2.getEdit() == 0L) continue;
            return true;
        }
        return false;
    }

    public JSONArray createLeafEntryJSONArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        this.addLeafEntryJSONArray(jSONArray, null, null, true, false);
        return jSONArray;
    }

    public JSONArray createLeafEntryJSONArray(long l2) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l2);
        JSONArray jSONArray = new JSONArray();
        this.addEditableLeafEntryJSONArray(jSONArray, set);
        return jSONArray;
    }

    private void addEditableLeafEntryJSONArray(JSONArray jSONArray, Set set) throws Exception {
        Entry[] entryArray = this.getNodes();
        ArrayList arrayList = new ArrayList();
        if (entryArray != null) {
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                EntryTypeAndID entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, EntryTypeAndID.getInstance(entryArray[i2].getEntryType(), entryArray[i2].getId()));
                if (FSConfig.getInstance().isEditReportAuthority() && entryTypeAndID.getEdit() != 1L) continue;
                if (entryArray[i2] instanceof FileEntry) {
                    if (!((FileEntry)entryArray[i2]).isCpr()) continue;
                    this.createScheduleFileEntryJSONObject(arrayList, jSONArray, false, null, entryArray[i2], entryTypeAndID);
                    continue;
                }
                this.createEntryJSONConfig(jSONArray, false, null, entryArray[i2], entryTypeAndID);
            }
        }
    }

    private void addLeafEntryJSONArray(JSONArray jSONArray, Set set, Map map, boolean bl, boolean bl2) throws JSONException {
        Entry[] entryArray = this.getNodes();
        ArrayList arrayList = new ArrayList();
        if (entryArray != null) {
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(entryArray[i2].getEntryType(), entryArray[i2].getId());
                entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, entryTypeAndID);
                if (!bl && entryTypeAndID.getView() != 1L) continue;
                if (entryArray[i2] instanceof FileEntry) {
                    if (!((FileEntry)entryArray[i2]).isCpr()) continue;
                    this.createScheduleFileEntryJSONObject(arrayList, jSONArray, bl2, map, entryArray[i2], entryTypeAndID);
                    continue;
                }
                this.createEntryJSONConfig(jSONArray, bl2, map, entryArray[i2], entryTypeAndID);
            }
        }
    }

    private void createScheduleFileEntryJSONObject(List list, JSONArray jSONArray, boolean bl, Map map, Entry entry, EntryTypeAndID entryTypeAndID) {
        block4: {
            try {
                List list2 = ScheduleLinkOutputDAO.getInstance().findListByFileEntryId(entry.getId());
                if (list2.isEmpty()) break block4;
                ScheduleLinkOutput scheduleLinkOutput = (ScheduleLinkOutput)list2.get(0);
                if (!list.contains(new Long(scheduleLinkOutput.getOutputId()))) {
                    list.add(new Long(scheduleLinkOutput.getOutputId()));
                    Collections.sort(list2, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ComparatorUtils.compare(((ScheduleLinkOutput)object2).getFileEntryId(), ((ScheduleLinkOutput)object).getFileEntryId());
                        }
                    });
                    Iterator iterator = list2.iterator();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        long l2 = ((ScheduleLinkOutput)iterator.next()).getFileEntryId();
                        FileEntry fileEntry = FileEntryDAO.getInstance().findByID(l2);
                        String string = fileEntry.getDisplayName();
                        if (arrayList.contains(string) || fileEntry.getParentId() != this.entry.getId()) continue;
                        arrayList.add(string);
                        this.createEntryJSONConfig(jSONArray, bl, map, fileEntry, entryTypeAndID);
                    }
                    break block4;
                }
                return;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private void createEntryJSONConfig(JSONArray jSONArray, boolean bl, Map map, Entry entry, EntryTypeAndID entryTypeAndID) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject = bl ? entry.createShowJSONConfig() : entry.createJSONConfig();
        if (map != null) {
            Long l2;
            if (entryTypeAndID == null) {
                entryTypeAndID = EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId());
            }
            if ((l2 = (Long)map.get(entryTypeAndID)) != null) {
                jSONObject.put("favoriteid", l2);
            }
        }
        jSONObject.put("showType", entry.getShowType());
        jSONObject.put("view", entryTypeAndID == null ? 0L : entryTypeAndID.getView());
        jSONObject.put("design", entryTypeAndID == null ? 0L : entryTypeAndID.getAuthorized());
        jSONObject.put("edit", entryTypeAndID == null ? 0L : entryTypeAndID.getEdit());
        jSONArray.put(jSONObject);
    }

    private static class SORTINFOComparatorForEntry
    implements Comparator {
        private static SORTINFOComparatorForEntry SC = new SORTINFOComparatorForEntry();

        private SORTINFOComparatorForEntry() {
        }

        public static SORTINFOComparatorForEntry getInstance() {
            return SC;
        }

        public int compare(Object object, Object object2) {
            BaseEntry baseEntry = (BaseEntry)object;
            BaseEntry baseEntry2 = (BaseEntry)object2;
            if (ComparatorUtils.equals(baseEntry.getTypePrefix(), baseEntry2.getTypePrefix())) {
                long l2;
                long l3 = baseEntry.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry.getSortindex();
                long l4 = l3 - (l2 = baseEntry2.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry2.getSortindex());
                if (l4 > 0L) {
                    return 1;
                }
                if (l4 == 0L) {
                    long l5 = baseEntry.getId() - baseEntry2.getId();
                    if (l5 > 0L) {
                        return 1;
                    }
                    if (l5 == 0L) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            }
            return 0;
        }
    }

    private static class SORTINFOComparator
    implements Comparator {
        private static SORTINFOComparator SC = new SORTINFOComparator();

        private SORTINFOComparator() {
        }

        public static SORTINFOComparator getInstance() {
            return SC;
        }

        public int compare(Object object, Object object2) {
            long l2;
            if (object instanceof EntryTreeFolderNode) {
                object = ((EntryTreeFolderNode)object).getFolder();
                object2 = ((EntryTreeFolderNode)object2).getFolder();
            }
            if (!(object instanceof BaseEntry) || !(object2 instanceof BaseEntry)) {
                return 0;
            }
            BaseEntry baseEntry = (BaseEntry)object;
            BaseEntry baseEntry2 = (BaseEntry)object2;
            long l3 = baseEntry.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry.getSortindex();
            long l4 = l3 - (l2 = baseEntry2.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry2.getSortindex());
            if (l4 > 0L) {
                return 1;
            }
            if (l4 == 0L) {
                long l5 = baseEntry.getId() - baseEntry2.getId();
                if (l5 > 0L) {
                    return 1;
                }
                if (l5 == 0L) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    }
}

