/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.IDComparator;
import com.fr.fs.cache.UserCache;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DepartmentTreeNode {
    private Department department;
    private DepartmentTreeNode parent = null;
    private Map nodeMap = new TreeMap(IDComparator.getInstance());

    protected DepartmentTreeNode(Department department) {
        this.setDepartment(department);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(long l2, DepartmentTreeNode departmentTreeNode) {
        Map map = this.nodeMap;
        synchronized (map) {
            this.nodeMap.put(new Long(l2), departmentTreeNode);
        }
        departmentTreeNode.setParent(this);
    }

    private void setParent(DepartmentTreeNode departmentTreeNode) {
        this.parent = departmentTreeNode;
    }

    protected void removeSelf() {
        this.parent.removeNode(this.getDepartment().getId());
    }

    public String getShowName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.apName(stringBuffer, string);
        return stringBuffer.toString();
    }

    private void apName(StringBuffer stringBuffer, String string) {
        if (this.parent != null) {
            this.parent.apName(stringBuffer, string);
        }
        if (this.getDepartment().getId() >= 0L) {
            if (string != null && stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this.getDepartment().getName());
        }
    }

    public Long[] getPath() {
        ArrayList arrayList = new ArrayList();
        this.apPath(arrayList);
        return arrayList.toArray(new Long[arrayList.size()]);
    }

    private void apPath(List list) {
        if (this.parent != null) {
            this.parent.apPath(list);
        }
        if (this.getDepartment().getId() >= 0L) {
            list.add(new Long(this.getDepartment().getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(long l2) {
        Map map = this.nodeMap;
        synchronized (map) {
            this.nodeMap.remove(new Long(l2));
        }
    }

    public DepartmentTreeNode[] getNodes() {
        return (DepartmentTreeNode[])this.getNodes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepartmentTreeNode[] getNodes(long l2, List arrayList) {
        Set set = new HashSet();
        try {
            set = UserCache.getAllDepAndCRolePrivileges(l2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        Map map = this.nodeMap;
        synchronized (map) {
            Set set2 = this.nodeMap.entrySet();
            Iterator iterator = set2.iterator();
            if (arrayList == null) {
                arrayList = new ArrayList<DepartmentTreeNode>();
            }
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)entry.getValue();
                long l3 = departmentTreeNode.getDepartment().getId();
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (roleDepAndCRolePrivilege.getType() == 0 && roleDepAndCRolePrivilege.getDeporcroleid() == -1L) {
                        return this.getNodes();
                    }
                    if (roleDepAndCRolePrivilege.getType() != 1 || roleDepAndCRolePrivilege.getDeporcroleid() != l3) continue;
                    arrayList.add(departmentTreeNode);
                }
                if (departmentTreeNode.nodeMap.isEmpty()) continue;
                departmentTreeNode.getNodes(l2, arrayList);
            }
            return arrayList.toArray(new DepartmentTreeNode[arrayList.size()]);
        }
    }

    protected Long[] getNodeIDs() {
        return (Long[])this.getNodes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getNodes(boolean bl) {
        Map map = this.nodeMap;
        synchronized (map) {
            Set set = this.nodeMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>(this.nodeMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (bl) {
                    arrayList.add(entry.getKey());
                    continue;
                }
                arrayList.add(entry.getValue());
            }
            if (bl) {
                return arrayList.toArray(new Long[arrayList.size()]);
            }
            return arrayList.toArray(new DepartmentTreeNode[arrayList.size()]);
        }
    }

    public Department getDepartment() {
        return this.department;
    }

    public JSONObject createJSONConfigIncludeParent(JSONArray jSONArray) throws JSONException {
        JSONObject jSONObject = this.getDepartment().createJSONConfig();
        if (jSONArray != null && jSONArray.length() > 0) {
            jSONObject.put("ChildNodes", jSONArray);
        }
        if (this.parent == null || ComparatorUtils.equals(this.parent, DepartmentCache.getRootNode())) {
            return jSONObject;
        }
        JSONArray jSONArray2 = new JSONArray();
        jSONArray2.put(jSONObject);
        return this.parent.createJSONConfigIncludeParent(jSONArray2);
    }

    public JSONObject createPrivilegeJSONConfig(long l2) throws JSONException {
        JSONObject jSONObject = this.getDepartment().createJSONConfig();
        Object[] objectArray = this.getNodes(l2, null);
        if (!ArrayUtils.isEmpty(objectArray)) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                jSONArray.put(((DepartmentTreeNode)objectArray[i2]).createJSONConfig());
            }
            jSONObject.put("ChildNodes", jSONArray);
        }
        return jSONObject;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = this.getDepartment().createJSONConfig();
        Object[] objectArray = this.getNodes();
        if (!ArrayUtils.isEmpty(objectArray)) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                jSONArray.put(((DepartmentTreeNode)objectArray[i2]).createJSONConfig());
            }
            jSONObject.put("ChildNodes", jSONArray);
        }
        return jSONObject;
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.getDepartment().hashCode();
        int n4 = this.parent.hashCode();
        n2 = n3 * n2 + (n3 ^ n3 >>> 32);
        n2 = 31 * n2 + n4;
        n2 = 31 * n2 + ((Object)this.nodeMap).hashCode();
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DepartmentTreeNode departmentTreeNode = (DepartmentTreeNode)object;
        if (!this.getDepartment().equals4Properties(departmentTreeNode.getDepartment())) {
            return false;
        }
        if (ComparatorUtils.equals(this.parent, departmentTreeNode.parent)) {
            return false;
        }
        return this.nodeMap == departmentTreeNode.nodeMap;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }
}

