/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.RoleCacheInfo;
import com.fr.fs.cache.RoleCacheUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompanyRoleCache {
    private static Map roleMap = new Hashtable(128);
    private static final IDLockCreator JROLE_ID_LOCK_CREATOR = new IDLockCreator();

    public static boolean containCache(long l2) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roleMap.containsKey(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCache() throws Exception {
        Map map = roleMap;
        synchronized (map) {
            if (roleMap.isEmpty()) {
                try {
                    List list = FSConfig.getInstance().getControl().getCompanyRoleDAO().findAll();
                    if (list != null) {
                        int n2 = list.size();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            CompanyRoleCache.cache((CompanyRole)list.get(i2));
                        }
                    }
                }
                catch (Exception exception) {
                    roleMap.clear();
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitCache() throws Exception {
        Map map = roleMap;
        synchronized (map) {
            roleMap.clear();
            CompanyRoleCache.initCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() throws Exception {
        Map map = roleMap;
        synchronized (map) {
            roleMap.clear();
        }
    }

    private static void cache(CompanyRole companyRole) throws Exception {
        if (companyRole != null && companyRole.getId() >= 0L) {
            RoleCacheInfo roleCacheInfo = CompanyRoleCache.createCompanyRoleCacheInfo(companyRole);
            roleMap.put(new Long(companyRole.getId()), roleCacheInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cacheNew(CompanyRole companyRole) throws Exception {
        if (companyRole == null) return;
        if (companyRole.getId() < 0L) return;
        Object object = JROLE_ID_LOCK_CREATOR.getIDLock(companyRole.getId());
        try {
            Object object2 = object;
            synchronized (object2) {
                if (roleMap.containsKey(new Long(companyRole.getId()))) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    Object var6_3 = null;
                    JROLE_ID_LOCK_CREATOR.releaseIDLock();
                    return;
                }
                RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
                roleMap.put(new Long(companyRole.getId()), roleCacheInfo);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            JROLE_ID_LOCK_CREATOR.releaseIDLock();
            throw throwable;
        }
        Object var6_4 = null;
        JROLE_ID_LOCK_CREATOR.releaseIDLock();
    }

    private static RoleCacheInfo createCompanyRoleCacheInfo(CompanyRole companyRole) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        RoleCacheInfo roleCacheInfo = new RoleCacheInfo();
        Set set = FSConfig.getInstance().getControl().getCompanyRoleDAO().getEntryPrivileges(companyRole.getId());
        if (set != null) {
            object5 = set.iterator();
            while (object5.hasNext()) {
                object4 = (RoleEntryPrivilege)object5.next();
                roleCacheInfo.entryPrivilegeSet.add(EntryTypeAndID.getInstance(((RoleEntryPrivilege)object4).getType(), ((RoleEntryPrivilege)object4).getEntryid(), ((RoleEntryPrivilege)object4).getView(), ((RoleEntryPrivilege)object4).getAuthorized(), ((RoleEntryPrivilege)object4).getEdit()));
            }
        }
        if ((object5 = FSConfig.getInstance().getControl().getCompanyRoleDAO().getESPrivileges(companyRole.getId())) != null) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (RoleESPrivilege)object4.next();
                roleCacheInfo.ESPrivilegeSet.add(EntryTypeAndID.getInstance(((RoleESPrivilege)object3).getType(), ((RoleESPrivilege)object3).getEntryid()));
            }
        }
        if ((object4 = FSConfig.getInstance().getControl().getCompanyRoleDAO().getModulePrivileges(companyRole.getId())) != null) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                roleCacheInfo.moduleSet.add((RoleModulePrivilege)object3.next());
            }
        }
        if ((object3 = FSConfig.getInstance().getControl().getCompanyRoleDAO().getDepAndCrolePrivileges(companyRole.getId())) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                roleCacheInfo.depandcrolePrivilegeSet.add((RoleDepAndCRolePrivilege)object2.next());
            }
        }
        if ((object2 = FSConfig.getInstance().getControl().getCompanyRoleDAO().getTemplatePrivileges(companyRole.getId())) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                roleCacheInfo.templateSet.add((RoleTemplatePrivilege)object.next());
            }
        }
        if ((object = FSConfig.getInstance().getControl().getCompanyRoleDAO().getDataConnectionPrivileges(companyRole.getId())) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                roleCacheInfo.dataConnectionSet.add((RoleDataConnectionPrivilege)iterator.next());
            }
        }
        roleCacheInfo.addPrivileges4Plates(companyRole.getId(), true);
        return roleCacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(long l2) {
        if (l2 >= 0L) {
            Object object = JROLE_ID_LOCK_CREATOR.getIDLock(l2);
            try {
                Object object2 = object;
                synchronized (object2) {
                    roleMap.remove(new Long(l2));
                }
                Object var6_4 = null;
                JROLE_ID_LOCK_CREATOR.releaseIDLock();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                JROLE_ID_LOCK_CREATOR.releaseIDLock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllEntryPrivileges(long l2, boolean bl) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.entryPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    if (bl) {
                        arrayList.add(EntryTypeAndID.getInstance(entryTypeAndID.getType(), entryTypeAndID.getId(), entryTypeAndID.getView(), entryTypeAndID.getAuthorized(), entryTypeAndID.getEdit()));
                        continue;
                    }
                    arrayList.add(entryTypeAndID.getType() + "" + entryTypeAndID.getId());
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllESPrivileges(long l2, boolean bl) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Set set = roleCacheInfo.ESPrivilegeSet;
                for (EntryTypeAndID entryTypeAndID : set) {
                    if (bl) {
                        arrayList.add(EntryTypeAndID.getInstance(entryTypeAndID.getType(), entryTypeAndID.getId()));
                        continue;
                    }
                    arrayList.add(entryTypeAndID.getType() + "" + entryTypeAndID.getId());
                }
                return arrayList;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllModulePrivileges(long l2) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.moduleSet;
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    arrayList.add(roleModulePrivilege);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    public static List getAllTemplatePrivileges(long l2) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(l2);
        ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
        if (roleCacheInfo != null) {
            Set set = roleCacheInfo.templateSet;
            for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                arrayList.add(roleTemplatePrivilege);
            }
        }
        return arrayList;
    }

    public static List getAllDataConnectionPrivileges(long l2) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(l2);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (roleCacheInfo != null) {
            Set set = roleCacheInfo.dataConnectionSet;
            for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
                arrayList.add(roleDataConnectionPrivilege.getName());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllDepAndCRolePrivileges(long l2, boolean bl) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                Set set = roleCacheInfo.depandcrolePrivilegeSet;
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (bl) {
                        arrayList.add(roleDepAndCRolePrivilege);
                        continue;
                    }
                    arrayList.add(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllPrivilegesWithPlateName(long l2, String string) {
        try {
            CompanyRoleCache.initCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RoleCacheInfo roleCacheInfo = (RoleCacheInfo)roleMap.get(new Long(l2));
        if (roleCacheInfo != null) {
            RoleCacheInfo roleCacheInfo2 = roleCacheInfo;
            synchronized (roleCacheInfo2) {
                ArrayList arrayList = new ArrayList();
                Set set = roleCacheInfo.getPlatePrivilege(string);
                if (set == null) {
                    return null;
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList;
            }
        }
        return null;
    }

    public static boolean containModulePrivilege(long l2, long l3) {
        if (roleMap.isEmpty()) {
            return false;
        }
        return RoleCacheUtils.containModulePrivilege(roleMap, l2, l3);
    }

    public static boolean containEntryPrivilege(long l2, int n2, long l3) {
        return RoleCacheUtils.containEntryPrivilege(roleMap, l2, n2, l3);
    }

    public static boolean containPlatePrivilege(long l2, long l3, String string) {
        return RoleCacheUtils.containPlatePrivilege(roleMap, l2, l3, string);
    }

    public static void refreshModulePrivileges(long l2, Set set) {
        RoleCacheUtils.refreshModulePrivileges(roleMap, l2, set);
    }

    public static void refreshTemplatePrivileges(long l2, Set set) {
        RoleCacheUtils.refreshTemplatePrivileges(roleMap, l2, set);
    }

    public static void refreshEntryPrivileges(long l2, Set set) {
        RoleCacheUtils.refreshEntryPrivileges(roleMap, l2, set);
    }

    public static void refreshDepAndCrolePrivileges(long l2, Set set) {
        RoleCacheUtils.refreshDepAndCRolePrivileges(roleMap, l2, set);
    }

    public static void refreshDataConnectionPrivileges(long l2, Set set) {
        RoleCacheUtils.refreshDataConnectionPrivileges(roleMap, l2, set);
    }

    public static void refreshESPrivileges(long l2, Set set) {
        RoleCacheUtils.refreshESPrivileges(roleMap, l2, set);
    }

    public static void refreshPrivilegesWithPlateName(long l2, Set set, String string) {
        RoleCacheUtils.refreshPlatePrivileges(roleMap, l2, set, string);
    }

    public static void refreshEntryPrivileges(long l2, int n2, long l3, long l4) {
        RoleCacheUtils.refreshEntryPrivileges(roleMap, l2, n2, l3, l4);
    }
}

