/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.adhoc.output;

import com.fr.fs.FSConfig;
import com.fr.fs.adhoc.ADHOCFile;
import com.fr.fs.adhoc.ADHOCReportNode;
import com.fr.fs.adhoc.output.ADHOCFileRepository;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.general.DateUtils;
import com.fr.stable.StableUtils;
import java.io.File;
import java.util.Date;
import java.util.Random;

public class ADHOCReportOutput {
    public static long saveADHOCReport(ADHOCFile aDHOCFile, long l2, String string) throws Exception {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return -1L;
        }
        File file = ADHOCReportOutput.generateUnExsitFile(String.valueOf(l2), aDHOCFile.getSuffix(), string);
        File file2 = ADHOCFileRepository.getInstance().getADHOCDirFile(String.valueOf(l2));
        aDHOCFile.writeFile(file);
        ADHOCReportNode aDHOCReportNode = new ADHOCReportNode(l2, string, file.getAbsolutePath().substring(file2.getAbsolutePath().length()));
        aDHOCReportNode.setId(-1L);
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            SystemManagerFavoriteAndADHOC.getInstance().saveADHOCNode(aDHOCReportNode);
        } else {
            FSConfig.getInstance().getControl().getADHOCReportDAO().save(aDHOCReportNode);
        }
        return aDHOCReportNode.getId();
    }

    public static boolean deleteADHOCReportById(long l2, long l3) throws Exception {
        if (l2 == UserControl.getInstance().getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().deleteADHOCReportById(l3);
        }
        ADHOCReportNode aDHOCReportNode = FSConfig.getInstance().getControl().getADHOCReportDAO().findByID(l3);
        if (aDHOCReportNode != null) {
            new File(aDHOCReportNode.getPath()).delete();
        }
        return FSConfig.getInstance().getControl().getADHOCReportDAO().deleteByID(l3);
    }

    private static File generateUnExsitFile(String string, String string2, String string3) {
        File file = ADHOCFileRepository.getInstance().getADHOCDirFile(string);
        if (!file.exists()) {
            StableUtils.mkdirs(file);
        }
        File file2 = new File(file, string3 + string2);
        while (file2.exists()) {
            file2 = new File(file, DateUtils.getDate2AllIncludeSSS(new Date()) + "_" + new Random().nextInt(1000) + string2);
        }
        return file2;
    }
}

