/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.ui.Connector;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.container.WLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;

public class WAbsoluteLayout
extends WLayout {
    private ArrayList connectorList = new ArrayList();

    public WAbsoluteLayout() {
    }

    public WAbsoluteLayout(String string) {
        if (StringUtils.isNotEmpty(string)) {
            this.setWidgetName(string);
        }
    }

    public void setBounds(Widget widget, Rectangle rectangle) {
        BoundsWidget boundsWidget = this.getBoundsWidget(widget);
        if (boundsWidget != null) {
            boundsWidget.setBounds(rectangle);
        }
    }

    public String getXType() {
        return "absolute";
    }

    public void addConnector(Connector connector) {
        this.connectorList.add(connector);
    }

    public int connectorCount() {
        return this.connectorList.size();
    }

    public void removeConnector(Connector connector) {
        this.connectorList.remove(connector);
    }

    public void clearLinkLine() {
        this.connectorList.clear();
    }

    public Connector getConnectorIndex(int n2) {
        return (Connector)this.connectorList.get(n2);
    }

    public Connector[] getConnector() {
        return this.connectorList.toArray(new Connector[0]);
    }

    public Connector[] getCoveredConnectors(Rectangle rectangle) {
        ArrayList<Connector> arrayList = new ArrayList<Connector>();
        for (int i2 = 0; i2 < this.connectorList.size(); ++i2) {
            Connector connector = (Connector)this.connectorList.get(i2);
            if (!connector.coveredByRectangle(rectangle)) continue;
            arrayList.add(connector);
        }
        return arrayList.toArray(new Connector[arrayList.size()]);
    }

    public String getLayoutToolTip() {
        return Inter.getLocText("WLayout-Absolute-ToolTips");
    }

    public BoundsWidget getBoundsWidget(Widget widget) {
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            BoundsWidget boundsWidget = (BoundsWidget)this.getWidget(i2);
            if (!ComparatorUtils.equals(boundsWidget.getWidget(), widget)) continue;
            return boundsWidget;
        }
        return null;
    }

    protected JSONArray createJSONItems(Repository repository, Calculator calculator) throws JSONException {
        Collections.sort(this.widgetList);
        return super.createJSONItems(repository, calculator);
    }

    public Dimension getMinDesignSize() {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidgetCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            BoundsWidget boundsWidget = (BoundsWidget)this.getWidget(i2);
            if (!boundsWidget.isVisible()) continue;
            Rectangle rectangle = boundsWidget.getBounds();
            n2 = rectangle.x + rectangle.width > n2 ? rectangle.x + rectangle.width : n2;
            n3 = rectangle.y + rectangle.height > n3 ? rectangle.y + rectangle.height : n3;
        }
        return new Dimension(n2, n3);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("connector")) {
            Connector connector = new Connector();
            xMLableReader.readXMLObject(connector);
            this.addConnector(connector);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        Connector[] connectorArray = this.getConnector();
        int n2 = connectorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("connector");
            connectorArray[i2].writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public static class BoundsWidget
    extends Widget
    implements Comparable {
        private Widget widget;
        private Rectangle bounds;

        public BoundsWidget() {
        }

        public BoundsWidget(Widget widget, Rectangle rectangle) {
            this.widget = widget;
            this.bounds = rectangle;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(Rectangle rectangle) {
            this.bounds = rectangle;
        }

        public Widget getWidget() {
            return this.widget;
        }

        public String getWidgetName() {
            return this.widget.getWidgetName();
        }

        public String getXType() {
            return this.widget.getXType();
        }

        public boolean isEditor() {
            return this.widget.isEditor();
        }

        public String[] supportedEvents() {
            return this.widget.supportedEvents();
        }

        public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
            JSONObject jSONObject = this.widget.createJSONConfig(repository, calculator);
            jSONObject.put("x", this.bounds.x);
            jSONObject.put("y", this.bounds.y);
            jSONObject.put("width", this.bounds.width);
            jSONObject.put("height", this.bounds.height);
            return jSONObject;
        }

        public int compareTo(Object object) {
            BoundsWidget boundsWidget = (BoundsWidget)object;
            if (boundsWidget.bounds.y < this.bounds.y || boundsWidget.bounds.y == this.bounds.y && boundsWidget.bounds.x < this.bounds.x) {
                return 1;
            }
            if (boundsWidget.bounds.y == this.bounds.y && boundsWidget.bounds.x == this.bounds.x) {
                return 0;
            }
            return -1;
        }

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode()) {
                String string = xMLableReader.getTagName();
                if ("InnerWidget".equals(string)) {
                    this.widget = WidgetXmlUtils.readWidget(xMLableReader);
                } else if ("BoundsAttr".equals(string)) {
                    this.bounds = new Rectangle(xMLableReader.getAttrAsInt("x", 0), xMLableReader.getAttrAsInt("y", 0), xMLableReader.getAttrAsInt("width", 0), xMLableReader.getAttrAsInt("height", 0));
                }
            }
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter) {
            if (this.widget != null) {
                GeneralXMLTools.writeXMLable(xMLPrintWriter, this.widget, "InnerWidget");
            }
            if (this.bounds != null) {
                xMLPrintWriter.startTAG("BoundsAttr").attr("x", this.bounds.x).attr("y", this.bounds.y).attr("width", this.bounds.width).attr("height", this.bounds.height).end();
            }
        }

        public boolean equals(Object object) {
            return object instanceof BoundsWidget && ComparatorUtils.equals(((BoundsWidget)object).widget, this.widget);
        }

        public Object clone() throws CloneNotSupportedException {
            BoundsWidget boundsWidget = (BoundsWidget)super.clone();
            if (this.widget != null) {
                boundsWidget.widget = (Widget)this.widget.clone();
            }
            if (this.bounds != null) {
                boundsWidget.bounds = (Rectangle)this.bounds.clone();
            }
            return boundsWidget;
        }
    }
}

