/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.form.ui.Button;
import com.fr.form.ui.ComboCheckBox;
import com.fr.form.ui.CustomButton;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.FreeButton;
import com.fr.form.ui.MultiFileEditor;
import com.fr.form.ui.NameWidget;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetConfig;
import com.fr.form.ui.reg.NoneReg;
import com.fr.form.ui.reg.RegExp;
import com.fr.general.GeneralUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Point;

public class WidgetXmlUtils {
    private WidgetXmlUtils() {
    }

    public static RegExp readXMLReg(XMLableReader xMLableReader) {
        RegExp regExp = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.startsWith("com.fr.report.web.ui.reg")) {
                string = Utils.replaceAllString(string, "com.fr.report.web.ui.reg", "com.fr.form.ui.reg");
            }
            try {
                regExp = (RegExp)GeneralUtils.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                regExp = new NoneReg();
            }
        }
        xMLableReader.readXMLObject(regExp);
        return regExp;
    }

    public static void writeXMLWidget(XMLPrintWriter xMLPrintWriter, Widget widget) {
        WidgetXmlUtils.writeXMLWidget(xMLPrintWriter, widget, null);
    }

    public static void writeXMLWidget(XMLPrintWriter xMLPrintWriter, Widget widget, Point point) {
        if (widget == null) {
            return;
        }
        xMLPrintWriter.startTAG("Widget");
        if (point != null) {
            xMLPrintWriter.attr("col", point.x).attr("row", point.y);
        }
        xMLPrintWriter.attr("class", widget.getClass().getName());
        widget.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static FieldEditor readFieldEditor(XMLableReader xMLableReader) {
        Widget widget = WidgetXmlUtils.readWidget(xMLableReader);
        return widget instanceof FieldEditor ? (FieldEditor)widget : null;
    }

    public static Widget readCellWidget(XMLableReader xMLableReader) {
        Widget widget = WidgetXmlUtils.readWidget(xMLableReader);
        return widget instanceof FieldEditor || widget instanceof CustomButton ? widget : null;
    }

    public static Widget readWidget(XMLableReader xMLableReader) {
        Widget widget = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.equals("com.fr.report.web.ui.impl.form.FormSubmitButton") || string.equals("com.fr.report.web.button.form.FormSubmitButton")) {
                string = "com.fr.form.parameter.FormSubmitButton";
            } else if (string.startsWith("com.fr.report.web.ui.impl")) {
                string = string.replaceAll("com.fr.report.web.ui.impl", "com.fr.report.web.button");
            } else if (string.startsWith("com.fr.report.web.ui")) {
                string = string.replaceAll("com.fr.report.web.ui", "com.fr.form.ui");
            }
            if (string.endsWith(".DateTimeEditor")) {
                widget = new DateEditor();
            } else if (string.endsWith(".CheckBoxEditor")) {
                widget = new ComboCheckBox();
                ((ComboCheckBox)widget).setReturnString(true);
            } else {
                if (string.endsWith(".FileEditor")) {
                    widget = new MultiFileEditor();
                    xMLableReader.readXMLObject(widget);
                    ((MultiFileEditor)widget).setMaxLength(1);
                    return widget;
                }
                if (string.endsWith(".ImgBoard") || string.endsWith(".Button")) {
                    widget = new FreeButton();
                } else if (string.equals("com.fr.data.impl.NameWidget")) {
                    widget = new NameWidget();
                } else {
                    if (string.endsWith(".SubmitAll")) {
                        string = string.replaceAll(".SubmitAll", ".Submit");
                    }
                    try {
                        Class clazz = GeneralUtils.classForName(string);
                        widget = (Widget)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                    }
                }
            }
            if (widget != null) {
                xMLableReader.readXMLObject(widget);
            }
        }
        return widget;
    }

    public static void writeXMLWidgetConfig(XMLPrintWriter xMLPrintWriter, WidgetConfig widgetConfig, String string) {
        if (widgetConfig == null) {
            return;
        }
        xMLPrintWriter.startTAG("WidgetConfig");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", widgetConfig.getClass().getName());
        widgetConfig.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static WidgetConfig readXMLWidgetConfig(XMLableReader xMLableReader) {
        WidgetConfig widgetConfig = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                if (string.startsWith("com.fr.report.web.ui")) {
                    string = string.replaceAll("com.fr.report.web.ui", "com.fr.form.ui");
                }
                widgetConfig = (WidgetConfig)GeneralUtils.classForName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                FRContext.getLogger().error(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRContext.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string.endsWith("CustomWidgetConfig")) {
                    return null;
                }
                FRContext.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
            }
            xMLableReader.readXMLObject(widgetConfig);
        }
        return widgetConfig;
    }

    public static Button readButton(XMLableReader xMLableReader) {
        Button button = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                Class clazz = GeneralUtils.classForName(string);
                button = (Button)clazz.newInstance();
                xMLableReader.readXMLObject(button);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        return button;
    }
}

