/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.FRContext;
import com.fr.base.IconManager;
import com.fr.file.XMLFileManager;
import com.fr.form.ui.NameWidget;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetConfig;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListMap;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;
import java.util.Iterator;

public class WidgetManager
extends XMLFileManager
implements XMLable {
    private static WidgetManager widgetManager = null;
    public static final String XML_TAG = "WidgetManager";
    private ListMap nameWidgetConfigMap = new ListMap();
    private IconManager iconManager = null;

    public static WidgetManager getInstance() {
        if (widgetManager == null) {
            widgetManager = new WidgetManager();
            widgetManager.readXMLFile();
        }
        return widgetManager;
    }

    public static synchronized void readInputStream(InputStream inputStream) throws Exception {
        WidgetManager widgetManager = new WidgetManager();
        XMLTools.readInputStreamXML(widgetManager, inputStream);
        WidgetManager.widgetManager = widgetManager;
        FRContext.getCurrentEnv().writeResource(WidgetManager.widgetManager);
    }

    private static synchronized void envChanged() {
        widgetManager = null;
    }

    private WidgetManager() {
    }

    public String fileName() {
        return "widgets.xml";
    }

    public Iterator getWidgetConfigNameIterator() {
        return this.nameWidgetConfigMap.keySet().iterator();
    }

    private WidgetConfig getStoredWidgetConfig(String string) {
        return (WidgetConfig)this.nameWidgetConfigMap.get(string);
    }

    private void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public IconManager getIconManager() {
        this.iconManager = IconManager.getIconManager();
        return this.iconManager;
    }

    public WidgetConfig getWidgetConfig(String string) {
        WidgetConfig widgetConfig = this.getStoredWidgetConfig(string);
        try {
            return widgetConfig == null ? null : (WidgetConfig)widgetConfig.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public void putWidgetConfig(String string, WidgetConfig widgetConfig) {
        if (widgetConfig == null) {
            this.nameWidgetConfigMap.remove(string);
        }
        this.nameWidgetConfigMap.put(string, widgetConfig);
    }

    public boolean renameWidgetConfig(String string, String string2) {
        if (!this.nameWidgetConfigMap.containsKey(string) || this.nameWidgetConfigMap.containsKey(string2)) {
            return false;
        }
        int n2 = this.nameWidgetConfigMap.indexOf(string);
        this.nameWidgetConfigMap.put(n2, string2, this.nameWidgetConfigMap.get(string));
        return true;
    }

    public void removeWidgetConfig(String string) {
        this.nameWidgetConfigMap.remove(string);
    }

    public void clearAllWidgetConfig() {
        this.nameWidgetConfigMap.clear();
    }

    public static Widget widgetConfig2NameWidget(WidgetConfig widgetConfig) {
        WidgetManager widgetManager = WidgetManager.getInstance();
        Iterator iterator = widgetManager.getWidgetConfigNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!ComparatorUtils.equals(widgetManager.getWidgetConfig(string), widgetConfig)) continue;
            return new NameWidget(string);
        }
        return null;
    }

    public static Widget widget2NameWidget(Widget widget) {
        WidgetManager widgetManager = WidgetManager.getInstance();
        Iterator iterator = widgetManager.getWidgetConfigNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!ComparatorUtils.equals(widgetManager.getWidgetConfig(string).toWidget(), widget)) continue;
            return new NameWidget(string);
        }
        return widget;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearAllWidgetConfig();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = "";
            if (string.equals("XMLVersion")) {
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("WidgetConfigMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("WidgetConfig")) {
                            String string = null;
                            String string2 = null;
                            string2 = xMLableReader.getAttrAsString("name", null);
                            if (string2 != null) {
                                string = string2;
                            }
                            if (string == null) {
                                return;
                            }
                            WidgetConfig widgetConfig = WidgetXmlUtils.readXMLWidgetConfig(xMLableReader);
                            if (widgetConfig != null) {
                                WidgetManager.this.putWidgetConfig(string, widgetConfig);
                            }
                        }
                    }
                });
            } else if ("IM".equals(string)) {
                this.iconManager = IconManager.getIconManager();
                xMLableReader.readXMLObject(this.iconManager);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        Iterator iterator = this.getWidgetConfigNameIterator();
        if (iterator.hasNext()) {
            xMLPrintWriter.startTAG("WidgetConfigMap");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                WidgetConfig widgetConfig = this.getStoredWidgetConfig(string);
                if (widgetConfig == null) continue;
                WidgetXmlUtils.writeXMLWidgetConfig(xMLPrintWriter, widgetConfig, string);
            }
            xMLPrintWriter.end();
        }
        if (this.iconManager != null) {
            this.iconManager.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                WidgetManager.envChanged();
            }
        });
    }
}

