/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.WaterMark;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class DirectWriteEditor
extends FieldEditor
implements WaterMark {
    protected boolean directEdit = true;
    protected String waterMark;

    public boolean isDirectEdit() {
        return this.directEdit;
    }

    public void setDirectEdit(boolean bl) {
        this.directEdit = bl;
    }

    public void setWaterMark(String string) {
        this.waterMark = string;
    }

    public String getWaterMark() {
        return this.waterMark;
    }

    public String[] supportedEvents() {
        return (String[])ArrayUtils.addAll(super.supportedEvents(), new String[]{"click"});
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        jSONObject.put("directEdit", (Object)this.directEdit);
        if (StringUtils.isNotBlank(this.waterMark)) {
            FieldEditor.setWaterMarkConfig(this.waterMark, jSONObject, calculator);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("DirectEdit") || string.equals("Editable")) {
                this.readDirectEditXML(xMLableReader);
            } else if (string.equals("watermark")) {
                this.setWaterMark(xMLableReader.getElementValue());
            }
        }
    }

    protected void readDirectEditXML(XMLableReader xMLableReader) {
        this.directEdit = Boolean.valueOf(xMLableReader.getElementValue());
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!this.directEdit) {
            xMLPrintWriter.startTAG("DirectEdit").textNode(String.valueOf(this.directEdit)).end();
        }
        if (StringUtils.isNotBlank(this.waterMark)) {
            xMLPrintWriter.startTAG("watermark").textNode(this.waterMark).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof DirectWriteEditor && super.equals(object) && this.directEdit == ((DirectWriteEditor)object).directEdit && ComparatorUtils.equals(this.waterMark, ((DirectWriteEditor)object).waterMark);
    }
}

