/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Utils;
import com.fr.data.core.FormatField;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.DependControl;
import com.fr.form.ui.DirectWriteEditor;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.WidgetValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DateEditor
extends DirectWriteEditor
implements DataControl,
DependControl {
    private String startDate;
    private String endDate;
    private Formula startDateFM;
    private Formula endDateFM;
    private String formatText = "yyyy-MM-dd";
    private boolean returnDate = false;
    private WidgetValue widgetValue = new WidgetValue(new Date());
    public static String oldDateTimeWidgetTag = "com.fr.report.web.ui.DateTimeEditor";
    public static String oldDateTimeFormat = "yyyy-MM-dd HH:mm";

    public String getXType() {
        return "datetime";
    }

    public String getFormatText() {
        return this.formatText;
    }

    public void setFormatText(String string) {
        this.formatText = string;
    }

    public int[] getValueType() {
        return new int[]{4, 3, 2};
    }

    public void setWidgetValue(WidgetValue widgetValue) {
        this.widgetValue = widgetValue;
    }

    public WidgetValue getWidgetValue() {
        return this.widgetValue;
    }

    public String[] getDependence(Calculator calculator) {
        String[] stringArray = BaseUtils.getDependence(this.getStartDate(), calculator);
        String[] stringArray2 = BaseUtils.getDependence(this.getEndDate(), calculator);
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = Arrays.asList(stringArray);
        arrayList.addAll(list);
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            if (arrayList.contains(stringArray2[i2])) continue;
            arrayList.add(stringArray2[i2]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Object getStartDateValue(Calculator calculator) throws Exception {
        if (this.startDateFM != null) {
            return calculator.eval(this.startDateFM);
        }
        if (this.startDate != null) {
            return DateUtils.string2Date(this.startDate, true);
        }
        return null;
    }

    public Object getEndDateValue(Calculator calculator) throws Exception {
        if (this.endDateFM != null) {
            return calculator.eval(this.endDateFM);
        }
        if (this.endDate != null) {
            return DateUtils.string2Date(this.endDate, true);
        }
        return null;
    }

    public Object getStartDate() {
        if (this.startDateFM != null) {
            return this.startDateFM;
        }
        if (this.startDate != null) {
            return DateUtils.string2Date(this.startDate, true);
        }
        return null;
    }

    public void setStartDate(Object object) {
        if (object instanceof Formula) {
            this.startDateFM = (Formula)object;
            this.startDate = null;
        } else if (object instanceof Date) {
            this.startDateFM = null;
            this.startDate = DateUtils.getDate2Str("MM/dd/yyyy", (Date)object);
        } else {
            this.startDateFM = null;
            this.startDate = null;
        }
    }

    public Object getEndDate() {
        if (this.endDateFM != null) {
            return this.endDateFM;
        }
        if (this.endDate != null) {
            return DateUtils.string2Date(this.endDate, true);
        }
        return null;
    }

    public void setEndDate(Object object) {
        if (object instanceof Formula) {
            this.endDateFM = (Formula)object;
            this.endDate = null;
        } else if (object instanceof Date) {
            this.endDateFM = null;
            this.endDate = DateUtils.getDate2Str("MM/dd/yyyy", (Date)object);
        } else {
            this.endDateFM = null;
            this.endDate = null;
        }
    }

    public String getStartText() {
        return this.startDate;
    }

    public void setStartText(String string) {
        this.startDate = string;
    }

    public String getEndText() {
        return this.endDate;
    }

    public void setEndText(String string) {
        this.endDate = string;
    }

    public Formula getStartDateFM() {
        return this.startDateFM;
    }

    public void setStartDateFM(Formula formula) {
        this.startDateFM = formula;
    }

    public Formula getEndDateFM() {
        return this.endDateFM;
    }

    public void setEndDateFM(Formula formula) {
        this.endDateFM = formula;
    }

    public boolean isReturnDate() {
        return this.returnDate;
    }

    public void setReturnDate(boolean bl) {
        this.returnDate = bl;
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        if (this.getWidgetValue() == null) {
            return;
        }
        WidgetValue.WidgetValueInfo widgetValueInfo = new WidgetValue.WidgetValueInfo(this.getWidgetName());
        Object object = this.getWidgetValue().createAttrResult(widgetValueInfo, calculator, jSONObject2);
        if (!this.returnDate && object instanceof Date && this.formatText != null) {
            object = new SimpleDateFormat(this.formatText).format((Date)object);
        }
        try {
            jSONObject.put(this.widgetName.toUpperCase(), object == null ? "" : object);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        Object[] objectArray;
        JSONObject jSONObject = super.createJSONConfig(repository, calculator);
        try {
            objectArray = jSONObject.get("value");
            if (objectArray instanceof Date) {
                jSONObject.put("value", new JSONObject().put("date_milliseconds", ((Date)objectArray).getTime()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty(this.formatText)) {
            jSONObject.put("format", this.formatText);
            if (!ArrayUtils.contains(FormatField.getInstance().getDateFormatArray(), this.formatText)) {
                jSONObject.put("customFormat", true);
            }
        }
        if (this.startDate != null) {
            jSONObject.put("startDate", this.value2Config(this.startDate, calculator));
        } else if (this.startDateFM != null) {
            try {
                jSONObject.put("startDate", this.value2Config(Calculator.createCalculator().evalValue(this.startDateFM.getContent()), calculator));
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().error(utilEvalError.getMessage());
            }
        }
        if (this.endDate != null) {
            jSONObject.put("endDate", this.value2Config(this.endDate, calculator));
        } else if (this.endDateFM != null) {
            try {
                jSONObject.put("endDate", this.value2Config(Calculator.createCalculator().evalValue(this.endDateFM.getContent()), calculator));
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().error(utilEvalError.getMessage());
            }
        }
        if (this.returnDate) {
            jSONObject.put("returnDate", true);
        }
        if (!ArrayUtils.isEmpty(objectArray = this.getDependence(calculator))) {
            jSONObject.put("dependence", objectArray);
        }
        return jSONObject;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute());
        FieldEditor.DependenceNameSpace dependenceNameSpace = new FieldEditor.DependenceNameSpace(CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        calculator.pushNameSpace(parameterMapNameSpace);
        calculator.pushNameSpace(dependenceNameSpace);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("startDate", this.getStartDateValue(calculator));
        jSONObject.put("endDate", this.getEndDateValue(calculator));
        jSONArray.put(jSONObject);
        calculator.removeNameSpace(parameterMapNameSpace);
        calculator.removeNameSpace(dependenceNameSpace);
        return jSONArray;
    }

    public Object value2Config(Object object, CalculatorProvider calculatorProvider) {
        String string;
        if (object instanceof Date) {
            string = new SimpleDateFormat(this.formatText).format((Date)object);
        } else if (object == null) {
            string = "";
        } else {
            String string2 = Utils.objectToString(object);
            try {
                Date date = DateUtils.string2Date(string2, false);
                string = new SimpleDateFormat(this.formatText).format(date);
            }
            catch (Exception exception) {
                string = object.toString();
            }
        }
        return string;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "afteredit", "stopedit"};
    }

    public boolean equals(Object object) {
        return object instanceof DateEditor && super.equals(object) && ComparatorUtils.equals(this.startDate, ((DateEditor)object).startDate) && ComparatorUtils.equals(this.endDate, ((DateEditor)object).endDate) && this.returnDate == ((DateEditor)object).returnDate;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            string = xMLableReader.getTagName();
            if (string.equals("DateAttr")) {
                String string2 = null;
                string2 = xMLableReader.getAttrAsString("format", null);
                if (string2 != null) {
                    this.setFormatText(string2);
                }
                if ((string2 = xMLableReader.getAttrAsString("start", null)) != null) {
                    this.startDate = string2;
                } else {
                    string2 = xMLableReader.getAttrAsString("startdatefm", null);
                    if (string2 != null) {
                        this.startDateFM = new Formula(string2);
                    }
                }
                string2 = xMLableReader.getAttrAsString("end", null);
                if (string2 != null) {
                    this.endDate = string2;
                } else {
                    string2 = xMLableReader.getAttrAsString("enddatefm", null);
                    if (string2 != null) {
                        this.endDateFM = new Formula(string2);
                    }
                }
                this.returnDate = xMLableReader.getAttrAsBoolean("returnDate", false);
            } else if ("widgetValue".equals(string)) {
                this.widgetValue = new WidgetValue();
                xMLableReader.readXMLObject(this.widgetValue);
            }
        }
        if (ComparatorUtils.equals(xMLableReader.getAttrAsString("class", null), oldDateTimeWidgetTag)) {
            string = null;
            string = xMLableReader.getAttrAsString("format", null);
            if (string == null) {
                this.setFormatText(oldDateTimeFormat);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DateAttr");
        if (!ComparatorUtils.equals(this.getFormatText(), this.getDefaultFormatText())) {
            xMLPrintWriter.attr("format", this.getFormatText());
        }
        if (!StringUtils.isEmpty(this.startDate)) {
            xMLPrintWriter.attr("start", this.startDate);
        } else if (this.startDateFM != null) {
            xMLPrintWriter.attr("startdatefm", this.startDateFM.getContent());
        }
        if (!StringUtils.isEmpty(this.endDate)) {
            xMLPrintWriter.attr("end", this.endDate);
        } else if (this.endDateFM != null) {
            xMLPrintWriter.attr("enddatefm", this.endDateFM.getContent());
        }
        if (this.returnDate) {
            xMLPrintWriter.attr("returnDate", this.returnDate);
        }
        xMLPrintWriter.end();
        if (this.widgetValue != null) {
            this.widgetValue.writeXML(xMLPrintWriter);
        }
    }

    protected String getDefaultFormatText() {
        return "yyyy-MM-dd";
    }
}

