/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.GraphHelper;
import com.fr.general.ComparatorUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Connector
implements XMLable {
    private int unit = 5;
    private static final long serialVersionUID = 4289688454029774161L;
    private ArrayList pointList = new ArrayList();
    private int code;

    public Connector addAll(ArrayList arrayList) {
        this.pointList.clear();
        this.pointList.addAll(arrayList);
        return this;
    }

    public Point getStartPoint() {
        return (Point)this.pointList.get(0);
    }

    public Point getEndPoint() {
        return (Point)this.pointList.get(this.pointList.size() - 1);
    }

    public int getPointCount() {
        return this.pointList.size();
    }

    public void addPoint(int n2, Point point) {
        this.pointList.add(n2, point);
    }

    public Point getPointIndex(int n2) {
        return (Point)this.pointList.get(n2);
    }

    public void checkPoint() {
        Point point;
        Point point2;
        int n2;
        int n3 = this.pointList.size();
        for (n2 = 1; n2 < n3; ++n2) {
            point2 = (Point)this.pointList.get(n2 - 1);
            point = (Point)this.pointList.get(n2);
            if (point2.x != point.x || point2.y != point.y || !this.pointList.remove(point2)) continue;
            --n3;
        }
        for (n2 = 2; n2 < n3; ++n2) {
            point2 = (Point)this.pointList.get(n2 - 2);
            point = (Point)this.pointList.get(n2 - 1);
            Point point3 = (Point)this.pointList.get(n2);
            if ((point2.x != point.x || point2.x != point3.x) && (point2.y != point.y || point2.y != point3.y) || !this.pointList.remove(point)) continue;
            --n3;
        }
    }

    private boolean between(int n2, int n3, int n4) {
        if (n3 > n4) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        return n2 >= n3 && n2 <= n4;
    }

    private boolean isOverGo(Point point, Point point2, Rectangle rectangle) {
        if (point.x != point2.x && point.y != point2.y) {
            return false;
        }
        return point.x == point2.x && this.between(point.x, rectangle.x, rectangle.x + rectangle.width) && (this.between(rectangle.y, point.y, point2.y) || this.between(rectangle.y + rectangle.height, point.y, point2.y)) || point.y == point2.y && this.between(point.y, rectangle.y, rectangle.y + rectangle.height) && (this.between(rectangle.x, point.x, point2.x) || this.between(rectangle.x + rectangle.width, point.x, point2.x));
    }

    public boolean nearPoint(Point point) {
        int n2 = this.pointList.size();
        Point point2 = (Point)this.pointList.get(0);
        for (int i2 = 1; i2 < n2; ++i2) {
            Point point3 = (Point)this.pointList.get(i2);
            if (this.isNear(point2, point3, point)) {
                return true;
            }
            point2 = point3;
        }
        return false;
    }

    private boolean isNear(Point point, Point point2, Point point3) {
        return point.x == point2.x && this.between(point3.x, point.x - this.unit, point.x + this.unit) && this.between(point3.y, point.y, point2.y) || point.y == point2.y && this.between(point3.y, point.y - this.unit, point.y + this.unit) && this.between(point3.x, point.x, point2.x);
    }

    public boolean coveredByRectangle(Rectangle rectangle) {
        int n2 = this.pointList.size();
        Point point = (Point)this.pointList.get(0);
        for (int i2 = 1; i2 < n2; ++i2) {
            Point point2 = (Point)this.pointList.get(i2);
            if (this.isOverGo(point, point2, rectangle)) {
                return true;
            }
            point = point2;
        }
        return false;
    }

    public Rectangle[] getEditableLineRectangle() {
        int n2 = this.pointList.size();
        if (n2 <= 1) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[n2 - 1];
        Point point = (Point)this.pointList.get(0);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            Point point2 = (Point)this.pointList.get(i2 + 1);
            rectangleArray[i2] = new Rectangle(point.x, point.y, point2.x, point2.y);
            point = point2;
        }
        return rectangleArray;
    }

    public Point getMidPoint(Point point, Point point2) {
        if (point.x == point2.x) {
            return new Point(point.x, (point.y + point2.y) / 2);
        }
        return new Point((point.x + point2.x) / 2, point.y);
    }

    public Point[] getEditAblePoint() {
        int n2 = this.pointList.size();
        if (n2 <= 1) {
            return new Point[0];
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(this.getStartPoint());
        Point point = (Point)this.pointList.get(0);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            Point point2 = (Point)this.pointList.get(i2 + 1);
            arrayList.add(this.getMidPoint(point, point2));
            point = point2;
        }
        arrayList.add(this.getEndPoint());
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    public void draw(Graphics graphics) {
        Point[] pointArray = this.pointList.toArray(new Point[this.pointList.size()]);
        for (int i2 = 0; i2 < pointArray.length - 1; ++i2) {
            GraphHelper.drawLine(graphics, pointArray[i2].x, pointArray[i2].y, pointArray[i2 + 1].x, pointArray[i2 + 1].y);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "point".equals(xMLableReader.getTagName())) {
            this.pointList.add(new Point(xMLableReader.getAttrAsInt("x", 0), xMLableReader.getAttrAsInt("y", 0)));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        for (int i2 = 0; i2 < this.pointList.size(); ++i2) {
            xMLPrintWriter.startTAG("point").attr("x", ((Point)this.pointList.get((int)i2)).x).attr("y", ((Point)this.pointList.get((int)i2)).y).end();
        }
    }

    public int hashCode() {
        if (this.code == 0) {
            int n2;
            int n3 = 20;
            int n4 = this.pointList.get(0).hashCode();
            if (n4 > (n2 = this.pointList.get(this.pointList.size() - 1).hashCode())) {
                int n5 = n4;
                n4 = n2;
                n2 = n5;
            }
            n3 = 89 * n3 + n4;
            this.code = n3 = 89 * n3 + n2;
        }
        return this.code;
    }

    public boolean equals(Object object) {
        return object instanceof Connector && this.pointList.size() > 1 && ((Connector)object).pointList.size() > 1 && ComparatorUtils.equals(((Connector)object).getStartPoint(), this.getStartPoint()) && ComparatorUtils.equals(((Connector)object).getEndPoint(), this.getEndPoint());
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

