/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.main.parameter;

import com.fr.base.Parameter;
import com.fr.base.parameter.ParameterUI;
import com.fr.data.TableDataSource;
import com.fr.form.main.Form;
import com.fr.form.ui.CellWidget;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.EditorHolder;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.Label;
import com.fr.form.ui.TextEditor;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetValue;
import com.fr.form.ui.container.WAbsoluteLayout;
import com.fr.form.ui.container.WBorderLayout;
import com.fr.form.ui.container.WHorizontalBoxLayout;
import com.fr.form.ui.container.WLayout;
import com.fr.form.ui.container.WVerticalBoxLayout;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionIDInfor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class FormParameterUI
extends Form
implements ParameterUI {
    private boolean needToConvert;
    private CellWidget[] cellWidgets;
    private Dimension designSize;
    private boolean useDefaultSize = true;

    public FormParameterUI() {
        WAbsoluteLayout wAbsoluteLayout = new WAbsoluteLayout();
        wAbsoluteLayout.setWidgetName("para");
        this.setContainer(wAbsoluteLayout);
        this.setDesignSize(new Dimension(1000, 80));
    }

    public FormParameterUI(WLayout wLayout) {
        this.setContainer(wLayout);
        this.setDesignSize(new Dimension(1000, 80));
    }

    public FormParameterUI(CellWidget[] cellWidgetArray) {
        this.needToConvert = true;
        this.cellWidgets = cellWidgetArray;
    }

    public void setCellWidgets(CellWidget[] cellWidgetArray) {
        this.needToConvert = true;
        this.cellWidgets = cellWidgetArray;
    }

    public boolean isUseDefaultSize() {
        return this.useDefaultSize;
    }

    public Widget[] getAllWidgets() {
        WLayout wLayout = this.getContainer();
        if (wLayout != null) {
            Widget[] widgetArray = new Widget[wLayout.getWidgetCount()];
            for (int i2 = 0; i2 < widgetArray.length; ++i2) {
                widgetArray[i2] = wLayout.getWidget(i2);
                if (!(widgetArray[i2] instanceof WAbsoluteLayout.BoundsWidget)) continue;
                widgetArray[i2] = ((WAbsoluteLayout.BoundsWidget)widgetArray[i2]).getWidget();
            }
            return widgetArray;
        }
        return new Widget[0];
    }

    private void convertCellWidgets() {
        if (this.cellWidgets == null) {
            return;
        }
        WAbsoluteLayout wAbsoluteLayout = new WAbsoluteLayout();
        wAbsoluteLayout.setWidgetName("para");
        for (int i2 = 0; i2 < this.cellWidgets.length; ++i2) {
            CellWidget cellWidget = this.cellWidgets[i2];
            if (cellWidget.getWidget() instanceof Label) {
                if (cellWidget.getStyle().getBackground() == null) {
                    wAbsoluteLayout.addWidget(new WAbsoluteLayout.BoundsWidget(cellWidget.getWidget(), cellWidget.getRect()));
                    continue;
                }
                WBorderLayout wBorderLayout = new WBorderLayout();
                wBorderLayout.setWidgetName("border" + i2);
                wBorderLayout.setBackground(cellWidget.getStyle().getBackground());
                if (cellWidget.getCellValue() != null) {
                    wBorderLayout.addCenter(cellWidget.getWidget());
                }
                wAbsoluteLayout.addWidget(new WAbsoluteLayout.BoundsWidget(wBorderLayout, cellWidget.getRect()));
                continue;
            }
            wAbsoluteLayout.addWidget(new WAbsoluteLayout.BoundsWidget(cellWidget.getWidget(), cellWidget.getRect()));
        }
        this.setContainer(wAbsoluteLayout);
    }

    public JSONObject excutedFormJS(Repository repository, JSONObject jSONObject) throws JSONException {
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(repository);
        sessionIDInfor.setAttribute("paramsheet", this);
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.class, sessionIDInfor.getTableDataSource());
        jSONObject.put("isForm", true);
        jSONObject.put("width", this.getDesignSize().getWidth());
        jSONObject.put("height", this.getDesignSize().getHeight());
        Widget[] widgetArray = this.getAllWidgets();
        repository.getHttpServletReques().setAttribute(AbstractJavaScript.RECALCULATE_TAG, (Object)Boolean.TRUE);
        jSONObject.put("html", this.createJSONConfig(repository, calculator));
        repository.getHttpServletReques().removeAttribute(AbstractJavaScript.RECALCULATE_TAG);
        return jSONObject;
    }

    public ParameterUI createDefault() {
        return FormParameterUI.createDefaultParameterUI();
    }

    public static FormParameterUI createDefaultParameterUI() {
        return new FormParameterUI();
    }

    private boolean isInitialSize(Dimension dimension) {
        return dimension == null || dimension.width == 1000 && dimension.height == 80;
    }

    public static FormParameterUI createDefaultParameterUI(Parameter[] parameterArray, Map map, Map map2) {
        int n2;
        WHorizontalBoxLayout[] wHorizontalBoxLayoutArray;
        int n3;
        int n4 = 3;
        WBorderLayout wBorderLayout = new WBorderLayout();
        wBorderLayout.setWidgetName("para");
        WVerticalBoxLayout wVerticalBoxLayout = new WVerticalBoxLayout();
        wVerticalBoxLayout.setWidgetName("wv");
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (n3 = 0; n3 < parameterArray.length; ++n3) {
            String string;
            wHorizontalBoxLayoutArray = parameterArray[n3];
            if (wHorizontalBoxLayoutArray == null || (string = wHorizontalBoxLayoutArray.getName()) == null || hashSet.contains(string.toUpperCase())) continue;
            arrayList.add(parameterArray[n3]);
            hashSet.add(string.toUpperCase());
        }
        n3 = arrayList.size();
        wHorizontalBoxLayoutArray = new WHorizontalBoxLayout[n3 / n4 + 1];
        for (n2 = 0; n2 < wHorizontalBoxLayoutArray.length; ++n2) {
            wHorizontalBoxLayoutArray[n2].setHgap(5);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Parameter parameter = (Parameter)arrayList.get(n2);
            if (n2 % n3 == 0) {
                parameter.getName();
            }
            Label label = new Label();
            label.setWidgetValue(new WidgetValue(parameter.getName()));
            label.setWidgetName("label" + n2);
            wHorizontalBoxLayoutArray[n2 / n3].addWidget(new Label());
            FieldEditor fieldEditor = null;
            if (map != null) {
                fieldEditor = (FieldEditor)map.get(parameter.getName());
            }
            if (fieldEditor == null) {
                fieldEditor = new TextEditor();
            }
            fieldEditor.setWidgetName(parameter.getName());
            wHorizontalBoxLayoutArray[n2 / n3].addWidget(fieldEditor);
        }
        FormParameterUI formParameterUI = new FormParameterUI(wBorderLayout);
        formParameterUI.setDesignSize(new Dimension(800, 200));
        return formParameterUI;
    }

    public void setTableDataSource(TableDataSource tableDataSource) {
    }

    public void setDefaultSize() {
        this.setDesignSize(new Dimension(1000, 80));
    }

    public void setDesignSize(Dimension dimension) {
        this.designSize = dimension;
    }

    public Dimension getDesignSize() {
        return this.designSize;
    }

    public boolean renameTableData(String string, String string2) {
        this._renameTableData(string, string2);
        return true;
    }

    public ParameterUI convert() {
        if (this.needToConvert) {
            this.convertCellWidgets();
            this.cellWidgets = null;
            this.needToConvert = false;
        }
        return this;
    }

    public void checkContainer() {
        Widget widget;
        if (this.getContainer() instanceof WAbsoluteLayout) {
            return;
        }
        WLayout wLayout = this.getContainer();
        while (wLayout.getWidgetCount() == 1 && (widget = wLayout.getWidget(0)) instanceof WLayout) {
            wLayout = (WLayout)widget;
            if (!(wLayout instanceof WAbsoluteLayout)) continue;
            this.setContainer(wLayout);
        }
    }

    public void setParamaterValueFor_7_0_Version(Parameter[] parameterArray) {
        if (!(this.getContainer() instanceof WAbsoluteLayout) || parameterArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < parameterArray.length; ++i2) {
            Widget widget = this.getWidgetByName(parameterArray[i2].getName());
            if (!(widget instanceof DataControl) || ((DataControl)((Object)widget)).getWidgetValue() != null && !StringUtils.isEmpty(((DataControl)((Object)widget)).getWidgetValue().toString())) continue;
            if (widget instanceof EditorHolder) {
                ((EditorHolder)widget).setWidgetValue(new WidgetValue(parameterArray[i2].getValue()));
                continue;
            }
            WidgetValue.convertWidgetValue((DataControl)((Object)widget), parameterArray[i2].getValue());
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("DesignAttr")) {
            this.designSize = new Dimension(xMLableReader.getAttrAsInt("width", 1000), xMLableReader.getAttrAsInt("height", 80));
            this.useDefaultSize = false;
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!this.isInitialSize(this.designSize)) {
            xMLPrintWriter.startTAG("DesignAttr").attr("width", this.designSize.width).attr("height", this.designSize.height).end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FormParameterUI formParameterUI = (FormParameterUI)super.clone();
        formParameterUI.designSize = this.getDesignSize() == null ? new Dimension(1000, 80) : (Dimension)this.getDesignSize().clone();
        return super.clone();
    }
}

