/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.main;

import com.fr.base.Env;
import com.fr.base.ModuleContext;
import com.fr.base.io.IOFile;
import com.fr.base.io.XMLEncryptUtils;
import com.fr.form.main.Form;
import com.fr.form.module.FormModule;
import com.fr.general.FRLogManager;
import com.fr.general.Inter;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

public class FormIO {
    public static Form readForm(Env env, String string) throws Exception {
        if (string == null) {
            return null;
        }
        FRLogManager.declareResourceReadStart(string);
        ModuleContext.startModule(FormModule.class.getName());
        Form form = new Form();
        try {
            InputStream inputStream = env.readBean(string, "reportlets");
            if (inputStream == null) {
                throw new FileNotFoundException(Inter.getLocText("Cannot_Found_Template_File") + ":" + string);
            }
            form.readStream(XMLEncryptUtils.decodeInputStream(inputStream));
            inputStream.close();
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareResourceReadEnd();
        }
        return form;
    }

    public static boolean writeForm(Env env, IOFile iOFile, String string) throws Exception {
        FRLogManager.declareResourceWriteStart(string);
        ModuleContext.startModule(FormModule.class.getName());
        try {
            OutputStream outputStream = env.writeBean(string, "reportlets");
            iOFile.export(outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareResourceWriteEnd();
        }
        return true;
    }
}

