/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.event;

import com.fr.base.Utils;
import com.fr.form.event.Listener;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FCloneable;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Observer
implements FCloneable,
Serializable {
    private List<Listener> listeners = new ArrayList<Listener>();

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        Object[] objectArray = this.supportedEvents();
        if (ArrayUtils.isEmpty(objectArray)) {
            return;
        }
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(objectArray[i2], listener.getEventName())) continue;
            this.listeners.add(listener);
            return;
        }
        Map map = this.getConvertMap();
        if (map != null && map.containsKey(listener.getEventName())) {
            listener.setEventName(Utils.objectToString(map.get(listener.getEventName())));
            this.listeners.add(listener);
        }
    }

    protected Map getConvertMap() {
        return null;
    }

    public Listener getListener(int n2) {
        return this.listeners.get(n2);
    }

    public int getListenerSize() {
        return this.listeners.size();
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public Listener[] createListeners(Repository repository) {
        return this.listeners.toArray(new Listener[this.listeners.size()]);
    }

    public abstract String[] supportedEvents();

    public boolean equals(Object object) {
        return object instanceof Observer && ComparatorUtils.equals(this.listeners, ((Observer)object).listeners);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            this.clearListeners();
        }
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Listener")) {
            Listener listener = new Listener();
            xMLableReader.readXMLObject(listener);
            this.dealWithListener4Compatible(listener);
            this.addListener(listener);
        }
    }

    protected void dealWithListener4Compatible(Listener listener) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2 = this.listeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.listeners.get(i2).writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Observer observer = (Observer)super.clone();
        observer.listeners = new ArrayList<Listener>();
        int n2 = this.listeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            observer.listeners.add((Listener)this.listeners.get(i2).clone());
        }
        return observer;
    }

    public JSONArray createJSONListener(Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Listener[] listenerArray = this.createListeners(repository);
        int n2 = listenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jSONArray.put(listenerArray[i2].createJSONConfig(repository));
        }
        return jSONArray;
    }
}

