/*
 * Decompiled with CFR 0.152.
 */
package com.fr.dav;

import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.EnvException;
import com.fr.base.FRContext;
import com.fr.base.ModifiedTable;
import com.fr.base.ModuleContext;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.StoreProcedureParameter;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.base.fservice.FServicePrivilegeProvider;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.dav.UserBaseEnv;
import com.fr.file.DatasourceManager;
import com.fr.file.WebXmlConfigManager;
import com.fr.file.filetree.FileNode;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.J2EEContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public class LocalEnv
implements Env {
    public static final String[] FILE_TYPE = new String[]{"cpt", "frm", "form", "cht", "chart", "xls", "xlsx"};
    public static final int TIMEOUT = 30000;
    public String path;
    private Timer userCheckTimer = null;
    private UserBaseEnv userBaseEnv = null;
    private String licName;

    public LocalEnv() {
    }

    public void registerUserEnv(UserBaseEnv userBaseEnv) {
        this.userBaseEnv = userBaseEnv;
    }

    public void startUserCheckTimer() {
        if (this.userCheckTimer != null) {
            return;
        }
        this.userCheckTimer = new Timer();
        this.userCheckTimer.schedule(new TimerTask(){

            public void run() {
                if (LocalEnv.this.userBaseEnv != null) {
                    LocalEnv.this.userBaseEnv.checkUserConnectedTimeOut();
                }
            }
        }, 120000L, 120000L);
    }

    public void stopUserCheckTimer() {
        this.userCheckTimer.cancel();
        this.userCheckTimer = null;
    }

    public boolean isNoRemoteUser() {
        return this.userCheckTimer == null;
    }

    public ModifiedTable getDataSourceModifiedTables(String string) {
        if (ComparatorUtils.equals(string, "CONNECTION")) {
            return DatasourceManager.getInstance().getConnectionTotalModifiedtables();
        }
        return DatasourceManager.getInstance().getTableDataLocalModifyTable();
    }

    public boolean writeDataSourceModifiedTables(ModifiedTable modifiedTable, String string) {
        if (ComparatorUtils.equals(string, "CONNECTION")) {
            DatasourceManager.getInstance().updateSelfConnectionTotalModifiedTable(modifiedTable, "local");
        } else {
            DatasourceManager.getInstance().updateSelfTableDataTotalModifiedTable(modifiedTable, "local");
        }
        return true;
    }

    public LocalEnv(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public String getLicName() {
        return StringUtils.isEmpty(this.licName) ? "FineReport.lic" : this.licName;
    }

    public void setLicName(String string) {
        this.licName = string;
    }

    public String getEnvDescription() {
        return Inter.getLocText("Env-Local_Directory");
    }

    public void signIn() throws Exception {
        this.checkValid();
    }

    private void checkValid() throws EnvException {
        File file = new File(this.path);
        if (!file.isDirectory()) {
            throw new EnvException(this.path + " is not a valid directory.");
        }
        if (!ComparatorUtils.equals(file.getName(), "WEB-INF")) {
            throw new EnvException(Inter.getLocText("Env-Des1"));
        }
    }

    public boolean signOut() throws Exception {
        return true;
    }

    public boolean isTemplateExist(String string) throws Exception {
        if (string == null) {
            return false;
        }
        return new File(StableUtils.pathJoin(new String[]{this.path, "reportlets", string})).exists();
    }

    public void unlockTemplate(String string) throws Exception {
    }

    public boolean createFolder(String string) {
        File file = new File(StableUtils.pathJoin(new String[]{this.path, string}));
        if (file.exists()) {
            return true;
        }
        return StableUtils.mkdirs(file);
    }

    public boolean createFile(String string) throws Exception {
        File file = new File(StableUtils.pathJoin(new String[]{this.path, string}));
        return file.exists() || StableUtils.makesureFileExist(file);
    }

    public boolean fileExists(String string) {
        return new File(StableUtils.pathJoin(new String[]{this.path, string})).exists();
    }

    public boolean fileLocked(String string) throws Exception {
        return false;
    }

    public FileNode[] listFile(String string) {
        File file = new File(StableUtils.pathJoin(new String[]{this.path, string}));
        return this.listFile(file, string);
    }

    public FileNode[] listReportPathFile(String string) throws Exception {
        File file = new File(StableUtils.pathJoin(new String[]{FRContext.getCurrentEnv().getWebReportPath(), string}));
        return this.listFile(file, string);
    }

    private FileNode[] listFile(File file, String string) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        if (file.isFile()) {
            arrayList.add(new FileNode(string, file.isDirectory()));
        } else {
            int n2;
            File[] fileArray = file.listFiles();
            int n3 = n2 = fileArray == null ? 0 : fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file2 = fileArray[i2];
                arrayList.add(new FileNode(StableUtils.pathJoin(new String[]{string, file2.getName()}), file2.isDirectory()));
            }
        }
        return arrayList.toArray(new FileNode[arrayList.size()]);
    }

    public FileNode[] listCpt(String string) {
        return this.listCpt(string, false);
    }

    public FileNode[] listCpt(String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        try {
            this.listAll(string, arrayList, bl);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return arrayList.toArray(new FileNode[arrayList.size()]);
    }

    private void listAll(String string, List list, boolean bl) throws Exception {
        FileNode[] fileNodeArray = this.listFile(string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            if (fileNodeArray[i2].isFileType("cpt")) {
                list.add(fileNodeArray[i2]);
                continue;
            }
            if (!fileNodeArray[i2].isDirectory()) continue;
            if (bl) {
                this.listAll(string + File.separator + fileNodeArray[i2].getName(), list, true);
                continue;
            }
            list.add(fileNodeArray[i2]);
        }
    }

    public boolean testConnection(final Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    connection.testConnection();
                    return null;
                }
            });
            executorService.submit(futureTask);
            futureTask.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public String getUser() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableSchema(Connection connection) throws Exception {
        if (connection == null) {
            return null;
        }
        java.sql.Connection connection2 = connection.createConnection();
        if (connection2 == null) {
            throw new Exception("Cannot connect to database!");
        }
        Dialect dialect = DialectFactory.generateDialect(connection2);
        try {
            String[] stringArray = dialect.getSchemas(connection2);
            return stringArray;
        }
        finally {
            DBUtils.closeConnection(connection2);
        }
    }

    public TableProcedure[] getTableProcedure(Connection connection, String string, String string2) throws Exception {
        TableProcedure[] tableProcedureArray = null;
        ResultSet resultSet = null;
        String string3 = null;
        java.sql.Connection connection2 = connection.createConnection();
        if (connection2 == null) {
            throw new Exception("Cannot connect to database!");
        }
        if (string2 != null) {
            string3 = connection2.getCatalog();
        }
        Dialect dialect = DialectFactory.generateDialect(connection2);
        if (ComparatorUtils.equals(string, "TABLE")) {
            tableProcedureArray = dialect.getTableProcedure(connection2, string2, false);
        } else if (ComparatorUtils.equals(string, "VIEW")) {
            tableProcedureArray = this.getViewTableList(connection2, resultSet, string3, string2, dialect);
        } else if (ComparatorUtils.equals(string, "PROCEDURE")) {
            tableProcedureArray = dialect.getProcedureList(connection2, resultSet, string3, string2);
        } else if (ComparatorUtils.equals(string, "ALLTABLE")) {
            tableProcedureArray = dialect.getTableProcedure(connection2, string2, true);
        }
        if (connection2 != null) {
            connection2.close();
        }
        return tableProcedureArray;
    }

    private TableProcedure[] getViewTableList(java.sql.Connection connection, ResultSet resultSet, String string, String string2, Dialect dialect) {
        ArrayList<TableProcedure> arrayList = new ArrayList<TableProcedure>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"VIEW"};
            try {
                resultSet = databaseMetaData.getTables(string, string2, "%", stringArray);
            }
            catch (SQLException sQLException) {
                resultSet = databaseMetaData.getTables(string, string2, "%", stringArray);
            }
            while (resultSet.next()) {
                arrayList.add(new TableProcedure(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), dialect));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().errorWithServerLevel(sQLException.getMessage(), sQLException);
        }
        return arrayList.toArray(new TableProcedure[arrayList.size()]);
    }

    public List getProcedures(Connection connection, String[] stringArray, boolean bl, boolean bl2) throws Exception {
        HashMap<String, TableProcedure[]> hashMap = new HashMap<String, TableProcedure[]>();
        ArrayList<TableProcedure[]> arrayList = new ArrayList<TableProcedure[]>();
        java.sql.Connection connection2 = connection.createConnection();
        TableProcedure[] tableProcedureArray = null;
        String string = null;
        DatabaseMetaData databaseMetaData = connection2.getMetaData();
        int n2 = stringArray.length;
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray[i2];
                if (string2 != null) {
                    string = connection2.getCatalog();
                }
                if (bl && !bl2) {
                    Dialect dialect = DialectFactory.generateDialect(connection2);
                    tableProcedureArray = ((OracleDialect)dialect).getProcedureList(connection2, null, null, string2);
                } else {
                    tableProcedureArray = DataCoreUtils.getTableProcedureOfStoreProcedure(databaseMetaData, string, string2, bl);
                }
                if (tableProcedureArray == null) {
                    tableProcedureArray = new TableProcedure[]{};
                }
                hashMap.put(string2, tableProcedureArray);
                arrayList.add(tableProcedureArray);
            }
        } else {
            tableProcedureArray = DataCoreUtils.getTableProcedureOfStoreProcedure(databaseMetaData, string, null, bl);
            if (tableProcedureArray == null) {
                tableProcedureArray = new TableProcedure[]{};
            }
            hashMap.put(null, tableProcedureArray);
            arrayList.add(tableProcedureArray);
        }
        connection2.close();
        DataCoreUtils.putProcedureMap(connection, hashMap);
        return arrayList;
    }

    public ParameterProvider[] getTableDataParameters(TableData tableData) {
        ParameterProvider[] parameterProviderArray = null;
        if (tableData != null) {
            parameterProviderArray = tableData.getParameters(Calculator.createCalculator());
        }
        return parameterProviderArray == null ? new ParameterProvider[]{} : parameterProviderArray;
    }

    public Parameter[] getStoreProcedureParameters(StoreProcedure storeProcedure) throws Exception {
        return storeProcedure.get_IN_Parameters();
    }

    public EmbeddedTableData previewTableData(Object object, Map map, int n2) throws TableDataException {
        return this.previewTableData(object, map, n2, -1, new String[0], new int[0]);
    }

    public EmbeddedTableData previewTableData(Object object, Map map, int n2, int n3, String[] stringArray, int[] nArray) throws TableDataException {
        TableData tableData = null;
        EmbeddedTableData embeddedTableData = null;
        try {
            tableData = (TableData)((TableData)object).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            JOptionPane.showMessageDialog(null, cloneNotSupportedException.getMessage());
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        Calculator calculator = Calculator.createCalculator();
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(map);
        calculator.pushNameSpace(parameterMapNameSpace);
        try {
            int n4 = n2;
            if (n2 >= 0 && n3 >= n2 && tableData instanceof DBTableData) {
                try {
                    DBTableData dBTableData = (DBTableData)tableData;
                    java.sql.Connection connection = dBTableData.getDatabase().createConnection();
                    Dialect dialect = DialectFactory.generateDialect(connection);
                    dBTableData.setQuery(dialect.getRowRangeSql(dBTableData.getQuery(), n2, n3, stringArray));
                    n4 = -1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            embeddedTableData = EmbeddedTableData.embedify(tableData, calculator, n4);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().log(Level.WARNING, tableDataException.getMessage());
            throw new TableDataException(tableDataException.getMessage(), tableDataException);
        }
        finally {
            calculator.removeNameSpace(parameterMapNameSpace);
        }
        return embeddedTableData == null ? new EmbeddedTableData() : embeddedTableData;
    }

    public void openContainerFolder(FileNode fileNode) {
        if (fileNode == null) {
            return;
        }
        Utils.openWindowsFolder(StableUtils.pathJoin(new String[]{this.path, fileNode.getEnvPath()}));
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "DIR".equals(xMLableReader.getTagName())) {
            this.path = xMLableReader.getElementValue();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DIR").textNode(this.path).end();
    }

    private void writeTempFile(XMLFileManagerProvider xMLFileManagerProvider, String string) throws Exception {
        OutputStream outputStream = this.writeBean(string, "resources");
        XMLTools.writeOutputStreamXML(xMLFileManagerProvider, outputStream);
        outputStream.flush();
        outputStream.close();
    }

    private void renameTo(String string, String string2) throws Exception {
        File file = new File(StableUtils.pathJoin(new String[]{this.getPath(), "resources", string2}));
        File file2 = new File(StableUtils.pathJoin(new String[]{this.getPath(), "resources", string}));
        Utils.renameTo(file, file2);
    }

    public final boolean writeResource(XMLFileManagerProvider xMLFileManagerProvider) throws Exception {
        String string = xMLFileManagerProvider.fileName();
        String string2 = string + ".tmp";
        this.writeTempFile(xMLFileManagerProvider, string2);
        this.renameTo(string, string2);
        if (xMLFileManagerProvider instanceof ConfigManager && StringUtils.isNotEmpty(this.path)) {
            File file = new File(StableUtils.pathJoin(new String[]{this.path, "web.xml"}));
            WebXmlConfigManager webXmlConfigManager = new WebXmlConfigManager((ConfigManager)xMLFileManagerProvider, file);
            webXmlConfigManager.saveServletMapping();
        }
        return true;
    }

    public InputStream readResource(String string) throws Exception {
        return this.readBean(string, "resources");
    }

    public InputStream readBean(String string, String string2) throws Exception {
        File file = new File(StableUtils.pathJoin(new String[]{this.getPath(), string2, string}));
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    public OutputStream writeBean(String string, String string2) throws Exception {
        File file = new File(StableUtils.pathJoin(new String[]{this.getPath(), string2, string}));
        StableUtils.makesureFileExist(file);
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumns(String string, String string2, String string3) throws Exception {
        String[] stringArray;
        java.sql.Connection connection = null;
        try {
            connection = new NameDatabaseConnection(string).createConnection();
            stringArray = DBUtils.checkInColumnNames(connection, DataCoreUtils.createSelectSQL(string2, string3, DialectFactory.getDialectByName(string)));
        }
        catch (Throwable throwable) {
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
        return stringArray;
    }

    public String getWebReportPath() {
        return new File(this.getPath()).getParent();
    }

    public String getProcedureText(String string, String string2) throws Exception {
        Connection connection = DatasourceManager.getInstance().getConnection(string);
        java.sql.Connection connection2 = connection.createConnection();
        Dialect dialect = DialectFactory.generateDialect(connection2);
        String string3 = dialect.getStoreProcedureText(connection2, string2);
        connection2.close();
        return string3;
    }

    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(String string, String string2, String string3) throws Exception {
        Connection connection = DatasourceManager.getInstance().getConnection(string);
        java.sql.Connection connection2 = connection.createConnection();
        Dialect dialect = DialectFactory.generateDialect(connection2);
        StoreProcedureParameter[] storeProcedureParameterArray = dialect.getStoreProcedureDeclarationParameters(connection2, string2, string3);
        connection2.close();
        return storeProcedureParameterArray;
    }

    public ProcedureDataModel[] previewProcedureDataModel(StoreProcedure storeProcedure, Map map, int n2) {
        Calculator calculator = Calculator.createCalculator();
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(map);
        calculator.pushNameSpace(parameterMapNameSpace);
        return storeProcedure.creatDataModel(calculator);
    }

    public String getAppName() {
        String string = new File(this.getPath()).getParent();
        Object var2_2 = null;
        if (J2EEContainer.isJBoss7() && !this.isPackDeploy()) {
            return ConfigManager.getInstance().getJbossWebappName();
        }
        return new File(string).getName().replaceAll(".war", "");
    }

    public boolean isOracle(Connection connection) throws Exception {
        java.sql.Connection connection2 = connection.createConnection();
        boolean bl = DialectFactory.generateDialect(connection2) instanceof OracleDialect;
        DBUtils.closeConnection(connection2);
        return bl;
    }

    public String[] getSupportedTypes() {
        return FILE_TYPE;
    }

    public boolean isSupportLocalFileOperate() {
        return true;
    }

    public boolean hasFileFolderAllowcation(String string) {
        return true;
    }

    public boolean isRoot() {
        return true;
    }

    public boolean deleteFile(String string) {
        return StableUtils.deleteFile(new File(StableUtils.pathJoin(new String[]{this.path, string})));
    }

    public boolean testServerConnectionWithOutShowMessagePane() throws Exception {
        return true;
    }

    public boolean isPackDeploy() {
        return false;
    }

    public String getDesignerVersion() {
        return "HBA";
    }

    public InputStream getDataSourceInputStream(String string) throws Exception {
        return new FileInputStream(StableUtils.pathJoin(new String[]{this.getPath(), string}));
    }

    public void printLogMessage() throws Exception {
    }

    public String getUserID() {
        return "";
    }

    public void removeNoPrivilegeConnection() {
    }

    public ArrayList getAllRole4Privilege(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ModuleContext.startModule("com.fr.fs.FSModule");
        FServicePrivilegeProvider fServicePrivilegeProvider = (FServicePrivilegeProvider)StableFactory.createNewObject("FServicePrivilege");
        try {
            String[] stringArray = fServicePrivilegeProvider.getAllCompanyRole4Desinger();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(stringArray[i2]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return arrayList;
    }
}

