/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.pool;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.pool.DBCPConnectionPoolAttr;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.third.org.apache.commons.dbcp.BasicDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class MemoryConnection {
    private static final Map M_POOLTABLE = new Hashtable();

    public static Connection create(String string, String string2, String string3, String string4, DBCPConnectionPoolAttr dBCPConnectionPoolAttr) throws SQLException {
        return MemoryConnection.getDataSource(string, string2, string3, string4, dBCPConnectionPoolAttr).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSource getDataSource(String string, String string2, String string3, String string4, DBCPConnectionPoolAttr dBCPConnectionPoolAttr) {
        String string5 = string + string2 + "&" + string3 + string4 + (dBCPConnectionPoolAttr == null ? null : dBCPConnectionPoolAttr.toValueListString());
        DataSource dataSource = (DataSource)M_POOLTABLE.get(string5);
        if (dataSource == null) {
            Map map = M_POOLTABLE;
            synchronized (map) {
                dataSource = new BasicDataSource();
                BasicDataSource basicDataSource = (BasicDataSource)dataSource;
                basicDataSource.setDriverClassName(string);
                basicDataSource.setUrl(string2);
                basicDataSource.setUsername(string3);
                basicDataSource.setPassword(string4);
                if (dBCPConnectionPoolAttr == null) {
                    dBCPConnectionPoolAttr = new DBCPConnectionPoolAttr();
                }
                basicDataSource.setInitialSize(dBCPConnectionPoolAttr.getInitialSize());
                basicDataSource.setMaxActive(dBCPConnectionPoolAttr.getMaxActive());
                basicDataSource.setMaxIdle(dBCPConnectionPoolAttr.getMaxIdle());
                basicDataSource.setMinIdle(dBCPConnectionPoolAttr.getMinIdle());
                basicDataSource.setMaxWait((long)dBCPConnectionPoolAttr.getMaxWait());
                basicDataSource.setTestOnBorrow(dBCPConnectionPoolAttr.isTestOnBorrow());
                basicDataSource.setTestOnReturn(dBCPConnectionPoolAttr.isTestOnReturn());
                basicDataSource.setTestWhileIdle(dBCPConnectionPoolAttr.isTestWhileIdle());
                basicDataSource.setMinEvictableIdleTimeMillis((long)dBCPConnectionPoolAttr.getMinEvictableIdleTimeMillis());
                basicDataSource.setTimeBetweenEvictionRunsMillis((long)dBCPConnectionPoolAttr.getTimeBetweenEvictionRunsMillis());
                basicDataSource.setNumTestsPerEvictionRun(dBCPConnectionPoolAttr.getNumTestsPerEvictionRun());
                if (MemoryConnection.isdbcpNeedValQuery(dBCPConnectionPoolAttr)) {
                    String string6 = dBCPConnectionPoolAttr.getValidationQuery();
                    if (StringUtils.isBlank(string6)) {
                        string6 = MemoryConnection.getDefaultValidationQuery(string, string2, string3, string4);
                    }
                    if (StringUtils.isNotBlank(string6)) {
                        basicDataSource.setValidationQuery(string6);
                    }
                }
                M_POOLTABLE.put(string5, dataSource);
            }
        }
        return dataSource;
    }

    private static boolean isdbcpNeedValQuery(DBCPConnectionPoolAttr dBCPConnectionPoolAttr) {
        return dBCPConnectionPoolAttr.isTestOnBorrow() || dBCPConnectionPoolAttr.isTestOnReturn() || dBCPConnectionPoolAttr.isTestWhileIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultValidationQuery(String string, String string2, String string3, String string4) {
        String string5 = "";
        Dialect dialect = DialectFactory.try2GenerateDialectByDriver(string);
        if (dialect != null) {
            try {
                string5 = dialect.defaultValidationQuery(null);
            }
            catch (Exception exception) {
                string5 = "";
            }
        }
        if (StringUtils.isEmpty(string5)) {
            Connection connection = null;
            try {
                Class.forName(string);
                connection = DriverManager.getConnection(string2, string3, string4);
                dialect = DialectFactory.generateDialect(connection);
                string5 = dialect.defaultValidationQuery(connection);
            }
            catch (SQLException sQLException) {
                string5 = "";
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRLogger.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    }
                }
            }
        }
        return string5;
    }

    private MemoryConnection() {
    }

    public static JSONArray getJSONConnectionInfo() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n2 = M_POOLTABLE.size();
        String[] stringArray = new String[n2];
        Set set = M_POOLTABLE.keySet();
        int n3 = 0;
        for (String string : set) {
            BasicDataSource basicDataSource = (BasicDataSource)M_POOLTABLE.get(string);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(Inter.getLocText("Data_Connection_Driver_Name"), basicDataSource.getDriverClassName());
            jSONObject.put(Inter.getLocText("DBCP_MAX_ACTIVE"), basicDataSource.getMaxActive());
            jSONObject.put(Inter.getLocText("DBCP_MAX_IDLE"), basicDataSource.getMaxIdle());
            jSONObject.put(Inter.getLocText("Active_Connection_Size"), basicDataSource.getNumActive());
            jSONObject.put(Inter.getLocText("Idle_Connection_Size"), basicDataSource.getNumIdle());
            jSONArray.put(jSONObject);
            ++n3;
        }
        return jSONArray;
    }

    public static String[] getConnectionInfo() {
        return new String[0];
    }

    public static Map getConnectionMap() {
        return M_POOLTABLE;
    }
}

