/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.pool;

import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class DBCPConnectionPoolAttr
implements XMLReadable,
Cloneable,
Serializable {
    private static final int MAX_ACTIVE = 50;
    private static final int MAX_IDLE = 10;
    private static final int MAX_WAIT = 10000;
    private static final int MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000;
    private int initialSize = 0;
    private int maxActive = 50;
    private int maxIdle = 10;
    private int minIdle = 0;
    private int maxWait = 10000;
    private String validationQuery = "";
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    private int timeBetweenEvictionRunsMillis = -1;
    private int numTestsPerEvictionRun = 3;
    private int minEvictableIdleTimeMillis = 1800000;

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int n2) {
        this.initialSize = n2;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n2) {
        this.maxActive = n2;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n2) {
        this.maxIdle = n2;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int n2) {
        this.minIdle = n2;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int n2) {
        this.maxWait = n2;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int n2) {
        this.timeBetweenEvictionRunsMillis = n2;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n2) {
        this.numTestsPerEvictionRun = n2;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int n2) {
        this.minEvictableIdleTimeMillis = n2;
    }

    public String toValueListString() {
        return this.initialSize + "," + this.maxActive + "," + this.maxIdle + "," + this.maxWait + "," + this.minIdle + "," + this.validationQuery + "," + this.testOnBorrow + "," + this.testOnReturn + "," + this.testWhileIdle + "," + this.minEvictableIdleTimeMillis + "," + this.numTestsPerEvictionRun + "," + this.timeBetweenEvictionRunsMillis;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "DBCPAttr".equals(xMLableReader.getTagName())) {
            this.setInitialSize(xMLableReader.getAttrAsInt("initialSize", 0));
            this.setMaxActive(xMLableReader.getAttrAsInt("maxActive", 50));
            this.setMaxIdle(xMLableReader.getAttrAsInt("maxIdle", 10));
            this.setMinIdle(xMLableReader.getAttrAsInt("minIdle", 0));
            this.setMaxWait(xMLableReader.getAttrAsInt("maxWait", 10000));
            this.setValidationQuery(xMLableReader.getAttrAsString("validationQuery", ""));
            this.setTestOnBorrow(xMLableReader.getAttrAsBoolean("testOnBorrow", true));
            this.setTestOnReturn(xMLableReader.getAttrAsBoolean("testOnReturn", false));
            this.setTestWhileIdle(xMLableReader.getAttrAsBoolean("testWhileIdle", false));
            this.setTimeBetweenEvictionRunsMillis(xMLableReader.getAttrAsInt("timeBetweenEvictionRunsMillis", -1));
            this.setNumTestsPerEvictionRun(xMLableReader.getAttrAsInt("numTestsPerEvictionRun", 3));
            this.setMinEvictableIdleTimeMillis(xMLableReader.getAttrAsInt("minEvictableIdleTimeMillis", 1800000));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DBCPAttr");
        if (this.getInitialSize() != 0) {
            xMLPrintWriter.attr("initialSize", this.getInitialSize());
        }
        if (this.getMaxActive() != 50) {
            xMLPrintWriter.attr("maxActive", this.getMaxActive());
        }
        if (this.getMaxIdle() != 10) {
            xMLPrintWriter.attr("maxIdle", this.getMaxIdle());
        }
        if (this.getMinIdle() != 0) {
            xMLPrintWriter.attr("minIdle", this.getMinIdle());
        }
        if (this.getMaxWait() != 10000) {
            xMLPrintWriter.attr("maxWait", this.getMaxWait());
        }
        if (StringUtils.isNotBlank(this.getValidationQuery())) {
            xMLPrintWriter.attr("validationQuery", this.getValidationQuery());
        }
        if (!this.isTestOnBorrow()) {
            xMLPrintWriter.attr("testOnBorrow", this.isTestOnBorrow());
        }
        if (this.isTestOnReturn()) {
            xMLPrintWriter.attr("testOnReturn", this.isTestOnReturn());
        }
        if (this.isTestWhileIdle()) {
            xMLPrintWriter.attr("testWhileIdle", this.isTestWhileIdle());
        }
        if (this.getTimeBetweenEvictionRunsMillis() != -1) {
            xMLPrintWriter.attr("timeBetweenEvictionRunsMillis", this.getTimeBetweenEvictionRunsMillis());
        }
        if (this.getNumTestsPerEvictionRun() != 3) {
            xMLPrintWriter.attr("numTestsPerEvictionRun", this.getNumTestsPerEvictionRun());
        }
        if (this.getMinEvictableIdleTimeMillis() != 1800000) {
            xMLPrintWriter.attr("minEvictableIdleTimeMillis", this.getMinEvictableIdleTimeMillis());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DBCPConnectionPoolAttr)) {
            return false;
        }
        DBCPConnectionPoolAttr dBCPConnectionPoolAttr = (DBCPConnectionPoolAttr)object;
        return ComparatorUtils.equals(this.initialSize, dBCPConnectionPoolAttr.initialSize) && ComparatorUtils.equals(this.maxActive, dBCPConnectionPoolAttr.maxActive) && ComparatorUtils.equals(this.maxIdle, dBCPConnectionPoolAttr.maxIdle) && ComparatorUtils.equals(this.maxWait, dBCPConnectionPoolAttr.maxWait) && ComparatorUtils.equals(this.minEvictableIdleTimeMillis, dBCPConnectionPoolAttr.minEvictableIdleTimeMillis) && ComparatorUtils.equals(this.minIdle, dBCPConnectionPoolAttr.minIdle) && ComparatorUtils.equals(this.numTestsPerEvictionRun, dBCPConnectionPoolAttr.numTestsPerEvictionRun) && ComparatorUtils.equals(this.testOnBorrow, dBCPConnectionPoolAttr.testOnBorrow) && ComparatorUtils.equals(this.testOnReturn, dBCPConnectionPoolAttr.testOnReturn) && ComparatorUtils.equals(this.testWhileIdle, dBCPConnectionPoolAttr.testWhileIdle) && ComparatorUtils.equals(this.timeBetweenEvictionRunsMillis, dBCPConnectionPoolAttr.timeBetweenEvictionRunsMillis) && ComparatorUtils.equals(this.validationQuery, dBCPConnectionPoolAttr.validationQuery);
    }
}

