/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.index;

import com.fr.data.index.AbstractWrappedDataModel;
import com.fr.data.index.IntelligentIndex;
import com.fr.general.data.DataModel;
import com.fr.general.data.index.Index;
import com.fr.general.data.index.IndexDataModel;
import com.fr.general.data.index.IndexException;
import java.util.ArrayList;

public class DefaultIndexDataModel
extends AbstractWrappedDataModel
implements IndexDataModel {
    private ArrayList<Index> indexes = new ArrayList();

    public DefaultIndexDataModel(DataModel dataModel) {
        super(dataModel);
    }

    public void setIndex(int n2, Index index) {
        this.ensureCapacity(n2 + 1);
        this.indexes.set(n2, index);
    }

    private void ensureCapacity(int n2) {
        while (this.indexes.size() < n2) {
            this.indexes.add(null);
        }
    }

    protected Index getIndex(int n2) {
        if (n2 < 0 || n2 >= this.indexes.size()) {
            return null;
        }
        return this.indexes.get(n2);
    }

    public int getRowByKey(Object object, int n2) throws IndexException {
        Index index = this.findIndex(n2);
        return index.getRow(object);
    }

    public int[] getAllRowByKey(Object object, int n2) throws IndexException {
        Index index = this.findIndex(n2);
        return index.getAllRow(object);
    }

    private Index findIndex(int n2) {
        Index index = this.getIndex(n2);
        if (index == null) {
            index = new IntelligentIndex(this.dataModel, n2);
            this.setIndex(n2, index);
        }
        return index;
    }
}

