/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.storeproc;

import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.StoreProcedureParameter;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.Oracle10gDialect;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.Connection;
import com.fr.data.impl.storeproc.DiskCacheProcereDataModel;
import com.fr.data.impl.storeproc.MemCachedProcedureDataModel;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.VT4FR;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class StoreProcedure
extends AbstractParameterTableData
implements XMLable {
    private static final int PARAMETER_PROPERTY_COUNT = 4;
    public static final String XML_TAG = "StoreProcedure";
    public static final String SPLIT = "_";
    private static boolean shareAvailable = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.PERFORMCE_OPTIMISE.support();
    private List dataModelList = new ArrayList();
    private boolean share = false;
    private int maxMemRowCount = -1;
    private String query;
    private StoreProcedureParameter[] parameters = new StoreProcedureParameter[0];
    private ArrayList resultNames = new ArrayList();
    private transient java.sql.Connection connection;
    private transient CallableStatement statement;
    private Connection database;
    private boolean isCalculating;
    private boolean isFirstExpand = true;
    private static final long serialVersionUID = 1L;

    public static StoreProcedureParameter[] getSortPara(StoreProcedureParameter[] storeProcedureParameterArray) {
        int n2;
        int n3 = storeProcedureParameterArray.length;
        StoreProcedureParameter[] storeProcedureParameterArray2 = new StoreProcedureParameter[n3];
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = storeProcedureParameterArray[n2].getName();
        }
        Arrays.sort(stringArray, Collator.getInstance(Locale.CHINA));
        block1: for (n2 = 0; n2 < n3; ++n2) {
            String string = stringArray[n2];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!ComparatorUtils.equals(string, storeProcedureParameterArray[i2].getName())) continue;
                storeProcedureParameterArray2[n2] = storeProcedureParameterArray[i2];
                continue block1;
            }
        }
        return storeProcedureParameterArray2;
    }

    public void setCalculating(boolean bl) {
        this.isCalculating = bl;
    }

    public boolean isCalculating() {
        return this.isCalculating;
    }

    public String[] getStoreProcedureColumnNames(Calculator calculator, String string) {
        ProcedureDataModel procedureDataModel = this.getProcedureDataModel(calculator, string);
        if (procedureDataModel != null) {
            return procedureDataModel.getColumnName();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public ArrayList getResultNames() {
        return this.resultNames;
    }

    public ProcedureDataModel getProcedureDataModel(Calculator calculator, String string) {
        string = string.substring(string.indexOf(SPLIT) + 1);
        ProcedureDataModel[] procedureDataModelArray = this.creatDataModel(calculator);
        int n2 = procedureDataModelArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(string, procedureDataModelArray[i2].getName())) continue;
            return procedureDataModelArray[i2];
        }
        return procedureDataModelArray[0];
    }

    public int getDataModelSize() {
        return this.dataModelList.size();
    }

    public void resetDataModelList() {
        this.dataModelList.clear();
    }

    public ProcedureDataModel[] creatLazyDataModel() {
        return this.dataModelList.toArray(new ProcedureDataModel[this.dataModelList.size()]);
    }

    public ProcedureDataModel[] creatDataModel(Calculator calculator) {
        return this.creatCacheableDataModel(calculator);
    }

    public ProcedureDataModel[] creatCacheableDataModel(CalculatorProvider calculatorProvider) {
        try {
            this.prepareCall(calculatorProvider);
            return this.creatDataModels();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        this.release();
        return new ProcedureDataModel[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCall(CalculatorProvider calculatorProvider) throws SQLException, TableDataException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            try {
                this.connection = this.database.createConnection();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                return;
            }
            if (this.query == null) {
                return;
            }
            Dialect dialect = DialectFactory.generateDialect(this.connection);
            Parameter[] parameterArray = Parameter.providers2Parameter(Calculator.processParameters(calculatorProvider, this.parameters));
            String string = this.getNewQuery(dialect, parameterArray);
            this.statement = this.connection.prepareCall(string);
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                StoreProcedureParameter storeProcedureParameter = this.parameters[i2];
                SQLTypeHandler sQLTypeHandler = dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(storeProcedureParameter.getType()));
                if (storeProcedureParameter.getSchema() != 0x7FFFFFFD) {
                    try {
                        sQLTypeHandler.setValue(this.statement, i2 + 1, this.calculateHandlerValue(parameterArray[i2].getValue(), calculatorProvider), storeProcedureParameter.getType());
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                }
                if (storeProcedureParameter.getSchema() == 0x7FFFFFFE) continue;
                this.statement.registerOutParameter(i2 + 1, storeProcedureParameter.getType());
            }
            this.statement.executeQuery();
            FRLogger.getLogger().info("SQL:\n" + string);
            this.dataModelList.clear();
        }
    }

    private Object calculateHandlerValue(Object object, CalculatorProvider calculatorProvider) throws UtilEvalError {
        if (object instanceof FormulaProvider) {
            return ComparatorUtils.equals(calculatorProvider.eval((FormulaProvider)object), Primitive.NULL) ? null : calculatorProvider.eval((FormulaProvider)object);
        }
        if (object instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(object);
        }
        return object;
    }

    private String getNewQuery(Dialect dialect, Parameter[] parameterArray) {
        return ParameterHelper.analyzeCurrentContextTableData4Templatee(this.getCallQuery(dialect, parameterArray.length), parameterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcedureDataModel[] creatDataModels() throws TableDataException, SQLException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            int n2;
            if (this.statement == null) {
                return null;
            }
            boolean bl = DialectFactory.generateDialect(this.connection) instanceof Oracle10gDialect;
            ResultSet resultSet = this.statement.getResultSet();
            if (resultSet != null) {
                this.dataModelList.add(this.createDataModeByResultSet(resultSet, bl, "Table"));
                n2 = 0;
                while (this.statement.getMoreResults()) {
                    resultSet = this.statement.getResultSet();
                    this.dataModelList.add(this.createDataModeByResultSet(resultSet, bl, "Table" + ++n2));
                }
            }
            for (n2 = 0; n2 < this.parameters.length; ++n2) {
                StoreProcedureParameter storeProcedureParameter = this.parameters[n2];
                if (storeProcedureParameter.getSchema() == 0x7FFFFFFE) continue;
                Object object = this.statement.getObject(n2 + 1);
                if (object instanceof ResultSet) {
                    resultSet = (ResultSet)object;
                    this.dataModelList.add(this.createDataModeByResultSet(resultSet, bl, storeProcedureParameter.getName()));
                    continue;
                }
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
                arrayList.add(new Object[]{object});
                this.dataModelList.add(new MemCachedProcedureDataModel(arrayList, new String[]{storeProcedureParameter.getName()}, storeProcedureParameter.getName()));
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeConnection(this.connection);
            DBUtils.closeStatement(this.statement);
            return this.dataModelList.toArray(new ProcedureDataModel[this.dataModelList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcedureDataModel createDataModeByResultSet(ResultSet resultSet, boolean bl, String string) throws SQLException, TableDataException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            if (!this.resultNames.contains(string) && !bl) {
                this.resultNames.add(string);
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            List list = this.createRowList(resultSet, resultSetMetaData, bl);
            if (this.maxMemRowCount > 0 && list.size() > this.maxMemRowCount) {
                return new DiskCacheProcereDataModel(list, this.creatColumnName(resultSetMetaData), string);
            }
            return new MemCachedProcedureDataModel(list, this.creatColumnName(resultSetMetaData), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List createRowList(ResultSet resultSet, ResultSetMetaData resultSetMetaData, boolean bl) throws TableDataException, SQLException {
        StoreProcedure storeProcedure = this;
        synchronized (storeProcedure) {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            int n2 = resultSetMetaData.getColumnCount();
            try {
                int[] nArray = new int[n2];
                if (resultSetMetaData != null) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        nArray[i2] = resultSetMetaData.getColumnType(i2 + 1);
                    }
                }
                while (resultSet.next()) {
                    Object[] objectArray = new Object[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        try {
                            if (bl) {
                                if (nArray[i3] == 91) {
                                    objectArray[i3] = resultSet.getTimestamp(i3 + 1);
                                    continue;
                                }
                                objectArray[i3] = resultSet.getObject(i3 + 1);
                                continue;
                            }
                            objectArray[i3] = resultSet.getObject(i3 + 1);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            objectArray[i3] = null;
                        }
                    }
                    arrayList.add(objectArray);
                }
            }
            catch (Exception exception) {
                try {
                    this.release();
                }
                catch (Exception exception2) {
                    FRLogger.getLogger().error("Error happens while releaseConnection");
                }
                if (exception.getCause() != null) {
                    FRLogger.getLogger().error("Caused By:" + exception.getCause().getMessage(), exception.getCause());
                }
                throw new TableDataException(exception.getMessage(), exception);
            }
            return arrayList;
        }
    }

    public boolean isFirstExpand() {
        return this.isFirstExpand;
    }

    public void setFirstExpand(boolean bl) {
        this.isFirstExpand = bl;
    }

    private String[] creatColumnName(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = resultSetMetaData.getColumnName(i2 + 1);
            stringArray[i2] = ComparatorUtils.equals(string, "") ? "Column" + (i2 == 0 ? "" : String.valueOf(i2)) : string;
        }
        return stringArray;
    }

    public void release() {
        DBUtils.closeStatement(this.statement);
        DBUtils.closeConnection(this.connection);
    }

    public Connection getDatabaseConnection() {
        return this.database;
    }

    public void setDatabaseConnection(Connection connection) {
        this.database = connection;
    }

    private String getCallQuery(Dialect dialect, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{call ");
        String[] stringArray = this.query.split("\\.");
        Table table = stringArray.length > 1 ? new Table(stringArray[stringArray.length - 2], stringArray[stringArray.length - 1]) : new Table(stringArray[0]);
        stringBuffer.append(dialect.table2SQL(table) + "(");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('?');
            if (i2 == n2 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public StoreProcedureParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(StoreProcedureParameter[] storeProcedureParameterArray) {
        this.parameters = storeProcedureParameterArray;
    }

    public StoreProcedureParameter[] get_IN_Parameters() {
        Object[] objectArray = new StoreProcedureParameter[]{};
        int n2 = this.parameters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parameters[i2].getSchema() == 0x7FFFFFFD) continue;
            objectArray = (StoreProcedureParameter[])ArrayUtils.add(objectArray, this.parameters[i2]);
        }
        return objectArray;
    }

    private String getParameterListString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            String string = this.parameters[i2].toString();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void setParameterList(String string) {
        String[] stringArray = string.split("\\]\\[");
        stringArray[0] = stringArray[0].substring(1);
        String string2 = stringArray[stringArray.length - 1];
        stringArray[stringArray.length - 1] = string2 = string2.substring(0, string2.length() - 1);
        StoreProcedureParameter[] storeProcedureParameterArray = new StoreProcedureParameter[stringArray.length / 4];
        for (int i2 = 0; i2 < stringArray.length; i2 += 4) {
            StoreProcedureParameter storeProcedureParameter = new StoreProcedureParameter();
            String string3 = stringArray[i2];
            String string4 = stringArray[i2 + 1];
            String string5 = stringArray[i2 + 2];
            String string6 = stringArray[i2 + 3];
            storeProcedureParameter.setName(string3.substring(string3.indexOf(58) + 1));
            storeProcedureParameter.setSchema(Integer.parseInt(string5.substring(string5.indexOf(58) + 1)));
            storeProcedureParameter.setType(Integer.parseInt(string4.substring(string4.indexOf(58) + 1)));
            storeProcedureParameter.setValue(string6.substring(string6.indexOf(58) + 1));
            storeProcedureParameterArray[i2 / 4] = storeProcedureParameter;
        }
        this.setParameters(storeProcedureParameterArray);
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean isShareTableData() {
        return shareAvailable && this.share;
    }

    public int getMaxMemRowCount() {
        return this.maxMemRowCount;
    }

    public void setMaxMemRowCount(int n2) {
        this.maxMemRowCount = n2;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                this.setShare(xMLableReader.getAttrAsBoolean("share", false));
                this.setMaxMemRowCount(xMLableReader.getAttrAsInt("maxMemRowCount", -1));
            }
            if ("Connection".equals(string)) {
                if (xMLableReader.getAttrAsString("class", null) != null) {
                    Connection connection = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                    this.setDatabaseConnection(connection);
                }
            } else if ("Query".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setQuery(string2);
                }
            } else if ("ParamterList".equals(string)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setParameterList(string3);
                }
            } else if ("ResultNames".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        String string2;
                        if (xMLableReader.isAttr()) {
                            StoreProcedure.this.resultNames.clear();
                        }
                        if (xMLableReader.isChildNode() && "Name".equals(string2 = xMLableReader.getTagName()) && (string = xMLableReader.getElementValue()) != null) {
                            StoreProcedure.this.resultNames.add(string);
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes");
        if (this.share) {
            xMLPrintWriter.attr("share", this.share);
        }
        xMLPrintWriter.attr("maxMemRowCount", this.getMaxMemRowCount()).end();
        if (this.database != null) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
        xMLPrintWriter.startTAG("Query").textNode(this.getQuery()).end();
        xMLPrintWriter.startTAG("ParamterList").textNode(this.getParameterListString()).end();
        xMLPrintWriter.startTAG("ResultNames");
        int n2 = Math.min(12, this.resultNames.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("Name").textNode((String)this.resultNames.get(i2)).end();
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        return XML_TAG;
    }

    public DataModel createDataModel(Calculator calculator) {
        return DataModel.EMPTY_DATAMODEL;
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.getProcedureDataModel(calculator, string);
    }

    public Object clone() throws CloneNotSupportedException {
        int n2;
        StoreProcedure storeProcedure = (StoreProcedure)super.clone();
        storeProcedure.setDatabaseConnection(this.getDatabaseConnection());
        storeProcedure.setParameters(this.getParameters());
        storeProcedure.setQuery(this.getQuery());
        storeProcedure.setMaxMemRowCount(this.getMaxMemRowCount());
        storeProcedure.dataModelList = new ArrayList();
        for (n2 = 0; n2 < this.dataModelList.size(); ++n2) {
            storeProcedure.dataModelList.add(this.dataModelList.get(n2));
        }
        storeProcedure.resultNames = new ArrayList();
        for (n2 = 0; n2 < this.resultNames.size(); ++n2) {
            storeProcedure.resultNames.add(this.resultNames.get(n2));
        }
        return storeProcedure;
    }

    public boolean equals(Object object) {
        return object instanceof StoreProcedure && ComparatorUtils.equals(this.database, ((StoreProcedure)object).getDatabaseConnection()) && ComparatorUtils.equals(this.query, ((StoreProcedure)object).getQuery()) && ComparatorUtils.equals(this.parameters, ((StoreProcedure)object).getParameters());
    }
}

