/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.impl.sap.SAPDatabaseConnection;
import com.fr.data.impl.sap.SAPFunction;
import com.fr.data.impl.sap.SAPInput;
import com.fr.data.impl.sap.SAPOutput;
import com.fr.file.DatasourceManager;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordField;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultParameterList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAPUtilsJDK5 {
    private static final Map TYPEMAP = new HashMap(){
        {
            this.put("CHAR", "String");
            this.put("BYTE", "byte[]");
            this.put("INT", "Integer");
            this.put("INT1", "Integer");
            this.put("INT2", "Integer");
            this.put("FLOAT", "Double");
            this.put("BCD", "BigDecimal");
            this.put("DATE", "Date");
            this.put("NUM", "String");
            this.put("STRING", "String");
            this.put("XSTRING", "byte[]");
            this.put("DECF16", "Double");
            this.put("DECF34", "Double");
            this.put("TIME", "Date");
        }
    };

    public static JCoDestination getConnection(String string) throws Exception {
        SAPDatabaseConnection sAPDatabaseConnection = (SAPDatabaseConnection)DatasourceManager.getInstance().getConnection(string);
        return (JCoDestination)sAPDatabaseConnection.getConnection();
    }

    public static JCoRepository getRepository(JCoDestination jCoDestination) throws Exception {
        return jCoDestination.getRepository();
    }

    public static JCoFunctionTemplate getFunctionTemplate(JCoRepository jCoRepository, String string) throws Exception {
        return jCoRepository.getFunctionTemplate(string);
    }

    public static JCoFunction getFunction(JCoFunctionTemplate jCoFunctionTemplate) throws Exception {
        return jCoFunctionTemplate.getFunction();
    }

    public static JCoParameterList getImportParameterList(JCoFunction jCoFunction) throws Exception {
        return jCoFunction.getImportParameterList();
    }

    public static JCoParameterList getTableParameterList(JCoFunction jCoFunction) throws Exception {
        return jCoFunction.getTableParameterList();
    }

    public static void executeFunction(JCoFunction jCoFunction, JCoDestination jCoDestination) throws Exception {
        try {
            jCoFunction.execute(jCoDestination);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void quitConnection(JCoRepository jCoRepository) throws Exception {
        jCoRepository.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAPInput[] getBapiInput4DifferentJDK(String string, String string2) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        try {
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, string2);
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            DefaultParameterList defaultParameterList = (DefaultParameterList)SAPUtilsJDK5.getImportParameterList(jCoFunction);
            if (defaultParameterList != null) {
                int n2 = defaultParameterList.getFieldCount();
                ArrayList<SAPInput> arrayList = new ArrayList<SAPInput>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    SAPInput sAPInput = new SAPInput();
                    sAPInput.setNo(Integer.toString(i2 + 1));
                    AbstractMetaData abstractMetaData = defaultParameterList.getMetaData();
                    String string3 = abstractMetaData.getName(i2);
                    String string4 = abstractMetaData.getTypeAsString(i2);
                    sAPInput.setParaName(string3);
                    sAPInput.setType(string4);
                    sAPInput.setReturnName("");
                    String string5 = (String)TYPEMAP.get(string4);
                    sAPInput.setDataType(string5 == null ? "INVALID" : string5);
                    sAPInput.setCorresPara("saparam" + i2);
                    arrayList.add(sAPInput);
                }
                SAPInput[] sAPInputArray = arrayList.toArray(new SAPInput[arrayList.size()]);
                return sAPInputArray;
            }
            SAPInput[] sAPInputArray = new SAPInput[]{};
            return sAPInputArray;
        }
        finally {
            SAPUtilsJDK5.quitConnection(jCoRepository);
        }
    }

    public static SAPInput[] getBapiInput(String string, String string2) {
        try {
            return SAPUtilsJDK5.getBapiInput4DifferentJDK(string, string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    public static SAPFunction[] searchFunction(String string, String string2) {
        try {
            return SAPUtilsJDK5.searchFunction4DifferentJDK(string, string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAPFunction[] searchFunction4DifferentJDK(String string, String string2) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string2);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        try {
            SAPFunction[] sAPFunctionArray;
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, "RFC_FUNCTION_SEARCH");
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            String string3 = "*" + string.toUpperCase().trim() + "*";
            JCoParameterList jCoParameterList = SAPUtilsJDK5.getImportParameterList(jCoFunction);
            JCoParameterList jCoParameterList2 = SAPUtilsJDK5.getTableParameterList(jCoFunction);
            jCoParameterList.setValue("FUNCNAME", string3);
            JCoTable jCoTable = jCoParameterList2.getTable("FUNCTIONS");
            SAPUtilsJDK5.executeFunction(jCoFunction, jCoDestination);
            int n2 = 0;
            if (jCoTable != null) {
                n2 = jCoTable.getNumRows();
            }
            SAPFunction[] sAPFunctionArray2 = sAPFunctionArray = SAPUtilsJDK5.getFunctionsValue(n2, jCoTable);
            return sAPFunctionArray2;
        }
        finally {
            SAPUtilsJDK5.quitConnection(jCoRepository);
        }
    }

    private static SAPFunction[] getFunctionsValue(int n2, JCoTable jCoTable) {
        SAPFunction[] sAPFunctionArray = new SAPFunction[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            jCoTable.setRow(i2);
            sAPFunctionArray[i2] = new SAPFunction();
            sAPFunctionArray[i2].setNO(String.valueOf(i2 + 1));
            sAPFunctionArray[i2].setName(jCoTable.getValue("FUNCNAME").toString());
            sAPFunctionArray[i2].setGroup(jCoTable.getValue("GROUPNAME").toString());
            sAPFunctionArray[i2].setApplication(jCoTable.getValue("APPL").toString());
            sAPFunctionArray[i2].setDescription(jCoTable.getValue("STEXT").toString());
        }
        return sAPFunctionArray;
    }

    private static String[] getBapiTablesName4DifferentJDK(String string, String string2) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, string2);
        JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
        JCoParameterList jCoParameterList = SAPUtilsJDK5.getTableParameterList(jCoFunction);
        if (jCoParameterList != null) {
            int n2 = jCoParameterList.getFieldCount();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3;
                JCoMetaData jCoMetaData = jCoParameterList.getMetaData();
                stringArray[i2] = string3 = jCoMetaData.getName(i2);
            }
            return stringArray;
        }
        return new String[0];
    }

    public static SAPOutput[] getBapiOutput(String string, String string2, String string3) {
        try {
            if (string3 != null) {
                ArrayList arrayList = new ArrayList();
                SAPUtilsJDK5.getBapiOutput4DifferentJDK(string, string2, string3, arrayList);
                return arrayList.toArray(new SAPOutput[0]);
            }
            return null;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBapiOutput4DifferentJDK(String string, String string2, String string3, List list) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        try {
            String string4;
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, string2);
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            JCoParameterList jCoParameterList = SAPUtilsJDK5.getTableParameterList(jCoFunction);
            JCoTable jCoTable = jCoParameterList.getTable(string3);
            int n2 = jCoTable.getFieldCount();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                JCoMetaData jCoMetaData = jCoTable.getMetaData();
                stringArray[i2] = string4 = jCoMetaData.getName(i2);
                stringArray2[i2] = jCoMetaData.getTypeAsString(i2);
            }
            if (list != null) {
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    SAPOutput sAPOutput = new SAPOutput();
                    sAPOutput.setNo(Integer.toString(i3 + 1));
                    sAPOutput.setColName(stringArray[i3]);
                    sAPOutput.setType(stringArray2[i3]);
                    string4 = (String)TYPEMAP.get(stringArray2[i3]);
                    sAPOutput.setDataType(string4 == null ? "INVALID" : string4);
                    list.add(sAPOutput);
                }
            }
        }
        finally {
            SAPUtilsJDK5.quitConnection(jCoRepository);
        }
    }

    public static SAPOutput[] getBapiTablesColumnNames(String string, String string2, Map map, String string3) {
        try {
            if (string3 != null) {
                ArrayList arrayList = new ArrayList();
                SAPUtilsJDK5.getBapiTableData4DifferentJDK(string, string2, map, string3, null, arrayList, null);
                return arrayList.toArray(new SAPOutput[0]);
            }
            return null;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getBapiTableData4DifferentJDK(String string, String string2, Map map, String string3, String[] stringArray, List list, List list2) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        try {
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, string2);
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            JCoParameterList jCoParameterList = SAPUtilsJDK5.getImportParameterList(jCoFunction);
            if (map != null) {
                SAPUtilsJDK5.setBapiInput(jCoParameterList, map);
            }
            JCoParameterList jCoParameterList2 = SAPUtilsJDK5.getTableParameterList(jCoFunction);
            SAPUtilsJDK5.executeFunction(jCoFunction, jCoDestination);
            JCoTable jCoTable = jCoParameterList2.getTable(string3);
            int n2 = jCoTable.getNumRows();
            if (list2 != null) {
                SAPUtilsJDK5.saveTableData(jCoTable, n2, stringArray, list2);
            }
        }
        finally {
            SAPUtilsJDK5.quitConnection(jCoRepository);
        }
    }

    private static void saveTableData(JCoTable jCoTable, int n2, String[] stringArray, List list) throws Exception {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = new Object[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                jCoTable.setRow(i2);
                objectArray[i3] = jCoTable.getValue(i3);
                if (objectArray[i3] != null) continue;
                objectArray[i3] = "";
            }
            list.add(objectArray);
        }
    }

    public static String[] getBapiTablesNameByCon(String string, String string2) {
        try {
            return SAPUtilsJDK5.getBapiTablesName4DifferentJDK(string, string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    private static void setBapiInput(JCoParameterList jCoParameterList, Map map) throws Exception {
        try {
            if (jCoParameterList != null) {
                Object object;
                int n2;
                int n3 = jCoParameterList.getFieldCount();
                String[] stringArray = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    String string;
                    object = jCoParameterList.getMetaData();
                    stringArray[n2] = string = object.getName(n2);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!map.containsKey(stringArray[n2])) continue;
                    object = map.get(stringArray[n2]);
                    if (object instanceof FormulaProvider) {
                        object = Calculator.createCalculator().eval(String.valueOf(object));
                    }
                    jCoParameterList.setValue(stringArray[n2], object);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public static String[] getTransparentTableColumnNames(String string, String string2) {
        try {
            JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
            JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, "RFC_READ_TABLE");
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            JCoParameterList jCoParameterList = SAPUtilsJDK5.getImportParameterList(jCoFunction);
            JCoParameterList jCoParameterList2 = SAPUtilsJDK5.getTableParameterList(jCoFunction);
            JCoTable jCoTable = jCoParameterList2.getTable("FIELDS");
            jCoParameterList.setValue("QUERY_TABLE", string2);
            SAPUtilsJDK5.executeFunction(jCoFunction, jCoDestination);
            int n2 = jCoTable.getNumRows();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3;
                jCoTable.setRow(i2);
                stringArray[i2] = string3 = jCoTable.getString(0);
            }
            SAPUtilsJDK5.quitConnection(jCoRepository);
            return stringArray;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTransparentTable(String string, String string2, String[] stringArray, String[] stringArray2, List list) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        try {
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, "RFC_READ_TABLE");
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            JCoParameterList jCoParameterList = SAPUtilsJDK5.getImportParameterList(jCoFunction);
            SAPUtilsJDK5.setValueOfInput(jCoParameterList, string2);
            JCoParameterList jCoParameterList2 = SAPUtilsJDK5.getTableParameterList(jCoFunction);
            JCoTable jCoTable = jCoParameterList2.getTable("OPTIONS");
            JCoTable jCoTable2 = jCoParameterList2.getTable("FIELDS");
            JCoTable jCoTable3 = jCoParameterList2.getTable("DATA");
            SAPUtilsJDK5.setClauses(jCoTable, jCoTable2, jCoTable3, stringArray, stringArray2);
            SAPUtilsJDK5.executeFunction(jCoFunction, jCoDestination);
            SAPUtilsJDK5.saveTableData(jCoTable3, list);
        }
        finally {
            SAPUtilsJDK5.quitConnection(jCoRepository);
        }
    }

    private static void setValueOfInput(JCoParameterList jCoParameterList, String string) throws Exception {
        jCoParameterList.setValue("QUERY_TABLE", string);
        jCoParameterList.setValue("ROWCOUNT", "100000000");
        jCoParameterList.setValue("DELIMITER", "|");
    }

    private static void setClauses(JCoTable jCoTable, JCoTable jCoTable2, JCoTable jCoTable3, String[] stringArray, String[] stringArray2) throws Exception {
        int n2;
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                jCoTable.appendRow();
                jCoTable.setValue("TEXT", stringArray[n2]);
            }
        }
        if (stringArray2 != null) {
            jCoTable3.clear();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                jCoTable2.appendRow();
                jCoTable2.setValue("FIELDNAME", stringArray2[n2]);
            }
        }
    }

    public static void saveTableData(JCoTable jCoTable, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        int n2 = jCoTable.getNumRows();
        if (n2 > 0) {
            boolean bl;
            do {
                JCoRecordFieldIterator jCoRecordFieldIterator = jCoTable.getRecordFieldIterator();
                JCoRecordField jCoRecordField = jCoRecordFieldIterator.nextRecordField();
                String string = jCoRecordField.getString();
                int n3 = 0;
                SAPUtilsJDK5.addRow(n3, string, arrayList);
                list.add(arrayList.toArray(new String[0]));
                arrayList.clear();
            } while (bl = jCoTable.nextRow());
        }
    }

    private static void addRow(int n2, String string, ArrayList arrayList) {
        int n3;
        do {
            String string2;
            if ((n3 = string.indexOf("|", n2)) < 0) {
                string2 = string.substring(n2);
            } else {
                string2 = string.substring(n2, n3);
                n2 = n3 + 1;
            }
            string2 = string2.trim();
            arrayList.add(string2);
        } while (n3 > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractTableData(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, List list) throws Exception {
        JCoDestination jCoDestination = SAPUtilsJDK5.getConnection(string);
        JCoRepository jCoRepository = SAPUtilsJDK5.getRepository(jCoDestination);
        try {
            JCoFunctionTemplate jCoFunctionTemplate = SAPUtilsJDK5.getFunctionTemplate(jCoRepository, "EXTRACT_TABLE_DATA");
            JCoFunction jCoFunction = SAPUtilsJDK5.getFunction(jCoFunctionTemplate);
            JCoParameterList jCoParameterList = SAPUtilsJDK5.getTableParameterList(jCoFunction);
            SAPUtilsJDK5.populateTable(jCoParameterList, "FROMCLAUSE", stringArray2);
            SAPUtilsJDK5.populateTable(jCoParameterList, "FIELDS", stringArray);
            if (stringArray3 != null && stringArray3.length > 0) {
                SAPUtilsJDK5.populateTable(jCoParameterList, "WHERECLAUSE", stringArray3);
            }
            SAPUtilsJDK5.executeFunction(jCoFunction, jCoDestination);
            JCoTable jCoTable = jCoParameterList.getTable("DATA");
            SAPUtilsJDK5.saveDataForV6(jCoTable, list);
        }
        finally {
            SAPUtilsJDK5.quitConnection(jCoRepository);
        }
    }

    private static void populateTable(JCoParameterList jCoParameterList, String string, String[] stringArray) throws Exception {
        int n2 = 0;
        JCoTable jCoTable = null;
        try {
            boolean bl;
            jCoTable = jCoParameterList.getTable(string);
            jCoTable.appendRows(stringArray.length);
            do {
                jCoTable.setValue(0, stringArray[n2]);
                ++n2;
            } while (bl = jCoTable.nextRow());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    private static void saveDataForV6(JCoTable jCoTable, List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        int n2 = jCoTable.getNumRows();
        if (n2 > 0) {
            boolean bl;
            do {
                JCoRecordFieldIterator jCoRecordFieldIterator = jCoTable.getRecordFieldIterator();
                JCoRecordField jCoRecordField = jCoRecordFieldIterator.nextRecordField();
                String string = jCoRecordField.getString();
                int n3 = 1;
                SAPUtilsJDK5.addRow(n3, string, arrayList);
                list.add(arrayList.toArray(new String[0]));
                arrayList.clear();
            } while (bl = jCoTable.nextRow());
        }
    }
}

