/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;

public class SAPDatabaseConnection
implements Connection {
    private static final String XML_TAG = "SAPDatabaseAttr";
    private static final int JDK5 = 5;
    private String ashost;
    private String sysnr;
    private String lang = "en";
    private String client;
    private String user;
    private String passwd;
    private String poolCapacity = "3";
    private String peakLimit = "10";

    public Object getConnection() throws Exception {
        if (StableUtils.getMajorJavaVersion() < 5) {
            Class clazz = GeneralUtils.classForName("com.sap.mw.jco.JCO");
            Method method = clazz.getMethod("createClient", String.class, String.class, String.class, String.class, String.class, String.class);
            return method.invoke((Object)clazz, this.client, this.user, this.passwd, this.lang, this.ashost, this.sysnr);
        }
        Properties properties = new Properties();
        properties.setProperty("jco.client.ashost", this.ashost);
        properties.setProperty("jco.client.sysnr", this.sysnr);
        properties.setProperty("jco.client.client", this.client);
        properties.setProperty("jco.client.user", this.user);
        properties.setProperty("jco.client.passwd", this.passwd);
        properties.setProperty("jco.client.lang", this.lang);
        properties.setProperty("jco.destination.pool_capacity", this.poolCapacity);
        properties.setProperty("jco.destination.peak_limit", this.peakLimit);
        File file = new File("pool.jcoDestination");
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        properties.store(fileOutputStream, this.ashost);
        fileOutputStream.close();
        Class clazz = GeneralUtils.classForName("com.sap.conn.jco.JCoDestinationManager");
        Object object = clazz.getMethod("getDestination", String.class).invoke((Object)clazz, "pool");
        file.delete();
        return object;
    }

    public void testConnection() throws Exception {
        if (StableUtils.getMajorJavaVersion() < 5) {
            Object object = this.getConnection();
            Method method = object.getClass().getMethod("connect", new Class[0]);
            method.invoke(object, new Object[0]);
            Constructor constructor = GeneralUtils.classForName("com.sap.mw.jco.JCO$Repository").getDeclaredConstructor(String.class, object.getClass());
            Object t2 = constructor.newInstance("Repository", object);
            Method method2 = t2.getClass().getMethod("getFunctionTemplate", new Class[0]);
            method2.invoke(t2, "RFC_READ_TABLE");
            Method method3 = object.getClass().getMethod("disconnect", new Class[0]);
            method3.invoke(object, new Object[0]);
        } else {
            Object object = this.getConnection();
            Method method = object.getClass().getMethod("getRepository", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Method method4 = object2.getClass().getMethod("getFunctionTemplate", String.class);
            method4.invoke(object2, "RFC_READ_TABLE");
            Method method5 = object2.getClass().getMethod("clear", new Class[0]);
            method5.invoke(object2, new Object[0]);
        }
    }

    public void setAshost(String string) {
        this.ashost = string;
    }

    public void setSysnr(String string) {
        this.sysnr = string;
    }

    public void setClient(String string) {
        this.client = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPasswd(String string) {
        this.passwd = string;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public void setPoolCapacity(String string) {
        this.poolCapacity = string;
    }

    public void setPeakLimit(String string) {
        this.peakLimit = string;
    }

    public String getAshost() {
        return this.ashost;
    }

    public String getSysnr() {
        return this.sysnr;
    }

    public String getClient() {
        return this.client;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getLang() {
        return this.lang;
    }

    public String getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getPeakLimit() {
        return this.peakLimit;
    }

    public String getOriginalCharsetName() {
        return null;
    }

    public void setOriginalCharsetName(String string) {
    }

    public String getNewCharsetName() {
        return null;
    }

    public String getDriver() {
        return null;
    }

    public void setNewCharsetName(String string) {
    }

    public java.sql.Connection createConnection() throws Exception {
        return null;
    }

    public boolean isDatabaseConnection() {
        return false;
    }

    public boolean isXMLAConnection() {
        return false;
    }

    public boolean isFineBIConnection() {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && XML_TAG.equals(xMLableReader.getTagName())) {
            this.setAshost(xMLableReader.getAttrAsString("host", ""));
            this.setSysnr(xMLableReader.getAttrAsString("sysnr", "00"));
            this.setLang(xMLableReader.getAttrAsString("lang", "en"));
            this.setClient(xMLableReader.getAttrAsString("client", ""));
            this.setUser(xMLableReader.getAttrAsString("user", ""));
            this.setPasswd(CodeUtils.passwordDecode(xMLableReader.getAttrAsString("password", "")));
            this.setPoolCapacity(xMLableReader.getAttrAsString("capacity", "3"));
            this.setPeakLimit(xMLableReader.getAttrAsString("peaklimit", "10"));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotEmpty(this.ashost)) {
            xMLPrintWriter.attr("host", this.ashost);
        }
        if (StringUtils.isNotEmpty(this.sysnr)) {
            xMLPrintWriter.attr("sysnr", this.sysnr);
        }
        if (StringUtils.isNotEmpty(this.lang)) {
            xMLPrintWriter.attr("lang", this.lang);
        }
        if (StringUtils.isNotEmpty(this.client)) {
            xMLPrintWriter.attr("client", this.client);
        }
        if (StringUtils.isNotEmpty(this.user)) {
            xMLPrintWriter.attr("user", this.user);
        }
        if (StringUtils.isNotEmpty(this.passwd)) {
            xMLPrintWriter.attr("password", CodeUtils.passwordEncode(this.passwd));
        }
        if (StringUtils.isNotEmpty(this.poolCapacity)) {
            xMLPrintWriter.attr("capacity", this.poolCapacity);
        }
        if (StringUtils.isNotEmpty(this.peakLimit)) {
            xMLPrintWriter.attr("peaklimit", this.peakLimit);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SAPDatabaseConnection)) {
            return false;
        }
        SAPDatabaseConnection sAPDatabaseConnection = (SAPDatabaseConnection)object;
        return ComparatorUtils.equals(this.ashost, sAPDatabaseConnection.ashost) && ComparatorUtils.equals(this.client, sAPDatabaseConnection.client) && ComparatorUtils.equals(this.lang, sAPDatabaseConnection.lang) && ComparatorUtils.equals(this.passwd, sAPDatabaseConnection.passwd) && ComparatorUtils.equals(this.peakLimit, sAPDatabaseConnection.peakLimit) && ComparatorUtils.equals(this.poolCapacity, sAPDatabaseConnection.poolCapacity) && ComparatorUtils.equals(this.sysnr, sAPDatabaseConnection.sysnr) && ComparatorUtils.equals(this.user, sAPDatabaseConnection.user);
    }

    public Object clone() throws CloneNotSupportedException {
        SAPDatabaseConnection sAPDatabaseConnection = (SAPDatabaseConnection)super.clone();
        sAPDatabaseConnection.ashost = this.ashost;
        sAPDatabaseConnection.sysnr = this.sysnr;
        sAPDatabaseConnection.lang = this.lang;
        sAPDatabaseConnection.client = this.client;
        sAPDatabaseConnection.user = this.user;
        sAPDatabaseConnection.passwd = this.passwd;
        sAPDatabaseConnection.poolCapacity = this.poolCapacity;
        sAPDatabaseConnection.peakLimit = this.peakLimit;
        return sAPDatabaseConnection;
    }
}

