/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.AbstractDataModel;
import com.fr.data.impl.sap.SAPUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.TableDataException;
import com.fr.stable.StableUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class GeneralQuerySAPDataModel
extends AbstractDataModel {
    private String connectionName;
    private String[] selectClausV6;
    private String[] fromClausV6;
    private String[] whereClausV6;
    private String[] colNames;
    private List data = null;
    private static final int JDK5 = 5;
    private static final int FOUR = 4;

    public GeneralQuerySAPDataModel(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.connectionName = string;
        this.selectClausV6 = stringArray;
        this.fromClausV6 = stringArray2;
        this.whereClausV6 = stringArray3;
        this.dealColNames(this.selectClausV6);
    }

    private void dealColNames(String[] stringArray) {
        this.colNames = new String[stringArray.length];
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2].toUpperCase();
            n2 = string.indexOf(" AS ");
            if (n2 > -1) {
                this.colNames[i2] = stringArray[i2].substring(n2 + 4).trim();
                stringArray[i2] = stringArray[i2].substring(0, n2).trim();
                continue;
            }
            n2 = string.indexOf("~");
            this.colNames[i2] = n2 > -1 ? stringArray[i2].substring(n2 + 1).trim() : stringArray[i2];
        }
    }

    public int getColumnCount() throws TableDataException {
        return this.colNames == null ? 0 : this.colNames.length;
    }

    public String getColumnName(int n2) throws TableDataException {
        return this.colNames == null ? null : this.colNames[n2];
    }

    public int getRowCount() throws TableDataException {
        this.initData();
        return this.data.size();
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        this.initData();
        return n3 < 0 ? null : (this.hasRow(n2) ? ((Object[])this.data.get(n2))[n3] : null);
    }

    private void initData() throws TableDataException {
        if (this.data == null) {
            this.data = new ArrayList();
            try {
                if (StableUtils.getMajorJavaVersion() < 5) {
                    SAPUtils.extractTableData(this.connectionName, this.selectClausV6, this.fromClausV6, this.whereClausV6, this.data);
                } else {
                    Class clazz = GeneralUtils.classForName("com.fr.data.impl.sap.SAPUtilsJDK5");
                    Method method = clazz.getMethod("extractTableData", String.class, String[].class, String[].class, String[].class, List.class);
                    method.invoke((Object)clazz, this.connectionName, this.selectClausV6, this.fromClausV6, this.whereClausV6, this.data);
                }
            }
            catch (Exception exception) {
                throw new TableDataException(exception.getMessage(), exception);
            }
        }
    }

    public void release() throws Exception {
        if (this.data != null) {
            this.data.clear();
            this.data = null;
        }
    }
}

