/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.sap;

import com.fr.data.AbstractDataModel;
import com.fr.data.impl.sap.SAPUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.TableDataException;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomFunctionSAPDataModel
extends AbstractDataModel {
    private String connectionName;
    private String bapiName;
    private String choosedTable;
    private String[] columnNames;
    private Map inputs;
    private static final int JDK5 = 5;
    private List tableData = null;

    public CustomFunctionSAPDataModel(String string, String string2, String string3, String[] stringArray, Map map) {
        this.connectionName = string;
        this.bapiName = string2;
        this.choosedTable = string3;
        this.columnNames = stringArray;
        this.inputs = map;
    }

    public int getColumnCount() throws TableDataException {
        return this.columnNames == null ? 0 : this.columnNames.length;
    }

    public String getColumnName(int n2) throws TableDataException {
        return this.columnNames == null ? null : this.columnNames[n2];
    }

    public int getRowCount() throws TableDataException {
        this.initData();
        return this.tableData.size();
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        this.initData();
        return n3 < 0 ? null : (this.hasRow(n2) ? ((Object[])this.tableData.get(n2))[n3] : null);
    }

    private void initData() throws TableDataException {
        if (this.tableData == null) {
            this.tableData = new ArrayList();
            try {
                if (StringUtils.isNotBlank(this.choosedTable)) {
                    if (StableUtils.getMajorJavaVersion() < 5) {
                        SAPUtils.getBapiTableData4DifferentJDK(this.connectionName, this.bapiName, this.inputs, this.choosedTable, this.columnNames, null, this.tableData);
                    } else {
                        Class clazz = GeneralUtils.classForName("com.fr.data.impl.sap.SAPUtilsJDK5");
                        Method method = clazz.getMethod("getBapiTableData4DifferentJDK", String.class, String.class, Map.class, String.class, String[].class, List.class, List.class);
                        method.invoke((Object)clazz, this.connectionName, this.bapiName, this.inputs, this.choosedTable, this.columnNames, null, this.tableData);
                    }
                }
            }
            catch (Exception exception) {
                throw new TableDataException(exception.getMessage(), exception);
            }
        }
    }

    public void release() throws Exception {
        if (this.tableData != null) {
            this.tableData.clear();
            this.tableData = null;
        }
    }
}

