/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.xmla;

import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.condition.XMLAListField;
import com.fr.data.condition.XMLATreeNodeField;
import com.fr.data.impl.multidimensional.MultiDimensionTableData;
import com.fr.data.impl.multidimensional.xmla.XMLADatabaseConnection;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLATableData
extends MultiDimensionTableData
implements XMLable {
    private static final long serialVersionUID = 5350433006672666226L;
    public static final String XMLA_TABLE_TAG = "XMLATableDataAttr";
    private String userDefinedMdx = "";
    private boolean isChangedAxisDmName = false;
    private String withState = "";
    private String rowAfterFilter = "";

    public void setParams(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(XMLA_TABLE_TAG, string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttrAsString("connectionName", null);
            if (string2 != null) {
                this.setConnectionName(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("cube", null)) != null) {
                this.setCube(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("selectMeasure", null)) != null) {
                this.setSelectMeasure(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("selectDimension", null)) != null) {
                this.setSelectDimension(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("userDefinedMdx", null)) != null) {
                this.setUserDefinedMdx(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("queryMode", null)) != null) {
                this.setQueryMode(string2);
            }
            if ((string2 = xMLableReader.getAttrAsString("class", null)) != null) {
                XMLATreeNodeField xMLATreeNodeField = null;
                try {
                    xMLATreeNodeField = (XMLATreeNodeField)GeneralUtils.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
                if (xMLATreeNodeField != null) {
                    xMLableReader.readXMLObject(xMLATreeNodeField);
                    this.setFilterStatement(xMLATreeNodeField);
                }
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(XMLA_TABLE_TAG);
        xMLPrintWriter.attr("connectionName", this.getConnectionName());
        xMLPrintWriter.attr("cube", this.getCube());
        xMLPrintWriter.attr("selectMeasure", this.getSelectMeasure());
        xMLPrintWriter.attr("selectDimension", this.getSelectDimension());
        xMLPrintWriter.attr("userDefinedMdx", this.userDefinedMdx);
        xMLPrintWriter.attr("queryMode", this.getQueryMode());
        if (this.getFilterStatement() != null) {
            xMLPrintWriter.attr("class", this.getFilterStatement().getClass().getName());
            this.getFilterStatement().writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public String getUserDefinedMdx() {
        return this.userDefinedMdx;
    }

    public void setUserDefinedMdx(String string) {
        this.userDefinedMdx = string;
    }

    protected String dealParameter(String string, ParameterProvider[] parameterProviderArray) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return ParameterHelper.analyzeCurrentContextTableData4Templatee(string, parameterProviderArray);
    }

    protected String createColumnMdx(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        return stringBuilder.append(string.trim()).append("} on columns, ").toString();
    }

    protected String[] getSelectAxisDm(String string, String string2) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return new String[0];
        }
        String[] stringArray = this.getSelectRowAxisDm(string);
        String[] stringArray2 = this.getSelectColAxisDm(string2);
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected abstract String[] getSelectRowAxisDm(String var1);

    protected String[] getSelectColAxisDm(String string) {
        if (StringUtils.isBlank(string)) {
            return new String[0];
        }
        return string.split(",");
    }

    protected String[] getAllMeasure(String string) {
        XMLADatabaseConnection xMLADatabaseConnection = (XMLADatabaseConnection)DatasourceManager.getInstance().getConnection(string);
        try {
            return xMLADatabaseConnection.getAllMeasures(this.getCube());
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    protected void dealFilterStatement(XMLATreeNodeField xMLATreeNodeField) {
        if (xMLATreeNodeField == null) {
            return;
        }
        String[] stringArray = this.getAllMeasure(this.getConnectionName());
        List<String> list = Arrays.asList(stringArray);
        ArrayList<XMLATreeNodeField> arrayList = new ArrayList<XMLATreeNodeField>();
        ArrayList<XMLATreeNodeField> arrayList2 = new ArrayList<XMLATreeNodeField>();
        boolean bl = xMLATreeNodeField.isNode();
        int n2 = bl ? 1 : ((XMLAListField)xMLATreeNodeField).getJoinFieldCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XMLATreeNodeField xMLATreeNodeField2;
            XMLATreeNodeField xMLATreeNodeField3 = xMLATreeNodeField2 = bl ? xMLATreeNodeField : ((XMLAListField)xMLATreeNodeField).getJoinField(i2).getField();
            if (list.indexOf(xMLATreeNodeField2.getFirstEditValue().toString()) != -1) {
                arrayList2.add(xMLATreeNodeField2);
                continue;
            }
            arrayList.add(xMLATreeNodeField2);
        }
        this.dealFilterState(arrayList, arrayList2);
    }

    protected void dealFilterState(List<XMLATreeNodeField> list, List<XMLATreeNodeField> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank(this.getSelectDimension()) || StringUtils.isBlank(this.getSelectMeasure())) {
            return;
        }
        if (list2.isEmpty()) {
            this.dealDmFilter(list);
        } else if (list.isEmpty()) {
            this.dealSelectColWithMeasure(list2);
        } else {
            this.dealDmFilter(list);
            this.dealSelectColWithMeasure(list2);
        }
    }

    protected void dealDmFilter(List<XMLATreeNodeField> list) {
        String[] stringArray = this.getSelectRowAxisDm(this.getSelectDimension());
        List<String> list2 = Arrays.asList(stringArray);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = this.dealDimensionMember(list.get(i2).getFirstEditValue().toString());
            if (list2.indexOf(string) == -1) {
                this.dealSlice(list.get(i2));
                continue;
            }
            this.dealSelectRowDm(list.get(i2), list2);
        }
    }

    protected abstract void dealSlice(XMLATreeNodeField var1);

    protected abstract void dealSelectRowDm(XMLATreeNodeField var1, List<String> var2);

    protected void dealSelectColWithMeasure(List<XMLATreeNodeField> list) {
        StringBuilder stringBuilder = new StringBuilder("set measureset as 'filter( ");
        String string = !this.isChangedAxisDmName ? this.createRowMdx(this.getSelectDimension()) : this.createRowMdxAfterFiltered(this.rowAfterFilter);
        stringBuilder.append(string.replaceAll("Non Empty", "CrossJoin")).append(",");
        this.setRowAfterFilter("measureset");
        this.isChangedAxisDmName = true;
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (this.isNotValidFilterState(list.get(i2))) continue;
            if (i2 > 0) {
                stringBuilder2.append(" and ");
            }
            String string2 = list.get(i2).getFirstEditValue().toString();
            Integer n2 = list.get(i2).getFirstCompare();
            Object object = this.dealWithCompareValue(list.get(i2).getEditValues()[0]);
            if (ComparatorUtils.equals(n2, 0)) {
                stringBuilder2.append(string2).append("=").append(object);
                continue;
            }
            if (ComparatorUtils.equals(n2, 1)) {
                stringBuilder2.append(string2).append("<>").append(object);
                continue;
            }
            if (ComparatorUtils.equals(n2, 2)) {
                stringBuilder2.append(string2).append(">").append(object);
                continue;
            }
            if (ComparatorUtils.equals(n2, 3)) {
                stringBuilder2.append(string2).append(">=").append(object);
                continue;
            }
            if (ComparatorUtils.equals(n2, 4)) {
                stringBuilder2.append(string2).append("<").append(object);
                continue;
            }
            if (ComparatorUtils.equals(n2, 5)) {
                stringBuilder2.append(string2).append("<=").append(object);
                continue;
            }
            if (ComparatorUtils.equals(n2, 12)) {
                stringBuilder2.append(this.dealWithMeasureConditionIn(object.toString(), string2));
                continue;
            }
            if (!ComparatorUtils.equals(n2, 13)) continue;
            stringBuilder2.append(this.dealWithMeConditionNotIn(object.toString(), string2));
        }
        stringBuilder.append(stringBuilder2.toString()).append(")' ");
        this.withState = StringUtils.isBlank(this.withState) ? stringBuilder.insert(0, "with ").toString() : stringBuilder.insert(0, this.withState).toString();
    }

    protected abstract String dealDimensionMember(String var1);

    protected abstract String createRowMdx(String var1);

    protected abstract String createRowMdxAfterFiltered(String var1);

    protected String dealWithDmConditionIn(String string, String string2) {
        String[] stringArray = string.replaceAll("[\\(\\)]", "").split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append(string2).append(".[").append(stringArray[i2]).append("],");
        }
        return stringBuilder.append(string2).append(".[").append(stringArray[stringArray.length - 1]).append("]").toString();
    }

    protected String dealWithDmConditionNotIn(String string, String string2) {
        String[] stringArray = string.replaceAll("[\\(\\)]", "").split(",");
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append("-").append(string2).append(".[").append(stringArray[i2]).append("]");
        }
        return stringBuilder.append("-").append(string2).append(".[").append(stringArray[stringArray.length - 1]).append("]").toString();
    }

    protected void modifySelectDimension(String string, int n2) {
        String[] stringArray = this.isChangedAxisDmName ? this.rowAfterFilter.split(",") : this.getSelectDimension().split(",");
        if (n2 > stringArray.length - 1) {
            return;
        }
        stringArray[n2] = string;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append(stringArray[i2]).append(",");
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        this.setRowAfterFilter(stringBuilder.toString());
    }

    protected String dealWithSliceDmConditionIn(String string, String string2) {
        String[] stringArray = string.replaceAll("[\\(\\)]", "").split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append(string2).append(".[").append(stringArray[i2]).append("];");
        }
        return stringBuilder.append(string2).append(".[").append(stringArray[stringArray.length - 1]).append("]").toString();
    }

    protected String dealWithMeasureConditionIn(String string, String string2) {
        String[] stringArray = string.replaceAll("[\\(\\)]", "").split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append(string2).append("=").append(stringArray[i2]).append(" and ");
        }
        return stringBuilder.append(string2).append("=").append(stringArray[stringArray.length - 1]).toString();
    }

    protected String dealWithMeConditionNotIn(String string, String string2) {
        String[] stringArray = string.replaceAll("[\\(\\)]", "").split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append(string2).append("<>").append(stringArray[i2]).append(" and ");
        }
        return stringBuilder.append(string2).append("<>").append(stringArray[stringArray.length - 1]).toString();
    }

    protected boolean isNotValidFilterState(XMLATreeNodeField xMLATreeNodeField) {
        return xMLATreeNodeField.getFirstEditValue() == null || xMLATreeNodeField.getFirstCompare() == null || xMLATreeNodeField.getEditValues()[0] == null;
    }

    protected Object dealWithCompareValue(Object object) {
        Object object2 = null;
        if (object instanceof ParameterProvider) {
            String string = "${" + ((ParameterProvider)object).getName() + "}";
            object2 = ParameterHelper.analyze4Templatee(string, this.parameters);
        } else if (object instanceof FormulaProvider) {
            String string = ((FormulaProvider)object).getContent();
            try {
                object2 = Calculator.createCalculator().evalValue(string);
            }
            catch (UtilEvalError utilEvalError) {
                object2 = string;
            }
        } else if (object instanceof String) {
            object2 = ((String)object).replaceAll("[\\[\\]\"'\u2018\u201c]", "");
        } else {
            if (object instanceof Date) {
                return ((Date)object).toGMTString();
            }
            object2 = String.valueOf(object);
        }
        return object2;
    }

    protected String getHierarchyFromLevel(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 3) {
            return string;
        }
        return stringArray[0] + "." + stringArray[1];
    }

    protected boolean isChangedAxisDmName() {
        return this.isChangedAxisDmName;
    }

    protected void setChangedAxisDmName(boolean bl) {
        this.isChangedAxisDmName = bl;
    }

    protected String GetWithState() {
        return this.withState;
    }

    protected void setWithState(String string) {
        this.withState = string;
    }

    @Override
    public boolean isXMLAData() {
        return true;
    }

    @Override
    public boolean isFineBIData() {
        return false;
    }

    public String getRowAfterFilter() {
        return this.rowAfterFilter;
    }

    public void setRowAfterFilter(String string) {
        this.rowAfterFilter = string;
    }
}

