/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl.multidimensional.xmla;

import com.fr.data.impl.multidimensional.xmla.XMLADataModel;
import com.fr.general.FRLogger;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.stable.StableUtils;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.metadata.Member;

public class SSASQueryXMLADataModel
extends XMLADataModel {
    private int axisRows = 1;
    private static boolean supportSsas = true;

    public SSASQueryXMLADataModel(String string, String string2, boolean bl) {
        super(string, string2, bl);
    }

    public void release() throws Exception {
        if (this.getValueList() != null) {
            this.clearValueList();
        }
    }

    protected void initData() {
        if (!supportSsas) {
            throw new RegistEditionException(VT4FR.SSAS);
        }
        if (!this.getValueList().isEmpty()) {
            return;
        }
        try {
            OlapConnection olapConnection = this.getConnection(this.getConnectionName());
            OlapStatement olapStatement = olapConnection.createStatement();
            CellSet cellSet = olapStatement.executeOlapQuery(this.getMdxStatement());
            if (this.isCustomMdx()) {
                this.dealValueListWithCustom(cellSet);
            } else {
                this.dealValueList(cellSet);
            }
            olapStatement.close();
            olapConnection.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    protected String[] getRowAxeNames(CellSet cellSet, int n2) {
        Position position = (Position)((CellSetAxis)cellSet.getAxes().get(this.axisRows)).getPositions().get(0);
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = ((Member)position.getMembers().get(i2)).getUniqueName();
            String[] stringArray2 = string.split("\\.");
            stringArray[i2] = stringArray2.length < 3 ? stringBuilder.append(string).toString() : (stringArray2.length == 3 ? stringBuilder.append(stringArray2[0]).append(".").append(stringArray2[1]).toString() : stringBuilder.append(stringArray2[0]).append(".").append(stringArray2[1]).append(".").append(stringArray2[2]).toString());
        }
        return stringArray;
    }

    protected String getDimensionName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 3) {
            return string;
        }
        if (stringArray.length == 3) {
            return stringBuilder.append(stringArray[0]).append(".").append(stringArray[1]).toString();
        }
        return stringBuilder.append(stringArray[0]).append(".").append(stringArray[1]).append(".").append(stringArray[2]).toString();
    }

    static {
        supportSsas = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.SSAS.support();
    }
}

