/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.BaseScriptUtils;
import com.fr.base.ParameterHelper;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.base.TemplateUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.FormulaDisplayDictionary;
import com.fr.data.impl.NameTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableDataDictionary
extends FormulaDisplayDictionary {
    private TableData tableData;
    private transient List kvs;
    private transient String query;

    public TableDataDictionary() {
        this(TableData.EMPTY_TABLEDATA, 0, 1);
    }

    public TableDataDictionary(TableData tableData, int n2, int n3) {
        this.setTableData(tableData);
        this.setKeyColumnIndex(n2);
        this.setValueColumnIndex(n3);
    }

    public void setTableData(TableData tableData) {
        this.tableData = tableData;
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public String[] getDependence(Calculator calculator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = super.getDependence(calculator);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(stringArray[i2]);
            }
        }
        if (this.tableData != null) {
            ParameterProvider[] parameterProviderArray = this.tableData.getParameters(calculator);
            if (parameterProviderArray != null && parameterProviderArray.length != 0) {
                for (int i3 = 0; i3 < parameterProviderArray.length; ++i3) {
                    ParameterProvider parameterProvider = parameterProviderArray[i3];
                    if (parameterProvider == null || parameterProvider.getName() == null) continue;
                    arrayList.add(parameterProvider.getName());
                }
            } else if (this.isDBNameTableData(calculator)) {
                DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
                return BaseScriptUtils.getDependenceByParameter(ParameterHelper.analyze4Parameters(dBTableData.getQuery(), true));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private boolean isDBNameTableData(Calculator calculator) {
        return this.getTableData() instanceof NameTableData && ((NameTableData)this.getTableData()).createTableData(calculator) instanceof DBTableData;
    }

    protected TableData asTableData(Calculator calculator) {
        if (this.isDBNameTableData(calculator)) {
            ParameterMapNameSpace parameterMapNameSpace = this.getDBParameterNameSpace(calculator);
            calculator.pushNameSpace(parameterMapNameSpace);
            DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
            this.query = TemplateUtils.renderTpl(calculator, dBTableData.getQuery());
            DBTableData dBTableData2 = new DBTableData(dBTableData.getDatabase(), this.query);
            calculator.removeNameSpace(parameterMapNameSpace);
            dBTableData2.setShare(dBTableData.isShare());
            return dBTableData2;
        }
        return this.getTableData();
    }

    protected boolean isShareAvailable(Calculator calculator) {
        if (!super.isShareAvailable(calculator) || !this.isDBNameTableData(calculator)) {
            return false;
        }
        DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
        return ComparatorUtils.equals(this.query, TemplateUtils.renderTpl(calculator, dBTableData.getQuery()));
    }

    public ParameterMapNameSpace getDBParameterNameSpace(Calculator calculator) {
        DBTableData dBTableData = (DBTableData)((NameTableData)this.getTableData()).getTableData();
        ParameterProvider[] parameterProviderArray = dBTableData.getParameters(calculator);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            try {
                if (!StableUtils.isNull(calculator.eval(parameterProviderArray[i2].getName())) || StableUtils.isNull(parameterProviderArray[i2].getValue())) continue;
                hashMap.put(parameterProviderArray[i2].getName(), parameterProviderArray[i2].getValue());
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage());
            }
        }
        return ParameterMapNameSpace.create(hashMap);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && ("TableDataDictAttr".equals(string = xMLableReader.getTagName()) || "TableDataMapAttr".equals(string))) {
            String string2 = xMLableReader.getAttrAsString("keyColumnIndex", null);
            if (string2 != null) {
                this.setKeyColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttrAsString("valueColumnIndex", null)) != null) {
                this.setValueColumnIndex(Integer.parseInt(string2) - 1);
            }
            if ((string2 = xMLableReader.getAttrAsString("tableDataName", null)) != null) {
                this.setTableData(new NameTableData(string2));
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        if ("TableData".equals(xMLableReader.getTagName())) {
                            TableDataDictionary.this.setTableData(DataCoreXmlUtils.readXMLTableData(xMLableReader));
                        }
                        if ("Condition".equals(xMLableReader.getTagName())) {
                            TableDataDictionary.this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
                        }
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("TableDataDictAttr");
        DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, this.getTableData());
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableDataDictionary)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(this.tableData, ((TableDataDictionary)object).tableData);
    }

    public String toString() {
        return "TableDataDict[" + this.getTableData() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        TableDataDictionary tableDataDictionary = (TableDataDictionary)super.clone();
        return tableDataDictionary;
    }
}

