/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TableData;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class FormulaDisplayDictionary
implements Dictionary {
    protected Condition condition;
    protected int keyColumnIndex;
    protected String keyColumnName;
    protected String valueColumnName;
    protected int valueColumnIndex;
    protected FormulaProvider formula;
    protected transient List kvs;

    public int getKeyColumnIndex() {
        return this.keyColumnIndex;
    }

    public void setKeyColumnIndex(int n2) {
        this.keyColumnIndex = n2;
    }

    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public void setValueColumnIndex(int n2) {
        this.valueColumnIndex = n2;
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public void setKeyColumnName(String string) {
        this.keyColumnName = string;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String string) {
        this.valueColumnName = string;
    }

    public FormulaProvider getFormula() {
        return this.formula;
    }

    public void setFormula(FormulaProvider formulaProvider) {
        this.formula = formulaProvider;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String[] getDependence(Calculator calculator) {
        if (this.condition != null) {
            return this.condition.getDependence();
        }
        return new String[0];
    }

    public Object get(Object object, Calculator calculator) {
        this.createKVS(calculator);
        int n2 = this.kvs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Dictionary.MV mV = (Dictionary.MV)this.kvs.get(i2);
            if (!ComparatorUtils.equals(mV.getModel(), object)) continue;
            return mV.getView();
        }
        return null;
    }

    public Iterator entrys(Calculator calculator) {
        this.createKVS(calculator);
        return new EntryIterator();
    }

    public Iterator entrys(Calculator calculator, int n2, int n3) {
        this.createKVS(calculator, n2, n3);
        return new EntryIterator();
    }

    private void createKVS(Calculator calculator) {
        if (!this.isShareAvailable(calculator)) {
            TableData tableData = this.asTableData(calculator);
            if (tableData == null) {
                this.kvs = Collections.EMPTY_LIST;
                return;
            }
            this.kvs = new ArrayList();
            Map map = this.getParameterMap4Preview(calculator, tableData);
            try {
                tableData = (TableData)GeneralContext.getEnvProvider().previewTableData(tableData, map, -1);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                tableData = TableData.EMPTY_TABLEDATA;
            }
            DataModel dataModel = tableData.createDataModel(null);
            try {
                int n2 = dataModel.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.kvs.add(this.createMV(dataModel, i2, calculator));
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private void createKVS(Calculator calculator, int n2, int n3) {
        if (!this.isShareAvailable(calculator)) {
            TableData tableData = this.asTableData(calculator);
            if (tableData == null) {
                this.kvs = Collections.EMPTY_LIST;
                return;
            }
            this.kvs = new ArrayList();
            Map map = this.getParameterMap4Preview(calculator, tableData);
            try {
                tableData = (TableData)GeneralContext.getEnvProvider().previewTableData(tableData, map, n2, n3, new String[]{this.keyColumnName, this.valueColumnName}, new int[]{this.keyColumnIndex, this.valueColumnIndex});
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
                tableData = TableData.EMPTY_TABLEDATA;
            }
            DataModel dataModel = tableData.createDataModel(null);
            try {
                int n4 = dataModel.getRowCount();
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.kvs.add(this.createMV(dataModel, i2, calculator));
                }
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    private Map getParameterMap4Preview(Calculator calculator, TableData tableData) {
        ParameterProvider[] parameterProviderArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (calculator != null && (parameterProviderArray = tableData.getParameters(calculator)) != null) {
            for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
                ParameterProvider parameterProvider = parameterProviderArray[i2];
                try {
                    Object object = calculator.evalValue(parameterProvider.getName());
                    hashMap.put(parameterProvider.getName(), object);
                    continue;
                }
                catch (UtilEvalError utilEvalError) {
                    // empty catch block
                }
            }
        }
        return hashMap;
    }

    protected abstract TableData asTableData(Calculator var1);

    protected boolean isShareAvailable(Calculator calculator) {
        return this.kvs != null;
    }

    protected Dictionary.MV createMV(DataModel dataModel, int n2, Calculator calculator) throws TableDataException {
        int n3 = dataModel.getColumnCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < n3; ++i2) {
            hashMap.put(dataModel.getColumnName(i2), new Integer(i2));
        }
        Object object = dataModel.getValueAt(n2, this.getKeyColumnIndex(dataModel));
        Object object2 = dataModel.getValueAt(n2, this.getValueColumnIndex(dataModel));
        if (this.getFormula() != null) {
            if (calculator == null) {
                calculator = Calculator.createCalculator();
            }
            calculator.set("$$$", object);
            try {
                object2 = calculator.evalValue(this.getFormula());
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error(utilEvalError.getMessage(), utilEvalError);
            }
        }
        return new Dictionary.MV(object, object2);
    }

    public int getDataModelColumnIndex(DataModel dataModel, String string) {
        try {
            if (dataModel == null) {
                return -1;
            }
            int n2 = dataModel.getColumnCount();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < n2; ++i2) {
                hashMap.put(dataModel.getColumnName(i2), new Integer(i2));
            }
            Integer n3 = (Integer)hashMap.get(string);
            return n3 == null ? -1 : Integer.parseInt(n3.toString());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getKeyColumnIndex(DataModel dataModel) {
        int n2 = this.getKeyColumnIndex();
        if (n2 == -1) {
            n2 = this.getDataModelColumnIndex(dataModel, this.getKeyColumnName());
        }
        return n2;
    }

    public int getValueColumnIndex(DataModel dataModel) {
        int n2 = this.getValueColumnIndex();
        if (n2 == -1) {
            n2 = this.getDataModelColumnIndex(dataModel, this.getValueColumnName());
        }
        return n2;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
    }

    public void reset() {
        this.kvs = null;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "FormulaDictAttr".equals(string = xMLableReader.getTagName())) {
            this.setKeyColumnIndex(xMLableReader.getAttrAsInt("ki", -1));
            this.setValueColumnIndex(xMLableReader.getAttrAsInt("vi", -1));
            this.setKeyColumnName(xMLableReader.getAttrAsString("kiName", ""));
            this.setValueColumnName(xMLableReader.getAttrAsString("viName", ""));
            String string2 = xMLableReader.getAttrAsString("formula", null);
            if (string2 != null) {
                FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
                formulaProvider.setContent(string2);
                this.setFormula(formulaProvider);
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && "Condition".equals(xMLableReader.getTagName())) {
                        FormulaDisplayDictionary.this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2 = this.getKeyColumnIndex();
        String string = this.getKeyColumnName();
        int n3 = this.getValueColumnIndex();
        String string2 = this.getValueColumnName();
        if (StringUtils.isNotEmpty(string)) {
            xMLPrintWriter.startTAG("FormulaDictAttr").attr("kiName", string);
        } else {
            xMLPrintWriter.startTAG("FormulaDictAttr").attr("ki", n2);
        }
        if (this.formula != null) {
            xMLPrintWriter.attr("formula", this.getFormula().getContent());
        } else if (StringUtils.isNotEmpty(string2)) {
            xMLPrintWriter.attr("viName", string2);
        } else {
            xMLPrintWriter.attr("vi", n3);
        }
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FormulaDisplayDictionary)) {
            return false;
        }
        return this.getKeyColumnIndex() == ((FormulaDisplayDictionary)object).getKeyColumnIndex() && this.getValueColumnIndex() == ((FormulaDisplayDictionary)object).getValueColumnIndex() && ComparatorUtils.equals(this.formula, ((FormulaDisplayDictionary)object).getFormula()) && this.keyColumnIndex == ((FormulaDisplayDictionary)object).keyColumnIndex && this.valueColumnIndex == ((FormulaDisplayDictionary)object).valueColumnIndex && this.keyColumnName == ((FormulaDisplayDictionary)object).keyColumnName && this.valueColumnName == ((FormulaDisplayDictionary)object).valueColumnName && ComparatorUtils.equals(this.condition, ((FormulaDisplayDictionary)object).condition);
    }

    public String toString() {
        return "formula:" + this.formula.getContent();
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaDisplayDictionary formulaDisplayDictionary = (FormulaDisplayDictionary)super.clone();
        if (this.condition != null) {
            formulaDisplayDictionary.condition = (Condition)this.condition.clone();
        }
        return formulaDisplayDictionary;
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < FormulaDisplayDictionary.this.kvs.size();
        }

        public Object next() {
            Object e2 = FormulaDisplayDictionary.this.kvs.get(this.next);
            ++this.next;
            return e2;
        }

        public void remove() {
        }
    }
}

