/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TableData;
import com.fr.data.AbstractDataModel;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.impl.storeproc.MemCachedProcedureDataModel;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.Mapper;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EmbeddedTableData
extends AbstractParameterTableData
implements XMLable {
    private List columnNameList = new ArrayList();
    private List columnClassList = new ArrayList();
    private List rowData = new ArrayList();
    private String dsName = "";
    private static final long serialVersionUID = 2974039836068979294L;
    private transient DataModel dataModel = null;
    private static final Mapper CLASS2NAME = new Mapper(){

        public Object map(int n2, Object object, List list) {
            return object instanceof Class ? ((Class)object).getName() : null;
        }
    };

    public void addColumn(String string, Class clazz) {
        this.columnNameList.add(string);
        this.columnClassList.add(clazz);
        for (int i2 = 0; i2 < this.rowData.size(); ++i2) {
            List list = (List)this.rowData.get(i2);
            list.add(this.getDefaultValueOfClass(clazz));
        }
    }

    public List getRowData() {
        return this.rowData;
    }

    public void insertColumn(String string, Class clazz, int n2) {
        this.columnNameList.add(n2 + 1, string);
        this.columnClassList.add(n2 + 1, clazz);
        for (int i2 = 0; i2 < this.rowData.size(); ++i2) {
            List list = (List)this.rowData.get(i2);
            list.add(n2 + 1, this.getDefaultValueOfClass(clazz));
        }
    }

    public void setColumn(int n2, String string, Class clazz) {
        if (n2 < 0 || n2 >= this.columnNameList.size()) {
            return;
        }
        this.columnNameList.set(n2, string);
        this.columnClassList.set(n2, clazz);
        for (int i2 = 0; i2 < this.rowData.size(); ++i2) {
            List list = (List)this.rowData.get(i2);
            Object e2 = list.get(n2);
            if (e2 == null) continue;
            list.set(n2, this.getValueOfClass(e2, clazz));
        }
    }

    public void removeColumn(int n2) {
        if (n2 < 0 || n2 >= this.columnNameList.size()) {
            return;
        }
        this.columnNameList.remove(n2);
        this.columnClassList.remove(n2);
        int n3 = this.rowData.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            List list = (List)this.rowData.get(i2);
            list.remove(n2);
        }
    }

    public void addRow(List list) {
        this.addRow(this.getRowCount(), list);
    }

    public void addRow(int n2, List list) {
        int n3 = this.getColumnCount();
        if (list.size() < n3) {
            for (int i2 = list.size(); i2 < n3; ++i2) {
                list.add(this.getDefaultValueOfClass(this.getColumnClass(i2)));
            }
        }
        if (n2 >= this.rowData.size()) {
            this.rowData.add(list);
        } else {
            this.rowData.add(n2, list);
        }
    }

    public void addRow(int n2, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        this.addRow(n2, arrayList);
    }

    public void addNewRow(int n2) {
        int n3 = this.getColumnCount();
        if (n3 <= 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(this.getDefaultValueOfClass(this.getColumnClass(i2)));
        }
        this.addRow(n2, arrayList);
    }

    public void removeRow(int n2) {
        if (n2 < 0 || n2 >= this.rowData.size()) {
            return;
        }
        this.rowData.remove(n2);
    }

    public int getColumnCount() {
        return this.columnNameList.size();
    }

    public ProcedureDataModel trans2ProcedureDataModel() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i2 = 0; i2 < this.rowData.size(); ++i2) {
            List list = (List)this.rowData.get(i2);
            Object[] objectArray = new Object[list.size()];
            arrayList.add(objectArray);
            if (list == null) continue;
            for (int i3 = 0; i3 < list.size(); ++i3) {
                objectArray[i3] = list.get(i3);
            }
        }
        String[] stringArray = new String[this.columnNameList.size()];
        for (int i4 = 0; i4 < this.columnNameList.size(); ++i4) {
            stringArray[i4] = (String)this.columnNameList.get(i4);
        }
        return new MemCachedProcedureDataModel(arrayList, stringArray, this.dsName);
    }

    public String getColumnName(int n2) {
        return (String)this.columnNameList.get(n2);
    }

    public Class getColumnClass(int n2) {
        if (n2 >= 0 && n2 < this.columnClassList.size()) {
            return (Class)this.columnClassList.get(n2);
        }
        return String.class;
    }

    public int getRowCount() {
        return this.rowData.size();
    }

    public Object getValueAt(int n2, int n3) {
        List list = (List)this.rowData.get(n2);
        if (n3 < 0 || n3 >= list.size()) {
            return null;
        }
        Object e2 = list.get(n3);
        if (e2 == null) {
            return Primitive.NULL;
        }
        return e2;
    }

    public Object getValueOfClass(Object object, Class clazz) {
        if (object == null) {
            return Primitive.NULL;
        }
        if (object.getClass() == clazz) {
            return object;
        }
        String string = object.toString();
        try {
            if (clazz == Integer.class) {
                Float f2 = Float.valueOf(string);
                return new Integer(Math.round(f2.floatValue()));
            }
            if (clazz == Double.class || clazz == Float.class) {
                return new Double(string);
            }
            if (clazz == java.util.Date.class) {
                return new java.util.Date(Long.parseLong(string));
            }
            if (clazz == Boolean.class) {
                return Boolean.valueOf(string);
            }
            if (clazz == Image.class) {
                return "Image";
            }
            return string;
        }
        catch (Exception exception) {
            return this.getDefaultValueOfClass(clazz);
        }
    }

    public void setValueAt(Object object, int n2, int n3) {
        boolean bl;
        boolean bl2 = n3 < 0 || n3 >= this.getColumnCount();
        boolean bl3 = bl = n2 < 0 || n2 >= this.getRowCount();
        if (bl2 || bl) {
            return;
        }
        ArrayList<Object> arrayList = (ArrayList<Object>)this.rowData.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (arrayList.size() <= n3 || arrayList.get(n3) == null) {
            for (int i2 = arrayList.size(); i2 < n3; ++i2) {
                arrayList.add(i2, "");
            }
            arrayList.add(n3, object);
        } else {
            arrayList.set(n3, object);
        }
    }

    public String toString() {
        return "EmbeddedTableData[ColumnCount:" + this.getColumnCount() + ",RowCount" + this.getRowCount() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        EmbeddedTableData embeddedTableData = (EmbeddedTableData)super.clone();
        embeddedTableData.columnNameList = arrayList3 = new ArrayList();
        for (int i2 = 0; i2 < this.columnNameList.size(); ++i2) {
            arrayList3.add(this.columnNameList.get(i2));
        }
        embeddedTableData.columnClassList = arrayList2 = new ArrayList();
        for (int i3 = 0; i3 < this.columnClassList.size(); ++i3) {
            arrayList2.add(this.columnClassList.get(i3));
        }
        embeddedTableData.rowData = arrayList = new ArrayList();
        for (int i4 = 0; i4 < this.rowData.size(); ++i4) {
            ArrayList arrayList4 = new ArrayList();
            arrayList.add(arrayList4);
            List list = (List)this.rowData.get(i4);
            if (list == null) continue;
            for (int i5 = 0; i5 < list.size(); ++i5) {
                arrayList4.add(list.get(i5));
            }
        }
        return embeddedTableData;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.columnClassList = new ArrayList();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("DSName".equals(string)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.dsName = string3;
                }
            } else if ("ColumnNames".equals(string)) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.columnNameList.clear();
                    String[] stringArray = StableUtils.splitString(string4, ",,.,,");
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        this.columnNameList.add(stringArray[i2]);
                    }
                }
            } else if ("ColumnTypes".equals(string)) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    String[] stringArray = StableUtils.splitString(string5, ",");
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        try {
                            this.columnClassList.add(GeneralUtils.classForName(stringArray[i3]));
                            continue;
                        }
                        catch (Exception exception) {
                            this.columnClassList.add(String.class);
                        }
                    }
                }
            } else if ("RowData".equals(string)) {
                this.readRowData(xMLableReader);
            }
        }
    }

    public void readRowData(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.getXMLVersion().isAfterEM_CODE_XML_VERSION()) {
            try {
                string = new String(GeneralXMLTools.readByteArray(xMLableReader), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        } else {
            string = new String(GeneralXMLTools.readByteArray(xMLableReader));
        }
        if (this.columnClassList.size() <= 0 || string == null) {
            return;
        }
        this.rowData.clear();
        String[] stringArray = StableUtils.splitString(string, '\n');
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = StableUtils.splitString(stringArray[i2], '\t');
            ArrayList arrayList = new ArrayList();
            this.rowData.add(arrayList);
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                String string2 = StableUtils.replaceAllString(stringArray2[i3], new String[]{"&t;", "&n;"}, new String[]{"\t", "\n"});
                Class clazz = (Class)this.columnClassList.get(i3);
                this.readDataDetails(arrayList, string2, clazz);
            }
        }
    }

    private void readDataDetails(List list, String string, Class clazz) {
        if (ComparatorUtils.equals(Double.class, clazz)) {
            try {
                list.add(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                list.add(new Double(0.0));
            }
        } else if (ComparatorUtils.equals(Integer.class, clazz)) {
            try {
                list.add(Integer.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                list.add(new Integer(0));
            }
        } else if (ComparatorUtils.equals(BigDecimal.class, clazz)) {
            try {
                list.add(new BigDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                list.add(string);
            }
        } else if (ComparatorUtils.equals(Boolean.class, clazz)) {
            list.add(Boolean.valueOf(string));
        } else if (ComparatorUtils.equals(Image.class, clazz)) {
            this.readClass(string, list);
        } else if (ComparatorUtils.equals(java.util.Date.class, clazz)) {
            list.add(DateUtils.object2Date(string, false));
        } else {
            list.add(string);
        }
    }

    private void readClass(String string, List list) {
        String[] stringArray = StableUtils.splitString(string, ",;,");
        if (stringArray.length == 3) {
            try {
                list.add(GeneralXMLTools.deprecatedDecodeImage(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringArray[2].getBytes()));
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else if (stringArray.length == 1) {
            list.add(GeneralXMLTools.imageDecode(stringArray[2].getBytes()));
        } else {
            FRLogger.getLogger().error("Error to load embbed image object");
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DSName").textNode(this.dsName).end();
        xMLPrintWriter.startTAG("ColumnNames").textNode(StableUtils.join(this.columnNameList, ",,.,,")).end();
        xMLPrintWriter.startTAG("ColumnTypes").textNode(StableUtils.join(StableUtils.map(this.columnClassList, CLASS2NAME), ",")).end();
        if (this.rowData.size() <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.writeAllData(stringBuffer);
        xMLPrintWriter.startTAG("RowData");
        try {
            GeneralXMLTools.writeByteArray(xMLPrintWriter, stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        xMLPrintWriter.end();
    }

    private void writeAllData(StringBuffer stringBuffer) {
        for (int i2 = 0; i2 < this.rowData.size(); ++i2) {
            if (i2 != 0) {
                stringBuffer.append('\n');
            }
            List list = (List)this.rowData.get(i2);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Object object;
                Object e2;
                if (i3 != 0) {
                    stringBuffer.append('\t');
                }
                if ((e2 = list.get(i3)) == null) {
                    stringBuffer.append("");
                    continue;
                }
                Class clazz = (Class)this.columnClassList.get(i3);
                if (clazz == Integer.class || clazz == Double.class || clazz == Float.class || clazz == BigDecimal.class || clazz == Boolean.class) {
                    stringBuffer.append(GeneralUtils.objectToString(e2));
                    continue;
                }
                if (clazz == java.util.Date.class && e2 instanceof java.util.Date) {
                    object = GeneralContext.getDefaultValues();
                    stringBuffer.append(((DefaultValues)object).getDateTimeFormat().format(e2));
                    continue;
                }
                if (clazz == Image.class) {
                    object = (Image)e2;
                    byte[] byArray = GeneralXMLTools.imageEncode((Image)object);
                    stringBuffer.append(byArray);
                    continue;
                }
                if (clazz == Timestamp.class) {
                    this.writeTimeType(e2, stringBuffer);
                    continue;
                }
                object = GeneralUtils.objectToString(e2);
                object = CodeUtils.encodeString((String)object, new String[][]{{"&t;", "&n;"}, {"\t", "\n"}});
                stringBuffer.append((String)object);
            }
        }
    }

    private void writeTimeType(Object object, StringBuffer stringBuffer) {
        Timestamp timestamp;
        DefaultValues defaultValues = GeneralContext.getDefaultValues();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (object instanceof String) {
            if (StringUtils.isBlank((String)object)) {
                timestamp = null;
            } else if (((String)object).indexOf(":") == -1) {
                Date date = Date.valueOf((String)object);
                String string = simpleDateFormat.format(date);
                timestamp = Timestamp.valueOf(string);
            } else {
                timestamp = Timestamp.valueOf((String)object);
            }
        } else if (object instanceof java.util.Date) {
            String string = simpleDateFormat.format((java.util.Date)object);
            timestamp = Timestamp.valueOf(string);
        } else {
            timestamp = object instanceof Timestamp ? (Timestamp)object : null;
        }
        if (timestamp != null) {
            stringBuffer.append(defaultValues.getDateTimeFormat().format(new java.util.Date(timestamp.getTime())));
        }
    }

    public static EmbeddedTableData embedify(TableData tableData, Calculator calculator) throws TableDataException {
        return EmbeddedTableData.embedify(tableData, calculator, -1);
    }

    public void clear() {
        this.columnClassList.clear();
        this.columnNameList.clear();
        this.rowData.clear();
    }

    public static EmbeddedTableData embedify(TableData tableData, Calculator calculator, int n2) throws TableDataException {
        EmbeddedTableData embeddedTableData = new EmbeddedTableData();
        if (tableData != null) {
            int n3;
            DataModel dataModel = EmbeddedTableData.createDataModel(tableData, calculator, n2);
            if (!EmbeddedTableData.isValidSQL(dataModel, n2)) {
                dataModel = EmbeddedTableData.createDataModel(tableData, calculator, 1);
            }
            int n4 = dataModel.getColumnCount();
            Class[] classArray = new Class[n4];
            String[] stringArray = new String[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray[n3] = dataModel.getColumnName(n3);
            }
            if (n2 < 0) {
                n2 = dataModel.getRowCount();
            } else if (n2 != 0 && !dataModel.hasRow(n2 - 1)) {
                n2 = dataModel.getRowCount();
            }
            for (n3 = 0; n3 < n2; ++n3) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i2 = 0; i2 < n4; ++i2) {
                    Object object = dataModel.getValueAt(n3, i2);
                    if (classArray[i2] == null && object != null) {
                        classArray[i2] = object.getClass();
                    }
                    arrayList.add(object);
                }
                embeddedTableData.addRow(arrayList);
            }
            embeddedTableData.columnClassList = new ArrayList();
            embeddedTableData.columnClassList.addAll(Arrays.asList(classArray));
            embeddedTableData.columnNameList = new ArrayList();
            embeddedTableData.columnNameList.addAll(Arrays.asList(stringArray));
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                throw new TableDataException(exception.getMessage(), exception);
            }
        }
        return embeddedTableData;
    }

    public void addColumnNameAndData(String[] stringArray, List list, String string) {
        ArrayList arrayList;
        this.dsName = string;
        this.columnNameList = new ArrayList();
        this.columnNameList.addAll(Arrays.asList(stringArray));
        this.rowData = arrayList = new ArrayList();
        boolean bl = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList.add(arrayList2);
            Object[] objectArray = (Object[])list.get(i2);
            if (objectArray == null) continue;
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                Object object = objectArray[i3];
                arrayList2.add(object);
                if (bl) continue;
                if (object != null) {
                    this.columnClassList.add(objectArray[i3].getClass());
                    continue;
                }
                this.columnClassList.add("String");
            }
            bl = true;
        }
    }

    private static DataModel createDataModel(TableData tableData, Calculator calculator, int n2) {
        DataModel dataModel = tableData.createDataModel(calculator, n2);
        if (dataModel == null) {
            dataModel = DataModel.EMPTY_DATAMODEL;
        }
        return dataModel;
    }

    private static boolean isValidSQL(DataModel dataModel, int n2) {
        if (n2 == 0) {
            try {
                if (dataModel == null) {
                    return false;
                }
                dataModel.getColumnCount();
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof EmbeddedTableData && ComparatorUtils.equals(this.columnClassList, ((EmbeddedTableData)object).columnClassList) && ComparatorUtils.equals(this.columnNameList, ((EmbeddedTableData)object).columnNameList) && ComparatorUtils.equals(this.rowData, ((EmbeddedTableData)object).rowData);
    }

    public DataModel createDataModel(Calculator calculator) {
        if (this.dataModel == null) {
            this.dataModel = new EmbeddedTDDataModel();
        }
        return this.dataModel;
    }

    private Object getDefaultValueOfClass(Class clazz) {
        if (clazz == Integer.class) {
            return new Integer(0);
        }
        if (clazz == Double.class || clazz == Float.class) {
            return new Double(0.0);
        }
        if (clazz == java.util.Date.class) {
            return new java.util.Date();
        }
        if (clazz == Boolean.class) {
            return Boolean.TRUE;
        }
        if (clazz == Image.class) {
            return "Image";
        }
        return "";
    }

    public class EmbeddedTDDataModel
    extends AbstractDataModel {
        public int getColumnCount() throws TableDataException {
            return EmbeddedTableData.this.getColumnCount();
        }

        public Class getColumnClass(int n2) {
            return EmbeddedTableData.this.getColumnClass(n2);
        }

        public String getColumnName(int n2) throws TableDataException {
            return EmbeddedTableData.this.getColumnName(n2);
        }

        public int getRowCount() throws TableDataException {
            return EmbeddedTableData.this.getRowCount();
        }

        public Object getValueAt(int n2, int n3) throws TableDataException {
            return EmbeddedTableData.this.getValueAt(n2, n3);
        }

        public void release() throws Exception {
        }
    }
}

