/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.cache.list.IntList;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;

public class DecoratedDataModel
implements DataModel {
    public static final String NAME_OF_SOURCE_TABLEDATA = "NAME_OF_SOURCE_TABLEDATA";
    private SOURCE_KNOWABLE_DATA_MODEL[] sourceDataModels;
    private int[][] rowIndicesSurvived;
    private Condition condition;
    private Calculator calculatorContext;

    public DecoratedDataModel(DataModel[] dataModelArray, String[] stringArray, Condition condition, Calculator calculator) {
        this.sourceDataModels = new SOURCE_KNOWABLE_DATA_MODEL[dataModelArray.length];
        for (int i2 = 0; i2 < this.sourceDataModels.length; ++i2) {
            this.sourceDataModels[i2] = new SOURCE_KNOWABLE_DATA_MODEL(dataModelArray[i2], stringArray[i2]);
        }
        this.condition = condition;
        this.calculatorContext = calculator;
        this.rowIndicesSurvived = new int[this.sourceDataModels.length][];
    }

    public int getColumnCount() throws TableDataException {
        if (this.sourceDataModels.length > 0) {
            return this.sourceDataModels[0].getColumnCount();
        }
        return 0;
    }

    public String getColumnName(int n2) throws TableDataException {
        return this.sourceDataModels[0].getColumnName(n2);
    }

    private void beSureSurvivedRowIndicesCalculatedByModelIndex(int n2) throws TableDataException {
        if (this.rowIndicesSurvived[n2] == null) {
            this.rowIndicesSurvived[n2] = this.sourceDataModels[n2].survivedRowIndices();
        }
    }

    public boolean hasRow(int n2) throws TableDataException {
        int n3 = 0;
        while (n3 < this.rowIndicesSurvived.length) {
            this.beSureSurvivedRowIndicesCalculatedByModelIndex(n3);
            if (this.rowIndicesSurvived[n3].length > n2) continue;
            n2 -= this.rowIndicesSurvived[n3].length;
            ++n3;
        }
        return n3 < this.sourceDataModels.length;
    }

    public int getRowCount() throws TableDataException {
        int n2 = 0;
        for (int i2 = 0; i2 < this.rowIndicesSurvived.length; ++i2) {
            this.beSureSurvivedRowIndicesCalculatedByModelIndex(i2);
            n2 += this.rowIndicesSurvived[i2].length;
        }
        return n2;
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        int n4;
        for (n4 = 0; n4 < this.rowIndicesSurvived.length; ++n4) {
            this.beSureSurvivedRowIndicesCalculatedByModelIndex(n4);
            if (this.rowIndicesSurvived[n4].length > n2) break;
            n2 -= this.rowIndicesSurvived[n4].length;
        }
        if (n4 < this.sourceDataModels.length) {
            return this.sourceDataModels[n4].getValueAt(this.rowIndicesSurvived[n4][n2], n3);
        }
        return null;
    }

    public void release() throws Exception {
        int n2 = ArrayUtils.getLength(this.sourceDataModels);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sourceDataModels[i2].release();
        }
    }

    private class SOURCE_KNOWABLE_DATA_MODEL
    implements DataModel {
        private String sourceName;
        private DataModel original;

        public SOURCE_KNOWABLE_DATA_MODEL(DataModel dataModel, String string) {
            this.original = dataModel;
            this.sourceName = string;
        }

        private int[] survivedRowIndices() throws TableDataException {
            if (DecoratedDataModel.this.condition == null) {
                return IntList.range(this.getRowCount());
            }
            return DecoratedDataModel.this.condition.evalTableData(this, null, 0, DecoratedDataModel.this.calculatorContext);
        }

        public int getColumnCount() throws TableDataException {
            return 1 + this.original.getColumnCount();
        }

        public String getColumnName(int n2) throws TableDataException {
            if (n2 == 0) {
                return DecoratedDataModel.NAME_OF_SOURCE_TABLEDATA;
            }
            return this.original.getColumnName(n2 - 1);
        }

        public boolean hasRow(int n2) throws TableDataException {
            return this.original.hasRow(n2);
        }

        public int getRowCount() throws TableDataException {
            return this.original.getRowCount();
        }

        public Object getValueAt(int n2, int n3) throws TableDataException {
            if (n3 == 0) {
                return this.sourceName;
            }
            return this.original.getValueAt(n2, n3 - 1);
        }

        public void release() throws Exception {
            this.original.release();
        }
    }
}

