/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.DataModelCreator;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.SynchronizedLiveDataModelUtils;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DiskCacheDBDataModel;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.MemCachedDBDataModel;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.VT4FR;
import com.fr.general.data.DataModel;
import com.fr.general.sql.SqlUtils;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.allocation.AuthorityAllocation;
import com.fr.privilege.base.PrivilegeFilter;
import com.fr.privilege.filter.AuthorityControlFilter;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.dao.DaoAuthenticationProvider;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;

public class DBTableData
extends AbstractParameterTableData
implements XMLable {
    private static final String ACCESS_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static boolean shareAvailable = true;
    private Connection database;
    private String query;
    private boolean share = false;
    private int maxMemRowCount = -1;
    private String pageQuerySql = null;

    public DBTableData() {
        this(ACCESS_DRIVER, "", "", "", "");
    }

    public DBTableData(String string, String string2, String string3, String string4, String string5) {
        this(new JDBCDatabaseConnection(string, string2, string3, string4), string5);
    }

    public DBTableData(Connection connection, String string) {
        this.setDatabase(connection);
        this.setQuery(string);
    }

    public Connection getDatabase() {
        return this.database;
    }

    public void setDatabase(Connection connection) {
        this.database = connection;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPageQuerySql() {
        return this.pageQuerySql;
    }

    public void setPageQuerySql(String string) {
        this.pageQuerySql = string;
    }

    public int getMaxMemRowCount() {
        return this.maxMemRowCount;
    }

    public void setMaxMemRowCount(int n2) {
        this.maxMemRowCount = n2;
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean isShareTableData() {
        return shareAvailable && this.share;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public DataModel createDataModel(Calculator calculator) {
        return this.createDataModel(calculator, 1);
    }

    public DataModel createDataModel(Calculator calculator, int n2) {
        DataModelCreator dataModelCreator;
        String string;
        Parameter[] parameterArray = this.processParameters(calculator);
        String string2 = string = this.getNewQuery(parameterArray);
        if (n2 == 0 && !ComparatorUtils.equals(this.getDatabase().getDriver(), ACCESS_DRIVER)) {
            string2 = SqlUtils.tryConvertToNoRecord(string);
        }
        DataModel dataModel = (dataModelCreator = SynchronizedLiveDataModelUtils.getSheetExecuter()) != null ? dataModelCreator.createDBDataModel(this, string2) : SynchronizedLiveDataModelUtils.createDefaultDBDataModel(this, string2);
        return dataModel;
    }

    private boolean checkPrivilege(Calculator calculator) {
        String[] stringArray = PrivilegeManager.getRoleFromCalculator(calculator);
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        PrivilegeFilter privilegeFilter = privilegeManager.getPrivilegeFilter();
        if (authenticationProvider instanceof DaoAuthenticationProvider && privilegeFilter instanceof AuthorityControlFilter && this.database instanceof NameDatabaseConnection) {
            String string = ((NameDatabaseConnection)this.database).getName();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                AuthorityAllocation authorityAllocation = ((AuthorityControlFilter)privilegeFilter).getAuthorityAllocation(stringArray[i2]);
                if (authorityAllocation == null) {
                    return true;
                }
                HashSet<String> hashSet = authorityAllocation.getAllocation().getDSPrivilege();
                if (hashSet.contains(string)) continue;
                return false;
            }
        }
        return true;
    }

    public static AbstractDBDataModel createCacheableDBResultSet(Connection connection, String string, long l2) {
        AbstractDBDataModel abstractDBDataModel = new DiskCacheDBDataModel(connection, string);
        if (l2 < 0L) {
            abstractDBDataModel = new MemCachedDBDataModel(connection, string);
        } else {
            int n2 = abstractDBDataModel.shortcutGetRowCount();
            if (n2 >= 0 && (long)n2 < l2) {
                abstractDBDataModel = new MemCachedDBDataModel(connection, string);
            }
        }
        return abstractDBDataModel;
    }

    protected Parameter[] processParameters(Calculator calculator) {
        if (this.parameters == null || ComparatorUtils.equals(this.parameters, new Parameter[0])) {
            this.parameters = ParameterHelper.analyze4Parameters(this.getQuery(), false);
        }
        return Parameter.providers2Parameter(Calculator.processParameters(calculator, this.parameters));
    }

    protected String getNewQuery(Parameter[] parameterArray) {
        return ParameterHelper.analyzeCurrentContextTableData4Templatee(this.getQuery(), parameterArray);
    }

    public void setParameters(ParameterProvider[] parameterProviderArray) {
        this.parameters = parameterProviderArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("Attributes".equals(string2)) {
                this.setShare(xMLableReader.getAttrAsBoolean("share", false));
                this.setMaxMemRowCount(xMLableReader.getAttrAsInt("maxMemRowCount", -1));
            } else if ("Connection".equals(string2) || "Database".equals(string2)) {
                if (xMLableReader.getAttrAsString("class", null) != null) {
                    Connection connection = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                    this.setDatabase(connection);
                }
            } else if ("Query".equals(string2)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setQuery(string3);
                }
            } else if ("PageQuery".equals(string2) && (string = xMLableReader.getElementValue()) != null) {
                this.setPageQuerySql(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attributes");
        if (this.share) {
            xMLPrintWriter.attr("share", this.share);
        }
        xMLPrintWriter.attr("maxMemRowCount", this.getMaxMemRowCount()).end();
        if (this.database != null) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
        xMLPrintWriter.startTAG("Query").textNode(this.getQuery()).end();
        if (this.pageQuerySql != null) {
            xMLPrintWriter.startTAG("PageQuery").textNode(this.pageQuerySql).end();
        }
    }

    public String toString() {
        return this.database + "[Query:" + this.getQuery() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        DBTableData dBTableData = (DBTableData)super.clone();
        dBTableData.setDatabase(this.getDatabase());
        dBTableData.setQuery(this.getQuery());
        dBTableData.setMaxMemRowCount(this.getMaxMemRowCount());
        dBTableData.setPageQuerySql(this.getPageQuerySql());
        return dBTableData;
    }

    public boolean equals(Object object) {
        return object instanceof DBTableData && super.equals(object) && ComparatorUtils.equals(this.query, ((DBTableData)object).query) && ComparatorUtils.equals(this.database, ((DBTableData)object).database) && this.maxMemRowCount == ((DBTableData)object).maxMemRowCount && ComparatorUtils.equals(this.pageQuerySql, ((DBTableData)object).pageQuerySql);
    }

    static {
        shareAvailable = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.PERFORMCE_OPTIMISE.support();
    }
}

