/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.AbstractDict;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;

public class CustomDictionary
extends AbstractDict {
    protected Object[] keys;
    protected Object[] values;

    public CustomDictionary() {
        this.keys = new Object[0];
        this.values = new Object[0];
    }

    public CustomDictionary(Object[] objectArray, Object[] objectArray2) {
        this.setKV(objectArray, objectArray2);
    }

    public void setKV(Object[] objectArray, Object[] objectArray2) {
        if (ArrayUtils.isSameLength(objectArray, objectArray2)) {
            this.keys = objectArray;
            this.values = objectArray2;
        }
    }

    public int size() {
        return this.keys.length;
    }

    public Object[] keys() {
        return this.keys;
    }

    public Object[] values() {
        return this.values;
    }

    public Object getKey(int n2) {
        return this.keys[n2];
    }

    public Object getValue(int n2) {
        return this.values[n2];
    }

    public Object get(Object object, Calculator calculator) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(this.keys[i2], object)) continue;
            return this.values[i2];
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof CustomDictionary && super.equals(object) && ComparatorUtils.equals(((CustomDictionary)object).keys, this.keys) && ComparatorUtils.equals(((CustomDictionary)object).values, this.values);
    }

    public Iterator entrys(Calculator calculator) {
        return new EntryIterator();
    }

    public Iterator entrys(Calculator calculator, int n2, int n3) {
        return this.entrys(calculator);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("CustomDictAttr".equals(string) || "CustomMapAttr".equals(string)) {
                final ArrayList arrayList = new ArrayList();
                final ArrayList arrayList2 = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ("Dict".equals(string = xMLableReader.getTagName()) || "CustomMap".equals(string))) {
                            arrayList.add(DataCoreUtils.readDictObject(xMLableReader.getAttrAsString("key", null)));
                            arrayList2.add(DataCoreUtils.readDictObject(xMLableReader.getAttrAsString("value", null)));
                        }
                    }
                });
                this.keys = arrayList.toArray();
                this.values = arrayList2.toArray();
            } else if ("Condition".equals(string)) {
                Condition condition = DataCoreXmlUtils.readCondition(xMLableReader);
                this.setCondition(condition);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CustomDictAttr");
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("Dict").attr("key", DataCoreUtils.writeDictObject(this.keys[i2])).attr("value", DataCoreUtils.writeDictObject(this.values[i2])).end();
        }
        xMLPrintWriter.end();
        if (this.condition != null) {
            DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
    }

    public String toString() {
        return "CustomDict[DictSize:" + this.size() + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static CustomDictionary customify(Dictionary dictionary) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (dictionary != null) {
            Iterator iterator = dictionary.entrys(Calculator.createCalculator());
            while (iterator.hasNext()) {
                Dictionary.MV mV = (Dictionary.MV)iterator.next();
                arrayList.add(mV.getModel());
                arrayList2.add(mV.getView());
            }
        }
        return new CustomDictionary(arrayList.toArray(), arrayList2.toArray());
    }

    private class EntryIterator
    implements Iterator {
        private int next = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.next < CustomDictionary.this.size();
        }

        public Object next() {
            Dictionary.MV mV = new Dictionary.MV(CustomDictionary.this.keys[this.next], CustomDictionary.this.values[this.next]);
            ++this.next;
            return mV;
        }

        public void remove() {
        }
    }
}

