/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.TarRowIndexIterateResultSetListener;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.TableDataException;
import java.sql.ResultSet;
import java.sql.Statement;

public abstract class AbstractLayerDBDataModel
extends AbstractDBDataModel {
    private String rowCountQuery = null;
    private transient Object[] currentRowValue = null;
    private transient int currentRowIndex = -1;
    private LayerIterateResultSetListener iListener = new LayerIterateResultSetListener();

    public AbstractLayerDBDataModel(Connection connection, String string) {
        super(connection, string);
    }

    protected void initRowValueStatus() {
        this.currentRowIndex = -1;
        this.currentRowValue = null;
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        return this.hasRow(n2) ? this.currentRowValue[n3] : null;
    }

    public int getRowCount() throws TableDataException {
        return this.shortcutGetRowCount();
    }

    protected abstract int hasRow_rowIndex2Get(int var1);

    protected boolean hasRow_3rd_condition(int n2) {
        return n2 < this.currentRowIndex;
    }

    protected abstract void hasRow_3rd_condition_action(int var1) throws TableDataException;

    protected abstract boolean hasRow_isLastRow(int var1);

    protected abstract void hasRow_after_iterate_resultset(int var1);

    public boolean hasRow(int n2) throws TableDataException {
        int n3 = this.hasRow_rowIndex2Get(n2);
        if (n2 < 0) {
            return false;
        }
        if (n3 == this.currentRowIndex) {
            return true;
        }
        if (this.hasRow_3rd_condition(n3)) {
            this.hasRow_3rd_condition_action(n2);
        } else if (this.isCheckRowOver()) {
            return false;
        }
        try {
            this.iterateResultSet(this.iListener);
        }
        catch (Exception exception) {
            this.dealWithException(exception, n2);
        }
        return this.iListener.returnValue;
    }

    protected int shortcutGetRowCount() {
        if (this.shortcutRowCount == -1) {
            long l2 = System.currentTimeMillis();
            String string = this.rowCountQuery;
            if (string == null && DBUtils.isProcedure(this.sql)) {
                this.shortcutRowCount = Integer.MIN_VALUE;
                FRLogger.getLogger().error(Inter.getLocText("DBTableData_Not_Get_RowCount"));
                throw new RuntimeException(Inter.getLocText("DBTableData_Not_Get_RowCount"));
            }
            java.sql.Connection connection = null;
            try {
                connection = this.database.createConnection();
                if (this.dialect == null) {
                    this.dialect = DialectFactory.generateDialect(connection);
                }
                if (string == null) {
                    string = this.dialect.getCountSql(this.sql);
                }
                FRLogger.getLogger().info("RowCount SQL:\n" + string);
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                resultSet.next();
                this.shortcutRowCount = resultSet.getInt(1);
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                this.shortcutRowCount = Integer.MIN_VALUE;
                FRLogger.getLogger().error(exception.getMessage(), exception);
                throw new RuntimeException(exception.getMessage());
            }
            finally {
                DBUtils.closeConnection(connection);
            }
            long l3 = System.currentTimeMillis();
            FRLogger.getLogger().info("RowCount costs " + (l3 - l2) / 1000L + " s.");
        }
        return this.shortcutRowCount;
    }

    protected void dealWithException(Exception exception, int n2) throws TableDataException {
        try {
            this.releaseConnection();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        this.setCheckRowOverState(true);
        throw new TableDataException(new StringBuffer().append(exception.getMessage()).append("\nQuery is:").append(this.sql).append("\nrowIndex to get is:").append(n2).toString(), exception);
    }

    static /* synthetic */ Object[] access$102(AbstractLayerDBDataModel abstractLayerDBDataModel, Object[] objectArray) {
        abstractLayerDBDataModel.currentRowValue = objectArray;
        return objectArray;
    }

    private class LayerIterateResultSetListener
    extends TarRowIndexIterateResultSetListener {
        private boolean returnValue;

        private LayerIterateResultSetListener() {
        }

        protected void init() {
            this.returnValue = false;
        }

        protected boolean beforeGetValuesbyRowIndex(int n2) {
            boolean bl;
            AbstractLayerDBDataModel.this.currentRowIndex++;
            boolean bl2 = bl = AbstractLayerDBDataModel.this.currentRowIndex >= this.getTarRowIndex();
            if (bl) {
                AbstractLayerDBDataModel.access$102(AbstractLayerDBDataModel.this, new Object[n2]);
            }
            return bl;
        }

        protected void afterGetValueByColumnRowIndex(Object object, int n2) throws TableDataException {
            ((AbstractLayerDBDataModel)AbstractLayerDBDataModel.this).currentRowValue[n2] = object;
        }

        protected void exceptionOnGetValueByColumnRowIndex(int n2) {
            ((AbstractLayerDBDataModel)AbstractLayerDBDataModel.this).currentRowValue[n2] = null;
        }

        protected boolean afterGetValuesByRowIndex() throws TableDataException {
            this.returnValue = true;
            return true;
        }

        protected void afterIterator() {
            if (!this.returnValue) {
                AbstractLayerDBDataModel.this.hasRow_after_iterate_resultset(AbstractLayerDBDataModel.this.currentRowIndex);
            }
        }

        protected boolean checkLastAndBreak() {
            if (AbstractLayerDBDataModel.this.hasRow_isLastRow(AbstractLayerDBDataModel.this.currentRowIndex)) {
                this.returnValue = true;
                return true;
            }
            return false;
        }
    }
}

