/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.AbstractDataModel;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.MSSQLDialect;
import com.fr.data.core.db.dialect.MySQLDialect;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.data.impl.Connection;
import com.fr.data.impl.GroupColumnMap;
import com.fr.data.impl.GroupList;
import com.fr.data.impl.Grouper;
import com.fr.data.impl.IterateResultSetListener;
import com.fr.data.impl.SharedDBDataModel;
import com.fr.general.DateUtils;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.TableDataException;
import com.fr.stable.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDBDataModel
extends AbstractDataModel {
    protected Set registedDBTableData = new HashSet();
    protected Connection database;
    protected String sql;
    protected transient java.sql.Connection connection;
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    private transient boolean isCheckRowOver = false;
    protected transient ColumnInformation[] columnInformations = null;
    protected transient Dialect dialect = null;
    protected transient int shortcutRowCount = -1;

    protected AbstractDBDataModel() {
        this(null, null);
    }

    protected AbstractDBDataModel(Connection connection, String string) {
        this.database = connection;
        this.sql = string;
        this.dealSQLCharset();
    }

    private void dealSQLCharset() {
        if (StringUtils.isNotBlank(this.database.getOriginalCharsetName()) && StringUtils.isNotBlank(this.database.getNewCharsetName())) {
            try {
                this.sql = new String(this.sql.getBytes(this.database.getNewCharsetName()), this.database.getOriginalCharsetName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(SharedDBDataModel sharedDBDataModel) {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            this.registedDBTableData.add(sharedDBDataModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unRegister(SharedDBDataModel sharedDBDataModel) {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            this.registedDBTableData.remove(sharedDBDataModel);
        }
    }

    public int getColumnCount() throws TableDataException {
        if (this.columnInformations == null) {
            this.initConnectionAndResultAndCheckInColumns();
        }
        return this.columnInformations.length;
    }

    public String getColumnName(int n2) throws TableDataException {
        if (this.columnInformations == null) {
            this.initConnectionAndResultAndCheckInColumns();
        }
        return this.columnInformations[n2].getColumnName();
    }

    protected void iterateResultSet(IterateResultSetListener iterateResultSetListener) throws Exception {
        int n2;
        int n3;
        iterateResultSetListener.init();
        this.initConnectionAndResultAndCheckInColumns();
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n4 = this.getColumnCount();
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        int[] nArray = new int[n4];
        SQLTypeHandler[] sQLTypeHandlerArray = new SQLTypeHandler[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = n2 = this.columnInformations[n3].getColumnType();
            sQLTypeHandlerArray[n3] = dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(n2));
        }
        n3 = string != null && string.length() > 0 ? 1 : 0;
        n2 = 0;
        while (this.resultSet.next()) {
            ++n2;
            if (!iterateResultSetListener.beforeGetValuesbyRowIndex(n4)) continue;
            for (int i2 = 0; i2 < n4; ++i2) {
                try {
                    iterateResultSetListener.afterGetValueByColumnRowIndex(this.getResultObject(i2 + 1, n2, nArray[i2], sQLTypeHandlerArray[i2], dialect, string, string2, n3 != 0), i2);
                    continue;
                }
                catch (SQLException sQLException) {
                    iterateResultSetListener.exceptionOnGetValueByColumnRowIndex(i2);
                }
            }
            if (iterateResultSetListener.checkLastAndBreak()) break;
            if (!iterateResultSetListener.afterGetValuesByRowIndex()) continue;
            return;
        }
        iterateResultSetListener.afterIterator();
        this.setCheckRowOverState(true);
        this.releaseConnection();
        FRLogManager.declareSQLEnd(this.getSQLInfo());
    }

    private String getSQLInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("[").append(" sql : ").append(this.sql).append(" ;").append(" rowcount : ").append(this.getRowCount()).append(" ;").append(" time : ").append(DateUtils.DATETIMEFORMAT2.format(new Date())).append(" ;").append("]");
        }
        catch (TableDataException tableDataException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private Object getResultObject(int n2, int n3, int n4, SQLTypeHandler sQLTypeHandler, Dialect dialect, String string, String string2, boolean bl) throws Exception {
        return DataCoreUtils.getResultSetObject(this.resultSet, n4, n2, string, string2, dialect, sQLTypeHandler, bl);
    }

    private boolean delayLoadData(int n2, Dialect dialect) {
        return n2 == 2004 && dialect instanceof OracleDialect || n2 == -4 && dialect instanceof MySQLDialect;
    }

    public Object[] iterateResultSet4Group(int[] nArray, int n2, Grouper[] grouperArray) throws Exception {
        boolean bl;
        this.initConnectionAndResultAndCheckInColumns();
        Dialect dialect = DialectFactory.generateDialect(this.connection);
        int n3 = nArray.length;
        String string = this.database.getOriginalCharsetName();
        String string2 = this.database.getNewCharsetName();
        Object[] objectArray = new Object[n3];
        Object[] objectArray2 = new Object[n3];
        SQLTypeHandler[] sQLTypeHandlerArray = new SQLTypeHandler[n3];
        int[] nArray2 = new int[n3];
        this.getColumnTypeAndHandler(sQLTypeHandlerArray, nArray2, nArray, objectArray, n3);
        int n4 = 0;
        boolean bl2 = bl = string != null && string.length() > 0;
        while (this.resultSet.next()) {
            ++n4;
            String string3 = "";
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = null;
                try {
                    object = DataCoreUtils.getResultSetObject(this.resultSet, nArray2[i2], nArray[i2] + 1, string, string2, dialect, sQLTypeHandlerArray[i2], bl);
                }
                catch (SQLException sQLException) {
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        if (nArray[i2] != nArray[i3]) continue;
                        object = objectArray2[i3];
                        break;
                    }
                }
                objectArray2[i2] = object;
                AbstractDBDataModel.dealGroupMode(n4, i2, objectArray, object, string3, grouperArray[i2]);
                if (n2 != -1 && i2 > n2) continue;
                string3 = string3 + object;
            }
        }
        this.setCheckRowOverState(true);
        this.releaseConnection();
        this.calculateAfterGet(n2, n3, objectArray, grouperArray);
        FRLogManager.declareSQLEnd(this.getSQLInfo());
        return objectArray;
    }

    private void getColumnTypeAndHandler(SQLTypeHandler[] sQLTypeHandlerArray, int[] nArray, int[] nArray2, Object[] objectArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            objectArray[i2] = new GroupColumnMap();
            nArray[i2] = n3 = this.columnInformations[nArray2[i2]].getColumnType();
            sQLTypeHandlerArray[i2] = this.dialect.buildSQLTypeHandlerFactory().getTypeHandler(new Integer(n3));
        }
    }

    private void calculateAfterGet(int n2, int n3, Object[] objectArray, Grouper[] grouperArray) {
        for (int i2 = n2 = n2 == -1 ? 0 : n2; i2 < n3; ++i2) {
            GroupColumnMap groupColumnMap = (GroupColumnMap)objectArray[i2];
            Grouper grouper = grouperArray[i2];
            Iterator iterator = groupColumnMap.getIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                GroupList groupList = (GroupList)entry.getValue();
                grouper.cal_after_traverse_result(groupList);
            }
        }
    }

    private static void dealGroupMode(int n2, int n3, Object[] objectArray, Object object, Object object2, Grouper grouper) {
        GroupList groupList;
        GroupColumnMap groupColumnMap = (GroupColumnMap)objectArray[n3];
        if (groupColumnMap == null) {
            groupColumnMap = new GroupColumnMap();
        }
        if ((groupList = groupColumnMap.get(object2)) == null) {
            groupList = new GroupList();
        }
        grouper.cal_when_traverse_result(groupList, object, n2);
        groupColumnMap.put(object2, groupList);
    }

    protected abstract void initRowValueStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConnectionAndResultAndCheckInColumns() throws TableDataException {
        if (this.connection != null) {
            return;
        }
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            try {
                Object object;
                if (this.database == null) {
                    throw new TableDataException(Inter.getLocText("Utils-Connection_can_not_be_null"));
                }
                this.connection = this.database.createConnection();
                if (this.connection == null) {
                    throw new TableDataException(Inter.getLocText("Utils-Can_not_create_connection") + ":" + this.database.toString());
                }
                if (DBUtils.isProcedure(this.sql)) {
                    object = DBUtils.remoteProcedureCall(this.connection, this.sql);
                    this.statement = (Statement)object[0];
                    this.resultSet = (ResultSet)object[1];
                } else {
                    if (this.dialect == null) {
                        this.dialect = DialectFactory.generateDialect(this.connection);
                    }
                    if ((object = DialectFactory.generateDialect(this.connection)) instanceof MSSQLDialect) {
                        this.statement = this.connection.prepareCall(this.sql);
                        this.resultSet = ((CallableStatement)this.statement).executeQuery();
                    } else {
                        this.statement = this.connection.createStatement();
                        if (object.getFetchSize() > 0) {
                            this.statement.setFetchSize(object.getFetchSize());
                        }
                        this.resultSet = this.statement.executeQuery(this.sql);
                    }
                }
                if (this.columnInformations == null) {
                    object = this.database.getOriginalCharsetName();
                    String string = this.database.getNewCharsetName();
                    this.columnInformations = DBUtils.checkInColumnInformationByMetaData(this.resultSet.getMetaData(), (String)object, string);
                }
            }
            catch (Exception exception) {
                try {
                    this.releaseConnection();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new TableDataException("Query:\n" + exception.getMessage(), exception);
            }
            this.initRowValueStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int shortcutGetRowCount() {
        if (this.shortcutRowCount == -1) {
            java.sql.Connection connection = null;
            try {
                connection = this.database.createConnection();
                if (this.dialect == null) {
                    this.dialect = DialectFactory.generateDialect(connection);
                }
                String string = this.dialect.getCountSql(this.sql);
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                resultSet.next();
                this.shortcutRowCount = resultSet.getInt(1);
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                this.shortcutRowCount = Integer.MIN_VALUE;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                    }
                }
            }
        }
        return this.shortcutRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryDestroy() throws SQLException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            if (this.registedDBTableData.isEmpty()) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            this.releaseConnection();
            this.setCheckRowOverState(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection() throws SQLException {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            if (this.connection != null) {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                this.connection.close();
                this.connection = null;
                this.statement = null;
                this.resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        AbstractDBDataModel abstractDBDataModel = this;
        synchronized (abstractDBDataModel) {
            super.finalize();
            this.release();
        }
    }

    public boolean isCheckRowOver() {
        return this.isCheckRowOver;
    }

    protected void setCheckRowOverState(boolean bl) {
        this.isCheckRowOver = bl;
    }
}

