/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.DML;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.dao.JdbcOperator;
import com.fr.data.dao.ResultSetExtractor;
import java.io.Serializable;
import java.sql.Connection;

public class JdbcDaoTemplate {
    private Connection conn;
    private boolean transaction = false;
    private Dialect dialect;

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public void setTransaction(boolean bl) {
        this.transaction = bl;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string) throws Exception {
        this.checkConnectionAndDialect();
        try {
            JdbcOperator.execute(this.conn, string);
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(String string, ResultSetExtractor resultSetExtractor) throws Exception {
        this.checkConnectionAndDialect();
        try {
            Object object = JdbcOperator.query(this.conn, string, resultSetExtractor);
            return object;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeQuery(Select select, ResultSetExtractor resultSetExtractor) throws Exception {
        this.checkConnectionAndDialect();
        try {
            Object object = JdbcOperator.executeQuery(this.conn, this.dialect, select, resultSetExtractor);
            return object;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    public Serializable execute(Insert insert, boolean bl) throws Exception {
        this.checkConnectionAndDialect();
        if (!this.transaction) {
            try {
                boolean bl2 = this.conn.getAutoCommit();
                this.dialect.setAutoCommit(this.conn, false);
                Serializable serializable = JdbcOperator.execute(this.conn, this.dialect, insert, bl);
                this.conn.commit();
                this.dialect.setAutoCommit(this.conn, bl2);
                Serializable serializable2 = serializable;
                return serializable2;
            }
            catch (Exception exception) {
                if (this.conn != null) {
                    try {
                        this.conn.rollback();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                throw exception;
            }
            finally {
                DBUtils.closeConnection(this.conn);
                this.conn = null;
            }
        }
        return JdbcOperator.execute(this.conn, this.dialect, insert, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DML dML) throws Exception {
        this.checkConnectionAndDialect();
        try {
            JdbcOperator.execute(this.conn, this.dialect, dML);
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeDelete(Delete delete) throws Exception {
        this.checkConnectionAndDialect();
        try {
            int n2 = JdbcOperator.executeDelete(this.conn, this.dialect, delete);
            return n2;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Update update) throws Exception {
        this.checkConnectionAndDialect();
        try {
            int n2 = JdbcOperator.executeUpdate(this.conn, this.dialect, update);
            return n2;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    private void checkConnectionAndDialect() {
        if (this.conn == null) {
            throw new RuntimeException("No Connection!");
        }
        if (this.dialect == null) {
            throw new RuntimeException("No Dialect!");
        }
    }
}

