/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.dao.DAOSession;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.FieldValueGetter;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.SortInfo;
import com.fr.stable.StableUtils;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DaoMapperUtils {
    public static Select createAllSelect(ObjectTableMapper objectTableMapper, SortInfo sortInfo) {
        Select select = new Select(objectTableMapper.getTable(), null);
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            select.addColumnName(fieldColumnMapperArray[i2].getColumnName());
        }
        if (sortInfo != null) {
            sortInfo.createOrderBy(select, objectTableMapper);
        }
        return select;
    }

    public static Select createSelectAllByMoreInfo(ObjectTableMapper objectTableMapper, Map map, DAOSession dAOSession) throws Exception {
        Select select = DaoMapperUtils.createAllSelect(objectTableMapper, null);
        Where where = new Where();
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            bl = true;
            Map.Entry entry = iterator.next();
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName((String)entry.getKey());
            if (fieldColumnMapper == null) {
                throw new RuntimeException((String)entry.getKey() + " can not matched in mapping info.");
            }
            Object object = fieldColumnMapper.field2Value(entry.getValue(), dAOSession);
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, object);
        }
        if (bl) {
            select.setWhere(where);
        }
        return select;
    }

    public static Delete createAllDelete(ObjectTableMapper objectTableMapper) {
        Delete delete = new Delete(objectTableMapper.getTable());
        return delete;
    }

    public static Delete createDeleteByPrimaryKey(long l2, ObjectTableMapper objectTableMapper) {
        Delete delete = new Delete(objectTableMapper.getTable());
        Where where = new Where();
        FieldColumnMapper fieldColumnMapper = objectTableMapper.getPrimaryKey();
        where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, new Long(l2));
        delete.setWhere(where);
        return delete;
    }

    public static Delete createDeleteByField(String string, Object object, ObjectTableMapper objectTableMapper, DAOSession dAOSession) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(string);
        if (fieldColumnMapper == null) {
            throw new IllegalArgumentException("FieldName " + string + " can not matched in this mapping info.");
        }
        return DaoMapperUtils.createDeleteByFCMapper(fieldColumnMapper, object, objectTableMapper, dAOSession);
    }

    public static Delete createDeleteByColumn(String string, Object object, ObjectTableMapper objectTableMapper, DAOSession dAOSession) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByColumnName(string);
        if (fieldColumnMapper == null) {
            throw new IllegalArgumentException("FieldName " + string + " can not matched in this mapping info.");
        }
        return DaoMapperUtils.createDeleteByFCMapper(fieldColumnMapper, object, objectTableMapper, dAOSession);
    }

    private static Delete createDeleteByFCMapper(FieldColumnMapper fieldColumnMapper, Object object, ObjectTableMapper objectTableMapper, DAOSession dAOSession) throws Exception {
        Delete delete = new Delete(objectTableMapper.getTable());
        Where where = new Where();
        where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, fieldColumnMapper.field2Value(object, dAOSession));
        delete.setWhere(where);
        return delete;
    }

    public static Delete createDeleteByInfo(ObjectTableMapper objectTableMapper, Map map, DAOSession dAOSession) throws Exception {
        Delete delete = new Delete(objectTableMapper.getTable());
        if (map == null || map.size() == 0) {
            return delete;
        }
        Where where = new Where();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(entry.getKey().toString());
            if (fieldColumnMapper == null) {
                throw new IllegalArgumentException("FieldName " + entry.getKey().toString() + " can not matched in this mapping info.");
            }
            where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, fieldColumnMapper.field2Value(entry.getValue(), dAOSession));
        }
        delete.setWhere(where);
        return delete;
    }

    public static Select createLoadSelect(FieldColumnMapper fieldColumnMapper, Object object, ObjectTableMapper objectTableMapper, DAOSession dAOSession) throws Exception {
        if (fieldColumnMapper == null) {
            throw new RuntimeException("Mapper info can not be null!");
        }
        Object object2 = fieldColumnMapper.field2Value(object, dAOSession);
        return DaoMapperUtils.createSelectByInfo(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), object2, 0, objectTableMapper, false);
    }

    public static Select createSelectByField(String string, Object object, int n2, ObjectTableMapper objectTableMapper, DAOSession dAOSession, boolean bl) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(string);
        return DaoMapperUtils.createSelectByFCMapper(fieldColumnMapper, object, n2, objectTableMapper, dAOSession, bl);
    }

    public static Select createSelectByColumn(String string, Object object, int n2, ObjectTableMapper objectTableMapper, DAOSession dAOSession, boolean bl) throws Exception {
        FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByColumnName(string);
        return DaoMapperUtils.createSelectByFCMapper(fieldColumnMapper, object, n2, objectTableMapper, dAOSession, bl);
    }

    private static Select createSelectByFCMapper(FieldColumnMapper fieldColumnMapper, Object object, int n2, ObjectTableMapper objectTableMapper, DAOSession dAOSession, boolean bl) throws Exception {
        if (fieldColumnMapper == null) {
            throw new RuntimeException("No FieldColumnMapper can find !");
        }
        object = fieldColumnMapper.field2Value(object, dAOSession);
        return DaoMapperUtils.createSelectByInfo(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), object, n2, objectTableMapper, bl);
    }

    public static Select createSelectByInfo(String string, int n2, Object object, int n3, ObjectTableMapper objectTableMapper, boolean bl) {
        FieldColumnMapper[] fieldColumnMapperArray;
        Select select;
        if (bl) {
            select = new Select(objectTableMapper.getTable(), null);
            fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
            for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                if (fieldColumnMapperArray[i2].getColumnName() == null || fieldColumnMapperArray[i2].getColumnName().equals(string)) continue;
                select.addColumnName(fieldColumnMapperArray[i2].getColumnName());
            }
        } else {
            select = DaoMapperUtils.createAllSelect(objectTableMapper, null);
        }
        fieldColumnMapperArray = new Where();
        fieldColumnMapperArray.addColumn(string, n2, n3, object);
        select.setWhere((Where)fieldColumnMapperArray);
        return select;
    }

    public static String createSelectSQLByListFiledValue(Map map, ObjectTableMapper objectTableMapper, Dialect dialect, DAOSession dAOSession) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        boolean bl = false;
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(dialect.column2SQL(fieldColumnMapperArray[i2].getColumnName()));
            bl = true;
        }
        stringBuffer.append("  FROM ");
        stringBuffer.append(dialect.table2SQL(objectTableMapper.getTable()));
        stringBuffer.append(" ");
        if (map == null || map.size() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("WHERE ");
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v2 = entry.getValue();
            if (!bl2) {
                stringBuffer.append(" and ");
            }
            bl2 = false;
            FieldColumnMapper fieldColumnMapper = objectTableMapper.findFCMapperByFieldName(entry.getKey().toString());
            if (v2 instanceof Object[]) {
                Object[] objectArray = (Object[])v2;
                if (objectArray.length == 0) {
                    return null;
                }
                stringBuffer.append(dialect.column2SQL(fieldColumnMapper.getColumnName()));
                stringBuffer.append(" in (");
                int n2 = objectArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (i3 != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(DaoMapperUtils.createValueSql(fieldColumnMapper.field2Value(objectArray[i3], dAOSession)));
                }
                stringBuffer.append(")");
            } else {
                stringBuffer.append(dialect.column2SQL(fieldColumnMapper.getColumnName()));
                stringBuffer.append(" = ");
                stringBuffer.append(DaoMapperUtils.createValueSql(fieldColumnMapper.field2Value(v2, dAOSession)));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String createValueSql(Object object) {
        if (object instanceof String) {
            return "'" + object.toString() + "'";
        }
        return object.toString();
    }

    public static Insert createInsert(ObjectTableMapper objectTableMapper, FieldValueGetter fieldValueGetter, boolean bl, DAOSession dAOSession) throws Exception {
        if (objectTableMapper == null) {
            return null;
        }
        Insert insert = new Insert(objectTableMapper.getTable());
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            String string = fieldColumnMapperArray[i2].getColumnName();
            int n2 = fieldColumnMapperArray[i2].getType();
            Object object = fieldValueGetter.getFieldValue(fieldColumnMapperArray[i2].getFieldName());
            if (fieldColumnMapperArray[i2].isPrimaryKey() && DaoMapperUtils.isNegative(object) || (object = fieldColumnMapperArray[i2].field2Value(object, dAOSession)) == null) continue;
            insert.addColumn(string, n2, object);
        }
        return insert;
    }

    private static boolean isNegative(Object object) {
        if (object instanceof Long) {
            return (Long)object < 0L;
        }
        if (object instanceof Integer) {
            return (Integer)object < 0;
        }
        if (object instanceof String) {
            return Long.valueOf((String)object) < 0L;
        }
        return false;
    }

    public static Update createUpdate(Object object, ObjectTableMapper objectTableMapper, DAOSession dAOSession) throws Exception {
        Update update = new Update(objectTableMapper.getTable());
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        FieldColumnMapper fieldColumnMapper = null;
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            if (fieldColumnMapperArray[i2].isPrimaryKey()) {
                fieldColumnMapper = fieldColumnMapperArray[i2];
                continue;
            }
            Object object2 = StableUtils.getPrivateFieldValue(object, fieldColumnMapperArray[i2].getFieldName());
            object2 = fieldColumnMapperArray[i2].field2Value(object2, dAOSession);
            update.addColumn(fieldColumnMapperArray[i2].getColumnName(), fieldColumnMapperArray[i2].getType(), object2);
        }
        if (fieldColumnMapper == null) {
            return null;
        }
        Where where = new Where();
        where.addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, StableUtils.getPrivateFieldValue(object, fieldColumnMapper.getFieldName()));
        update.setWhere(where);
        return update;
    }

    public static Update createUpdate(ObjectTableMapper objectTableMapper, Map map, FieldColumnMapper fieldColumnMapper, Object object, DAOSession dAOSession) throws Exception {
        Object object2;
        Update update = new Update(objectTableMapper.getTable());
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            object2 = objectTableMapper.findFCMapperByFieldName(entry.getKey().toString());
            if (object2 == null) {
                throw new IllegalArgumentException("FieldName " + entry.getKey().toString() + " can not matched in this mapping info.");
            }
            Object object3 = entry.getValue();
            object3 = object2.field2Value(object3, dAOSession);
            update.addColumn(object2.getColumnName(), object2.getType(), object3);
        }
        object2 = new Where();
        ((Where)object2).addColumn(fieldColumnMapper.getColumnName(), fieldColumnMapper.getType(), 0, object);
        update.setWhere((Where)object2);
        return update;
    }

    public static Object extractResultSet(ResultSet resultSet, Class clazz, ObjectTableMapper objectTableMapper, DAOSession dAOSession) throws Exception {
        Object t2 = clazz.newInstance();
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
            if (fieldColumnMapperArray[i2].getColumnName() == null) continue;
            Object object = null;
            object = fieldColumnMapperArray[i2].getType() == 12 ? resultSet.getString(fieldColumnMapperArray[i2].getColumnName()) : resultSet.getObject(fieldColumnMapperArray[i2].getColumnName());
            if ((object = fieldColumnMapperArray[i2].value2Field(object, dAOSession.getManager().startSession())) == null) continue;
            object = dAOSession.convertDBValueToFieldValue(object, fieldColumnMapperArray[i2].getType());
            StableUtils.setPrivateFieldValue(t2, fieldColumnMapperArray[i2].getFieldName(), object);
        }
        return t2;
    }
}

