/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.handler;

import com.fr.cache.Attachment;
import com.fr.data.core.db.BinaryObject;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.Primitive;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.imageio.ImageIO;

public class BlobTypeHandler
implements SQLTypeHandler {
    private static final Image DEFAULT_IMAGE = GeneralUtils.readImage("/com/fr/base/images/image.png");
    private int defaultSize = 32768;

    public void setValue(PreparedStatement preparedStatement, int n2, Object object, int n3) throws SQLException {
        byte[] byArray = new byte[]{};
        if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else if (object instanceof Attachment) {
            byArray = ((Attachment)object).getBytes();
        } else if (object instanceof InputStream || object instanceof Blob) {
            if (object instanceof Blob) {
                object = ((Blob)object).getBinaryStream();
            }
            try {
                int n4;
                byte[] byArray2 = new byte[this.defaultSize];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n4 = ((InputStream)object).read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n4);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        } else if (object instanceof BufferedImage) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                if (ImageIO.write((RenderedImage)((BufferedImage)object), "png", byteArrayOutputStream)) {
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        } else {
            byArray = object instanceof BinaryObject ? ((BinaryObject)object).getBytes() : ("" + object).getBytes();
        }
        this.setBinaryStream(preparedStatement, n2, byArray);
    }

    private void setBinaryStream(PreparedStatement preparedStatement, int n2, byte[] byArray) throws SQLException {
        if (byArray.length == 0) {
            this.setNullBinaryStream(preparedStatement, n2);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(n2, (InputStream)byteArrayInputStream, byArray.length);
        }
    }

    private void setNullBinaryStream(PreparedStatement preparedStatement, int n2) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(" ".getBytes());
        preparedStatement.setBinaryStream(n2, (InputStream)byteArrayInputStream, 0);
    }

    public Object getValue(ResultSet resultSet, int n2, int n3) throws SQLException {
        if (n3 == 2004) {
            return resultSet.getBlob(n2);
        }
        try {
            InputStream inputStream = resultSet.getBinaryStream(n2);
            if (inputStream == null) {
                return Primitive.NULL;
            }
            return new BinaryObject(GeneralUtils.inputStream2Bytes(inputStream));
        }
        catch (Throwable throwable) {
            return DEFAULT_IMAGE;
        }
    }
}

