/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.cache.list.IntList;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.InsertOrUpdate;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.write.config.ColumnConfig;
import com.fr.write.config.DMLConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Insert
extends InsertOrUpdate {
    private Map columnNameExpressionMap = new HashMap();

    public Insert(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Insert(Table table, Dialect dialect) {
        super(table, dialect);
    }

    public void putSelfInCreaseColumn2Map(DMLConfig dMLConfig, Map map, Connection connection) {
        if (map != null) {
            int n2;
            String string = null;
            int n3 = dMLConfig.getColumnConfigCount();
            for (n2 = 0; n2 < n3; ++n2) {
                ColumnConfig columnConfig = dMLConfig.getColumnConfig(n2);
                if (!columnConfig.isKey()) continue;
                string = columnConfig.getColumnName();
                break;
            }
            if (string != null) {
                Object object;
                n2 = 0;
                int n4 = this.getColumnCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    if (!ComparatorUtils.equals(this.getColumnName(n3), string)) continue;
                    n2 = this.getColumnType(n3);
                    break;
                }
                if ((object = this.findRecordInsertedBySelfincreaseKey(string, n2, this.dialect, connection)) != null) {
                    map.putAll(this.findRecordByKeyAndValue(string, object, connection, this.dialect));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map findRecordByKeyAndValue(String string, Object object, Connection connection, Dialect dialect) {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        HashMap<String, Object> hashMap;
        block6: {
            hashMap = new HashMap<String, Object>();
            String[] stringArray = DBUtils.checkInColumnNames(connection, DataCoreUtils.createSelectSQL(this.getTable(), null, dialect));
            if (stringArray.length == 0) {
                return hashMap;
            }
            Where where = new Where();
            where.addColumn(string, object);
            Select select = new Select(this.getTable(), where, dialect);
            resultSet = null;
            preparedStatement = null;
            try {
                preparedStatement = select.createPreparedStatement(connection);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashMap.put(stringArray[i2], resultSet.getObject(stringArray[i2]));
                }
            }
            catch (SQLException sQLException) {
                try {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(preparedStatement);
                    throw throwable;
                }
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(preparedStatement);
            }
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return hashMap;
    }

    private Object findRecordInsertedBySelfincreaseKey(String string, int n2, Dialect dialect, Connection connection) {
        Object object = null;
        try {
            String string2 = dialect.getIdentitySelectString(dialect.table2SQL(this.getTable()), string, n2);
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            object = resultSet.getObject(1);
            preparedStatement.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return object;
    }

    public boolean isUpdate() {
        return false;
    }

    public PreparedStatement createPreparedStatementByValidatedParameters(Connection connection) throws SQLException {
        IntList intList = new IntList();
        String string = this.generateSql(intList);
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = this.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (DBUtils.isNULL(this.getColumnValue(i2)) || StringUtils.isEmpty(this.getColumnValue(i2).toString())) continue;
            ++n2;
        }
        for (Map.Entry entry : this.columnNameExpressionMap.entrySet()) {
            if (DBUtils.isNULL(entry.getValue()) || StringUtils.isEmpty(entry.getValue().toString())) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string.toString());
        this.fillStatement(connection, intList, preparedStatement);
        return preparedStatement;
    }

    private String generateSql(IntList intList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = this.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.skipColumn(i2)) continue;
            arrayList.add(this.dialect.column2SQL(this.getColumnName(i2)));
            arrayList2.add("?");
            intList.add(i2);
        }
        Iterator iterator = this.columnNameExpressionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            arrayList.add(this.dialect.column2SQL((String)entry.getKey()));
            arrayList2.add((String)entry.getValue());
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        if (this.validColumnsNum(iterator) == 0) {
            return null;
        }
        String string = "INSERT INTO " + this.getTable().toStatementSQLString(this.dialect) + " (" + StableUtils.join(arrayList, ",") + ")" + " VALUES (" + StableUtils.join(arrayList2, ",") + ")";
        return string;
    }

    private void fillStatement(Connection connection, IntList intList, PreparedStatement preparedStatement) throws SQLException {
        for (int i2 = 0; i2 < intList.size(); ++i2) {
            int n2 = intList.get(i2);
            DBUtils.applyColumnTypeValue(this.dialect, connection, this.getTable(), this.getColumnName(n2), preparedStatement, i2 + 1, this.getColumnType(n2), this.getColumnValue(n2));
        }
    }

    private boolean skipColumn(int n2) {
        if (DBUtils.isNULL(this.getColumnValue(n2))) {
            return true;
        }
        return this.getColumnValue(n2) != null && this.getColumnValue(n2).toString().length() == 0 && this.getColumnType(n2) == -1;
    }

    private int validColumnsNum(Iterator iterator) {
        int n2 = 0;
        int n3 = this.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (DBUtils.isNULL(this.getColumnValue(i2)) || StringUtils.isEmpty(this.getColumnValue(i2).toString())) continue;
            ++n2;
        }
        Iterator iterator2 = this.columnNameExpressionMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (DBUtils.isNULL(entry.getValue()) || StringUtils.isEmpty(entry.getValue().toString())) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection);
        try {
            if (preparedStatement != null) {
                int n2 = preparedStatement.executeUpdate();
                return n2;
            }
        }
        finally {
            DBUtils.closeStatement(preparedStatement);
        }
        return 0;
    }
}

