/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.data.SimpleDSColumn;
import com.fr.data.impl.NameTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONObject;
import com.fr.json.JSONTransform;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class Compare
implements XMLable,
Serializable,
Cloneable,
JSONTransform {
    public static final String XML_TAG = "Compare";
    public static final int EQUALS = 0;
    public static final int NOT_EQUAL = 1;
    public static final int GREATER_THAN = 2;
    public static final int GREATER_THAN_OR_EQUAL = 3;
    public static final int LESS_THAN = 4;
    public static final int LESS_THAN_OR_EQUAL = 5;
    public static final int BEGINS_WITH = 6;
    public static final int NOT_BEGIN_WITH = 7;
    public static final int ENDS_WITH = 8;
    public static final int NOT_END_WITH = 9;
    public static final int CONTAINS = 10;
    public static final int NOT_CONTAIN = 11;
    public static final int IN = 12;
    public static final int NOT_IN = 13;
    public static final int NULL = 14;
    public static final int NOT_NULL = 15;
    private int op;
    private Object value;

    public Compare() {
    }

    public Compare(int n2, Object object) {
        this.setOp(n2);
        this.setValue(object);
    }

    public int getOp() {
        return this.op;
    }

    public void setOp(int n2) {
        this.op = n2;
    }

    public Object getValue() {
        return this.value;
    }

    public String[] getDependence() {
        if (this.value instanceof ParameterProvider) {
            return new String[]{((ParameterProvider)this.value).getName()};
        }
        return new String[0];
    }

    public String getValue2String(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value instanceof Date) {
            stringBuffer.append(' ');
            stringBuffer.append(DateUtils.DATEFORMAT2.format((Date)this.value));
        } else if (this.value instanceof ParameterProvider) {
            if (bl) {
                stringBuffer.append(((ParameterProvider)this.value).valueToString());
            } else {
                stringBuffer.append('$').append(((ParameterProvider)this.value).getName());
            }
        } else if (this.value == Primitive.NULL) {
            stringBuffer.append(" null");
        } else if (this.value instanceof Number) {
            stringBuffer.append(' ');
            stringBuffer.append(this.value);
        } else {
            stringBuffer.append(" '");
            stringBuffer.append(this.value);
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    public void setValue(Object object) {
        this.value = object == null ? Primitive.NULL : (object.toString().equalsIgnoreCase("nofilter") ? Primitive.NOFILTER : object);
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        if (this.value instanceof FormulaProvider) {
            ((FormulaProvider)this.value).modColumnRow(modColumnRowProvider);
        } else if (this.value instanceof ColumnRow) {
            this.value = modColumnRowProvider.mod_columnrow((ColumnRow)this.value);
        }
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        exTool.setCreateRelation(true);
        if (this.value instanceof FormulaProvider) {
            calculatorProvider.exStatement(columnRow, ((FormulaProvider)this.value).getPureContent());
        } else if (this.value instanceof ColumnRow) {
            calculatorProvider.exStatement(columnRow, this.value.toString());
        }
        exTool.setCreateRelation(false);
    }

    public void fm2Value(Calculator calculator) {
        if (this.value instanceof FormulaProvider) {
            FormulaProvider formulaProvider = (FormulaProvider)this.value;
            StableUtils.dealFormulaValue(formulaProvider, calculator);
            if (formulaProvider.getResult() != null) {
                this.setValue(formulaProvider.getResult());
            }
        } else if (this.value instanceof ParameterProvider) {
            ParameterProvider parameterProvider = (ParameterProvider)this.value;
            parameterProvider.setValue(calculator.resolveVariable(parameterProvider.getName()));
        } else if (this.value instanceof ColumnRow) {
            this.value = calculator.resolveVariable(this.value);
        } else if (this.value instanceof SimpleDSColumn) {
            FArray fArray = null;
            SimpleDSColumn simpleDSColumn = (SimpleDSColumn)this.value;
            NameTableData nameTableData = new NameTableData(simpleDSColumn.getDsName());
            DataModel dataModel = nameTableData.createDataModel(calculator);
            int n2 = simpleDSColumn.getColumn().getColumnIndex(dataModel, calculator);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                int n3 = dataModel.getRowCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    arrayList.add(dataModel.getValueAt(i2, n2));
                }
                fArray = new FArray(arrayList.toArray());
                this.setValue(fArray);
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Compare)) {
            return false;
        }
        Compare compare = (Compare)object;
        return compare.getOp() == this.getOp() && ComparatorUtils.equals(compare.getValue(), this.getValue());
    }

    public boolean eval(Object object) {
        Object object2 = this.getValue();
        if (object2 instanceof ParameterProvider) {
            object2 = ((ParameterProvider)object2).getValue();
        }
        if (object instanceof FormulaProvider) {
            object = ((FormulaProvider)object).getResult();
        }
        if (object == null) {
            object = Primitive.NULL;
        }
        if (object2 == null) {
            object2 = Primitive.NULL;
        }
        if (object2 == Primitive.NOFILTER || object == Primitive.NOFILTER) {
            return true;
        }
        switch (this.getOp()) {
            case 0: {
                return this.valueEQ(object, object2);
            }
            case 1: {
                return this.valueNE(object, object2);
            }
            case 2: {
                return ComparatorUtils.compare(object, object2) > 0;
            }
            case 3: {
                return ComparatorUtils.compare(object, object2) >= 0;
            }
            case 4: {
                return ComparatorUtils.compare(object, object2) < 0;
            }
            case 5: {
                return ComparatorUtils.compare(object, object2) <= 0;
            }
            case 6: {
                return this.valueBW(object, object2);
            }
            case 7: {
                return this.valueNBW(object, object2);
            }
            case 8: {
                return this.valueEW(object, object2);
            }
            case 9: {
                return this.valueNEW(object, object2);
            }
            case 10: {
                return this.valueCT(object, object2);
            }
            case 11: {
                return this.valueNCT(object, object2);
            }
            case 12: {
                return ComparatorUtils.arg1InArg2(object, object2);
            }
            case 13: {
                return this.valueNI(object, object2);
            }
        }
        return true;
    }

    private boolean valueEQ(Object object, Object object2) {
        if (object2 instanceof FArray) {
            FArray fArray = (FArray)object2;
            if (fArray.length() > 0) {
                if (fArray.toList().contains(object)) {
                    return true;
                }
            } else {
                object2 = Primitive.NOFILTER;
            }
        }
        return ComparatorUtils.equals(object, object2);
    }

    private boolean valueNE(Object object, Object object2) {
        if (object2 instanceof FArray) {
            object2 = ((FArray)object2).length() > 0 ? ((FArray)object2).elementAt(0) : null;
        }
        return !ComparatorUtils.equals(object, object2);
    }

    private boolean valueBW(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return object.toString().startsWith(object2.toString());
    }

    private boolean valueNBW(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return !object.toString().startsWith(object2.toString());
    }

    private boolean valueEW(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return object.toString().endsWith(object2.toString());
    }

    private boolean valueNEW(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return !object.toString().endsWith(object2.toString());
    }

    private boolean valueCT(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return StringUtils.contains(object.toString(), object2.toString());
    }

    private boolean valueNCT(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        return !StringUtils.contains(object.toString(), object2.toString());
    }

    private boolean valueNI(Object object, Object object2) {
        if (object2 instanceof FArray) {
            FArray fArray = (FArray)object2;
            int n2 = fArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!ComparatorUtils.equals(object, fArray.elementAt(i2))) continue;
                return false;
            }
            return true;
        }
        if (object instanceof String && object2 instanceof String) {
            return !StringUtils.contains((String)object2, (String)object);
        }
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr() || XML_TAG.equals(xMLableReader.getTagName())) {
            this.setOp(xMLableReader.getAttrAsInt("op", 0));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("ColumnRow")) {
                int n2 = xMLableReader.getAttrAsInt("column", 0);
                int n3 = xMLableReader.getAttrAsInt("row", 0);
                this.setValue(ColumnRow.valueOf(n2, n3));
            } else if (string.equals("AnDSColumn") || string.equals("SimpleDSColumn")) {
                SimpleDSColumn simpleDSColumn = new SimpleDSColumn();
                xMLableReader.readXMLObject(simpleDSColumn);
                this.setValue(simpleDSColumn);
            } else if ("Parameter".equals(string)) {
                this.setValue(StableXMLUtils.readParameter(xMLableReader));
            } else if ("Object".equals(string) || "O".equals(string)) {
                this.setValue(GeneralXMLTools.readObject(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("op", this.getOp());
        Object object = this.getValue();
        if (object instanceof ColumnRow) {
            ColumnRow columnRow = (ColumnRow)object;
            StableXMLUtils.writeColumnRow(xMLPrintWriter, columnRow);
        } else if (object instanceof ParameterProvider) {
            StableXMLUtils.writeParameter(xMLPrintWriter, (ParameterProvider)object);
        } else if (object instanceof SimpleDSColumn) {
            ((SimpleDSColumn)object).writeXML(xMLPrintWriter);
        } else {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.getValue());
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("op", this.getOp());
        if (this.getValue() instanceof String) {
            jSONObject.put("type", "string");
            jSONObject.put("value", (String)this.getValue());
        } else if (this.getValue() instanceof Integer) {
            jSONObject.put("type", "number");
            jSONObject.put("value", (Integer)this.getValue());
        } else if (this.getValue() instanceof Double) {
            jSONObject.put("type", "number");
            jSONObject.put("value", (Double)this.getValue());
        } else if (this.getValue() instanceof Date) {
            jSONObject.put("type", "date");
            jSONObject.put("value", DateUtils.DATEFORMAT2.format(this.getValue()));
        } else if (this.getValue() instanceof Boolean) {
            jSONObject.put("type", "boolean");
            jSONObject.put("value", (Boolean)this.getValue());
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("op")) {
            this.setOp(jSONObject.getInt("op"));
        }
        if (jSONObject.has("value")) {
            if (ComparatorUtils.equals(jSONObject.getString("type"), "string")) {
                this.setValue(jSONObject.getString("value"));
            } else if (ComparatorUtils.equals(jSONObject.getString("type"), "int")) {
                this.setValue(jSONObject.getInt("value"));
            } else if (ComparatorUtils.equals(jSONObject.getString("type"), "double") || ComparatorUtils.equals(jSONObject.getString("type"), "number")) {
                this.setValue(jSONObject.getDouble("value"));
            } else if (ComparatorUtils.equals(jSONObject.getString("type"), "date")) {
                this.setValue(DateUtils.DATEFORMAT2.parse(jSONObject.getString("value")));
            } else if (ComparatorUtils.equals(jSONObject.getString("type"), "boolean")) {
                this.setValue(jSONObject.getBoolean("value"));
            }
        }
    }

    public static String operator2String(int n2) {
        switch (n2) {
            case 0: {
                return Inter.getLocText("ConditionB-equals");
            }
            case 1: {
                return Inter.getLocText("ConditionB-does_not_equal_to");
            }
            case 2: {
                return Inter.getLocText("ConditionB-is_greater_than");
            }
            case 3: {
                return Inter.getLocText("ConditionB-is_greater_than_or_equal_to");
            }
            case 4: {
                return Inter.getLocText("ConditionB-is_less_than");
            }
            case 5: {
                return Inter.getLocText("ConditionB-is_less_than_or_equal_to");
            }
            case 6: {
                return Inter.getLocText("ConditionB-begins_with");
            }
            case 7: {
                return Inter.getLocText("ConditionB-does_not_begin_with");
            }
            case 8: {
                return Inter.getLocText("ConditionB-ends_with");
            }
            case 9: {
                return Inter.getLocText("ConditionB-does_not_end_with");
            }
            case 10: {
                return Inter.getLocText("ConditionB-contains");
            }
            case 11: {
                return Inter.getLocText("ConditionB-does_not_contain");
            }
            case 12: {
                return Inter.getLocText("ConditionB-in");
            }
            case 13: {
                return Inter.getLocText("ConditionB-does_not_in");
            }
            case 14: {
                return Inter.getLocText("ConditionB-null");
            }
            case 15: {
                return Inter.getLocText("ConditionB-not_null");
            }
        }
        return "";
    }

    public static int[] getAllOperators() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    }

    public static int[] getDimensionOperators() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 10, 11, 12, 13};
    }

    public static int[] getMeasureOperators() {
        return new int[]{0, 1, 2, 3, 4, 5, 12, 13};
    }

    public static int[] getFineBIStringOperators() {
        return new int[]{15, 14, 13, 12, 11, 10, 6, 8};
    }

    public static int[] getFineBIOtherOperators() {
        return new int[]{15, 14, 13, 12};
    }

    public static int[] getFineBILessOperators() {
        return new int[]{4, 5};
    }

    public String toString() {
        return Compare.operator2String(this.getOp()) + this.getValue2String(false);
    }
}

