/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.cache.list.IntList;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.JoinCondition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListCondition
extends AbstractCondition {
    private List joinConditionList;

    public ListCondition() {
        this.joinConditionList = new ArrayList();
    }

    public ListCondition(List list) {
        this.joinConditionList = list;
    }

    public int getJoinConditionCount() {
        return this.joinConditionList.size();
    }

    public void addCondition(Condition condition) {
        this.addJoinCondition(new JoinCondition(0, condition));
    }

    public void addJoinCondition(int n2, Condition condition) {
        this.addJoinCondition(new JoinCondition(n2, condition));
    }

    public void addJoinCondition(JoinCondition joinCondition) {
        Condition condition = joinCondition.getCondition();
        if (condition == null) {
            return;
        }
        if (condition instanceof ListCondition && ((ListCondition)condition).getJoinConditionCount() == 0) {
            return;
        }
        this.joinConditionList.add(joinCondition);
    }

    public JoinCondition getJoinCondition(int n2) {
        if (n2 < 0 || n2 >= this.joinConditionList.size()) {
            return null;
        }
        return (JoinCondition)this.joinConditionList.get(n2);
    }

    public void setJoinCondition(int n2, JoinCondition joinCondition) {
        this.joinConditionList.set(n2, joinCondition);
    }

    public void clearJoinConditions() {
        this.joinConditionList.clear();
    }

    public String[] getDependence() {
        Object[] objectArray = new String[]{};
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            Condition condition = ((JoinCondition)iterator.next()).getCondition();
            objectArray = (String[])ArrayUtils.addAll(objectArray, condition.getDependence());
        }
        return objectArray;
    }

    public void modColumnRow(ModColumnRowProvider modColumnRowProvider) {
        for (Object e2 : this.joinConditionList) {
            ((JoinCondition)e2).getCondition().modColumnRow(modColumnRowProvider);
        }
    }

    public void formula2Value(Calculator calculator) {
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            ((AbstractCondition)((JoinCondition)iterator.next()).getCondition()).formula2Value(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        Iterator iterator = this.joinConditionList.iterator();
        while (iterator.hasNext()) {
            ((AbstractCondition)((JoinCondition)iterator.next()).getCondition()).buidExecuteSequenceList(list, calculator);
        }
    }

    public boolean eval(Object object, CalculatorProvider calculatorProvider) {
        return this.inner_eval(object, calculatorProvider);
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        int n2 = this.getJoinConditionCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getJoinCondition(i2).analyzeCorrelative(calculatorProvider, exTool, columnRow);
        }
    }

    public int[] evalTableData(DataModel dataModel, int[] nArray, int n2, CalculatorProvider calculatorProvider) {
        int[] nArray2 = new int[]{};
        if (dataModel == null) {
            return nArray2;
        }
        int n3 = 0;
        try {
            n3 = dataModel.getRowCount();
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        nArray2 = nArray == null ? IntList.range(n3) : nArray;
        int n4 = this.getJoinConditionCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            JoinCondition joinCondition = this.getJoinCondition(i2);
            Condition condition = joinCondition.getCondition();
            if (i2 == 0 || joinCondition.getJoin() == 0) {
                nArray2 = condition.evalTableData(dataModel, nArray2, n2, calculatorProvider);
                continue;
            }
            if (joinCondition.getJoin() != 1) continue;
            nArray2 = IntList.unionArray(nArray2, condition.evalTableData(dataModel, nArray, n2, calculatorProvider));
        }
        return nArray2;
    }

    private boolean inner_eval(Object object, CalculatorProvider calculatorProvider) {
        int n2 = this.getJoinConditionCount();
        if (n2 <= 0) {
            return true;
        }
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            JoinCondition joinCondition = this.getJoinCondition(i2);
            int n3 = joinCondition.getJoin();
            Condition condition = joinCondition.getCondition();
            bl = i2 == 0 ? condition.eval(object, calculatorProvider) : (n3 == 0 ? bl && condition.eval(object, calculatorProvider) : bl || condition.eval(object, calculatorProvider));
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.joinConditionList.size(); ++i2) {
            JoinCondition joinCondition = (JoinCondition)this.joinConditionList.get(i2);
            if (i2 != 0) {
                if (joinCondition.getJoin() == 0) {
                    stringBuffer.append(" and ");
                } else {
                    stringBuffer.append(" or ");
                }
            }
            if (joinCondition.getCondition() == null) continue;
            stringBuffer.append(joinCondition.getCondition().toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListCondition)) {
            return false;
        }
        ListCondition listCondition = (ListCondition)object;
        if (listCondition.getJoinConditionCount() != this.getJoinConditionCount()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getJoinConditionCount(); ++i2) {
            if (ComparatorUtils.equals(listCondition.getJoinCondition(i2), this.getJoinCondition(i2))) continue;
            return false;
        }
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearJoinConditions();
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("JoinCondition")) {
            JoinCondition joinCondition = new JoinCondition();
            this.joinConditionList.add(joinCondition);
            xMLableReader.readXMLObject(joinCondition);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2 = this.getJoinConditionCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JoinCondition joinCondition = this.getJoinCondition(i2);
            joinCondition.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ListCondition listCondition = (ListCondition)super.clone();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.getJoinConditionCount(); ++i2) {
            arrayList.add(this.getJoinCondition(i2).clone());
        }
        listCondition.joinConditionList = arrayList;
        return listCondition;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = super.createJSON();
        if (this.getJoinConditionCount() > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < this.getJoinConditionCount(); ++i2) {
                jSONArray.put(this.getJoinCondition(i2).getCondition().createJSON());
            }
            jSONObject.put("commonconditions", jSONArray);
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("commonconditions");
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            CommonCondition commonCondition = new CommonCondition();
            commonCondition.parseJSON(jSONArray.getJSONObject(i2));
            this.addCondition(commonCondition);
        }
    }
}

