/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.condition;

import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.stable.ColumnRow;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class JoinCondition
implements XMLable {
    private int join = 0;
    private Condition condition;

    public JoinCondition() {
    }

    public JoinCondition(int n2, Condition condition) {
        this.join = n2;
        this.condition = condition;
    }

    public JoinCondition(Condition condition) {
        this.condition = condition;
    }

    public int getJoin() {
        return this.join;
    }

    public void setJoin(int n2) {
        this.join = n2;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        this.condition.analyzeCorrelative(calculatorProvider, exTool, columnRow);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JoinCondition)) {
            return false;
        }
        JoinCondition joinCondition = (JoinCondition)object;
        return joinCondition.getJoin() == this.getJoin() && ComparatorUtils.equals(joinCondition.getCondition(), this.getCondition());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.join = xMLableReader.getAttrAsInt("join", 0);
        }
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().endsWith("Condition")) {
            this.condition = DataCoreXmlUtils.readXMLCondition(xMLableReader);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JoinCondition").attr("join", this.getJoin());
        DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        JoinCondition joinCondition = (JoinCondition)super.clone();
        joinCondition.join = this.join;
        if (this.condition != null) {
            joinCondition.condition = (Condition)this.condition.clone();
        }
        return joinCondition;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getJoin() == 0) {
            stringBuffer.append("and ");
        } else {
            stringBuffer.append("or  ");
        }
        stringBuffer.append(this.getCondition());
        return stringBuffer.toString();
    }
}

