/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.data.SubmitJob;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.xml.XMLableReader;
import com.fr.write.DMLConfigJob;
import com.fr.write.config.DMLConfig;
import com.fr.write.config.DeleteConfig;
import com.fr.write.config.InsertConfig;
import com.fr.write.config.IntelliDMLConfig;
import com.fr.write.config.UpdateConfig;

public class DataXmlUtils {
    public static SubmitJob readSubmitJob(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if (string == null) {
            return null;
        }
        SubmitJob submitJob = null;
        if (string.endsWith(".DMLConfigJob")) {
            submitJob = new DMLConfigJob();
        } else {
            try {
                submitJob = (SubmitJob)GeneralUtils.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        if (submitJob != null) {
            xMLableReader.readXMLObject(submitJob);
        }
        return submitJob;
    }

    public static DMLConfig readDMLConfig(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if (string == null) {
            return null;
        }
        DMLConfig dMLConfig = null;
        if (string.endsWith(".IntelliDMLConfig")) {
            dMLConfig = new IntelliDMLConfig();
        } else if (string.endsWith(".InsertConfig")) {
            dMLConfig = new InsertConfig();
        } else if (string.endsWith(".UpdateConfig")) {
            dMLConfig = new UpdateConfig();
        } else if (string.endsWith(".DeleteConfig")) {
            dMLConfig = new DeleteConfig();
        } else {
            try {
                dMLConfig = (DMLConfig)GeneralUtils.classForName(string).newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        if (dMLConfig != null) {
            xMLableReader.readXMLObject(dMLConfig);
        }
        return dMLConfig;
    }
}

