/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.general.ComparatorUtils;
import com.fr.js.ChartHyperlink;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class ChartHyperRelateLink
extends ChartHyperlink {
    private static final long serialVersionUID = -3703142761449130123L;
    private String relateCCName;

    public abstract boolean isRealtedCell();

    public boolean isRealeted() {
        return true;
    }

    public void setRelateCCName(String string) {
        this.relateCCName = string;
    }

    public String getRelateCCName() {
        return this.relateCCName;
    }

    public String getChartOpCmd() {
        return "relate_chart";
    }

    protected String actionJS(Repository repository) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FR.Chart.WebUtils.chart_Change_Parameter(");
        if (this.isRealtedCell()) {
            stringBuffer.append("\"Cells\",");
        } else {
            stringBuffer.append("\"Float\",");
        }
        stringBuffer.append("\"" + this.getRelateCCName() + "\",");
        stringBuffer.append("\"");
        try {
            stringBuffer.append(this.createParaPath(repository));
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append("\");");
        return stringBuffer.toString();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = null;
            if ("realateName".equals(xMLableReader.getTagName())) {
                this.setRelateCCName(xMLableReader.getAttrAsString("realateValue", ""));
            } else if ("RelatedChart".equals(xMLableReader.getTagName()) && ((string = xMLableReader.getAttrAsString("", null)) != null || (string = xMLableReader.getAttrAsString("", null)) != null)) {
                this.setRelateCCName(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("realateName").attr("realateValue", this.relateCCName).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof ChartHyperRelateLink && super.equals(object) && ComparatorUtils.equals(((ChartHyperRelateLink)object).relateCCName, this.relateCCName);
    }
}

